/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.constraint;

import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Student;

public class StudentConflict
extends Constraint<Request, Enrollment> {
    public StudentConflict(Student student) {
        for (Request request : student.getRequests()) {
            this.addVariable(request);
        }
    }

    @Override
    public void computeConflicts(Assignment<Request, Enrollment> assignment, Enrollment enrollment, Set<Enrollment> conflicts) {
        for (Request request : this.variables()) {
            Enrollment e;
            if (request.equals(enrollment.getRequest()) || (e = assignment.getValue(request)) == null || !enrollment.isOverlapping(e)) continue;
            conflicts.add(e);
        }
        if (!enrollment.getAssignments().isEmpty() && !enrollment.getStudent().canAssign(assignment, enrollment.getRequest())) {
            Enrollment lowestPriorityEnrollment = null;
            int lowestPriority = -1;
            for (Request request : this.variables()) {
                Enrollment e;
                if (request.equals(enrollment.getRequest()) || (e = assignment.getValue(request)) == null || lowestPriority >= request.getPriority()) continue;
                lowestPriority = request.getPriority();
                lowestPriorityEnrollment = e;
            }
            if (lowestPriorityEnrollment != null) {
                conflicts.add(lowestPriorityEnrollment);
            }
        }
    }

    @Override
    public boolean isConsistent(Enrollment e1, Enrollment e2) {
        return !e1.isOverlapping(e2);
    }

    @Override
    public boolean inConflict(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
        for (Request request : this.variables()) {
            Enrollment e;
            if (request.equals(enrollment.getRequest()) || (e = assignment.getValue(request)) == null || !enrollment.isOverlapping(e)) continue;
            return true;
        }
        return !enrollment.getStudent().canAssign(assignment, enrollment.getRequest());
    }

    public String toString() {
        return "StudentConflicts";
    }
}

