/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.constraint;

import org.cpsolver.coursett.constraint.SpreadConstraint;
import org.cpsolver.coursett.criteria.DepartmentBalancingPenalty;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.ifs.criteria.Criterion;
import org.cpsolver.ifs.util.DataProperties;

public class DepartmentSpreadConstraint
extends SpreadConstraint {
    private Long iDepartment = null;

    public DepartmentSpreadConstraint(DataProperties config, Long department, String name) {
        super(name, config.getPropertyDouble("DeptBalancing.SpreadFactor", 1.2), config.getPropertyInt("DeptBalancing.Unassignments2Weaken", 250), config.getPropertyBoolean("General.InteractiveMode", false));
        this.iDepartment = department;
    }

    public Long getDepartmentId() {
        return this.iDepartment;
    }

    @Override
    protected Criterion<Lecture, Placement> getCriterion() {
        return this.getModel().getCriterion(DepartmentBalancingPenalty.class);
    }

    @Override
    public String toString() {
        return "Departmental Balancing for " + this.getName();
    }
}

