/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks.locking;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.blocks.locking.AwaitInfo;
import org.jgroups.blocks.locking.LockInfo;
import org.jgroups.blocks.locking.LockNotification;
import org.jgroups.protocols.Locking;

public class LockService {
    protected JChannel ch;
    protected Locking lock_prot;

    public LockService() {
    }

    public LockService(JChannel ch) {
        this.setChannel(ch);
    }

    public void setChannel(JChannel ch) {
        this.ch = ch;
        this.lock_prot = (Locking)ch.getProtocolStack().findProtocol((Class<?>)Locking.class);
        if (this.lock_prot == null) {
            throw new IllegalStateException("Channel configuration must include a locking protocol (subclass of " + Locking.class.getName() + ")");
        }
    }

    public Lock getLock(String lock_name) {
        return new LockImpl(lock_name);
    }

    public void unlockAll() {
        this.ch.down(new Event(97));
    }

    public void addLockListener(LockNotification listener) {
        this.lock_prot.addLockListener(listener);
    }

    public void removeLockListener(LockNotification listener) {
        this.lock_prot.removeLockListener(listener);
    }

    public String printLocks() {
        return this.lock_prot.printLocks();
    }

    private class ConditionImpl
    implements Condition {
        protected final String name;
        protected final AtomicReference<Thread> holder;

        public ConditionImpl(String name, AtomicReference<Thread> holder) {
            this.name = name;
            this.holder = holder;
        }

        @Override
        public void await() throws InterruptedException {
            LockService.this.ch.down(new Event(98, new LockInfo(this.name, false, true, false, 0L, TimeUnit.MILLISECONDS)));
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
        }

        @Override
        public void awaitUninterruptibly() {
            LockService.this.ch.down(new Event(98, new LockInfo(this.name, false, false, false, 0L, TimeUnit.MILLISECONDS)));
        }

        @Override
        public long awaitNanos(long nanosTimeout) throws InterruptedException {
            Long waitLeft = (Long)LockService.this.ch.down(new Event(98, new LockInfo(this.name, false, true, true, nanosTimeout, TimeUnit.NANOSECONDS)));
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            return waitLeft;
        }

        @Override
        public boolean await(long time, TimeUnit unit) throws InterruptedException {
            return this.awaitNanos(unit.toNanos(time)) > 0L;
        }

        @Override
        public boolean awaitUntil(Date deadline) throws InterruptedException {
            long currentTime;
            long waitUntilTime = deadline.getTime();
            long waitTime = waitUntilTime - (currentTime = System.currentTimeMillis());
            return waitTime > 0L && this.await(waitTime, TimeUnit.MILLISECONDS);
        }

        @Override
        public void signal() {
            if (this.holder.get() != Thread.currentThread()) {
                throw new IllegalMonitorStateException();
            }
            LockService.this.ch.down(new Event(99, new AwaitInfo(this.name, false)));
        }

        @Override
        public void signalAll() {
            if (this.holder.get() != Thread.currentThread()) {
                throw new IllegalMonitorStateException();
            }
            LockService.this.ch.down(new Event(99, new AwaitInfo(this.name, true)));
        }
    }

    protected class LockImpl
    implements Lock {
        protected final String name;
        protected final AtomicReference<Thread> holder = new AtomicReference();

        public LockImpl(String name) {
            this.name = name;
        }

        @Override
        public void lock() {
            LockService.this.ch.down(new Event(95, new LockInfo(this.name, false, false, false, 0L, TimeUnit.MILLISECONDS)));
            this.holder.set(Thread.currentThread());
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            LockService.this.ch.down(new Event(95, new LockInfo(this.name, false, true, false, 0L, TimeUnit.MILLISECONDS)));
            Thread currentThread = Thread.currentThread();
            if (currentThread.isInterrupted()) {
                throw new InterruptedException();
            }
            this.holder.set(currentThread);
        }

        @Override
        public boolean tryLock() {
            Boolean retval = (Boolean)LockService.this.ch.down(new Event(95, new LockInfo(this.name, true, false, false, 0L, TimeUnit.MILLISECONDS)));
            this.holder.set(retval != false ? Thread.currentThread() : null);
            return retval;
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            Boolean retval = (Boolean)LockService.this.ch.down(new Event(95, new LockInfo(this.name, true, true, true, time, unit)));
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            this.holder.set(retval != false ? Thread.currentThread() : null);
            return retval;
        }

        @Override
        public void unlock() {
            LockService.this.ch.down(new Event(96, new LockInfo(this.name, false, false, false, 0L, TimeUnit.MILLISECONDS)));
            this.holder.set(null);
        }

        @Override
        public Condition newCondition() {
            return new ConditionImpl(this.name, this.holder);
        }

        public String toString() {
            return this.name + (this.holder.get() == null ? " [unlocked]" : " [held by " + this.holder.get() + "]");
        }
    }
}

