/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.constraint;

import java.util.Set;
import org.cpsolver.coursett.constraint.JenrlConstraint;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.GlobalConstraint;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.DataProperties;

public class NoStudentOnlineConflicts
extends GlobalConstraint<Lecture, Placement> {
    private String iOnlineRoom = null;

    public void setModel(Model<Lecture, Placement> model) {
        super.setModel(model);
        if (model != null && model instanceof TimetableModel) {
            DataProperties config = ((TimetableModel)model).getProperties();
            this.iOnlineRoom = config.getProperty("General.OnlineRoom", "(?i)ONLINE|");
        }
    }

    public void computeConflicts(Assignment<Lecture, Placement> assignment, Placement placement, Set<Placement> conflicts) {
        Lecture lecture = (Lecture)placement.variable();
        for (JenrlConstraint jenrl : lecture.jenrlConstraints()) {
            Placement other;
            if (jenrl.getJenrl() <= 0L || !this.isConsistent(placement, other = (Placement)assignment.getValue(jenrl.another((Variable)lecture)))) continue;
            conflicts.add(other);
        }
    }

    public boolean inConflict(Assignment<Lecture, Placement> assignment, Placement placement) {
        Lecture lecture = (Lecture)placement.variable();
        for (JenrlConstraint jenrl : lecture.jenrlConstraints()) {
            if (jenrl.getJenrl() <= 0L || !this.isConsistent(placement, (Placement)assignment.getValue(jenrl.another((Variable)lecture)))) continue;
            return true;
        }
        return false;
    }

    public boolean isConsistent(Placement p1, Placement p2) {
        if (p1 == null || p2 == null) {
            return false;
        }
        if (p1.getTimeLocation().shareDays(p2.getTimeLocation()) && p1.getTimeLocation().shareWeeks(p2.getTimeLocation())) {
            return this.isOnline(p1) != this.isOnline(p2);
        }
        return false;
    }

    protected boolean isOnline(Placement p) {
        if (this.iOnlineRoom == null) {
            return false;
        }
        if (p.getNrRooms() == 0) {
            return "".matches(this.iOnlineRoom);
        }
        if (p.getNrRooms() == 1) {
            return p.getRoomLocation().getName() != null && p.getRoomLocation().getName().matches(this.iOnlineRoom);
        }
        for (RoomLocation r : p.getRoomLocations()) {
            if (r.getName() != null && r.getName().matches(this.iOnlineRoom)) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return "No Student Online Conflicts";
    }

    public String toString() {
        return "No Student Online Conflicts";
    }
}

