/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.neighbours;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamModel;
import org.cpsolver.exam.model.ExamPeriodPlacement;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.model.ExamRoomPlacement;
import org.cpsolver.exam.neighbours.ExamRoomSwapNeighbour;
import org.cpsolver.exam.neighbours.ExamSimpleNeighbour;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.heuristics.NeighbourSelection;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ToolBox;

public class ExamRoomMove
implements NeighbourSelection<Exam, ExamPlacement> {
    private boolean iCheckStudentConflicts = false;
    private boolean iCheckDistributionConstraints = true;

    public ExamRoomMove(DataProperties properties) {
        this.iCheckStudentConflicts = properties.getPropertyBoolean("ExamRoomMove.CheckStudentConflicts", this.iCheckStudentConflicts);
        this.iCheckDistributionConstraints = properties.getPropertyBoolean("ExamRoomMove.CheckDistributionConstraints", this.iCheckDistributionConstraints);
    }

    public void init(Solver<Exam, ExamPlacement> solver) {
    }

    public Neighbour<Exam, ExamPlacement> selectNeighbour(Solution<Exam, ExamPlacement> solution) {
        Set<ExamRoomPlacement> rooms;
        ExamPeriodPlacement period;
        ExamModel model = (ExamModel)solution.getModel();
        Assignment assignment = solution.getAssignment();
        Exam exam = (Exam)((Object)ToolBox.random((Collection)model.variables()));
        if (exam.getMaxRooms() <= 0) {
            return null;
        }
        ExamPlacement placement = (ExamPlacement)assignment.getValue((Variable)exam);
        ExamPeriodPlacement examPeriodPlacement = period = placement != null ? placement.getPeriodPlacement() : (ExamPeriodPlacement)ToolBox.random(exam.getPeriodPlacements());
        if (this.iCheckStudentConflicts && placement == null && exam.countStudentConflicts((Assignment<Exam, ExamPlacement>)assignment, period) > 0) {
            return null;
        }
        if (this.iCheckDistributionConstraints && placement == null && !exam.checkDistributionConstraints((Assignment<Exam, ExamPlacement>)assignment, period)) {
            return null;
        }
        Set<ExamRoomPlacement> set = rooms = placement != null ? placement.getRoomPlacements() : exam.findBestAvailableRooms((Assignment<Exam, ExamPlacement>)assignment, period);
        if (rooms == null || rooms.isEmpty()) {
            return null;
        }
        if (placement == null) {
            placement = new ExamPlacement(exam, period, rooms);
        }
        ArrayList<ExamRoomPlacement> roomVect = new ArrayList<ExamRoomPlacement>(rooms);
        int rx = ToolBox.random((int)roomVect.size());
        for (int r = 0; r < roomVect.size(); ++r) {
            ExamRoomPlacement current = (ExamRoomPlacement)roomVect.get((r + rx) % roomVect.size());
            int mx = ToolBox.random((int)exam.getRoomPlacements().size());
            for (int m = 0; m < exam.getRoomPlacements().size(); ++m) {
                ExamRoomPlacement swap = exam.getRoomPlacements().get((m + mx) % exam.getRoomPlacements().size());
                ExamRoomSwapNeighbour n = new ExamRoomSwapNeighbour((Assignment<Exam, ExamPlacement>)assignment, placement, current, swap);
                if (!n.canDo()) continue;
                return n;
            }
        }
        rooms = exam.findRoomsRandom((Assignment<Exam, ExamPlacement>)assignment, period);
        if (rooms == null) {
            return null;
        }
        return new ExamSimpleNeighbour((Assignment<Exam, ExamPlacement>)assignment, new ExamPlacement(exam, period, rooms));
    }
}

