/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.heuristics.selection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;
import org.cpsolver.ifs.heuristics.VariableSelection;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.studentsct.filter.StudentFilter;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Request;

public class UnassignedRequestSelection
implements VariableSelection<Request, Enrollment> {
    protected int iNrRounds = 0;
    protected Queue<Request> iRequests = null;
    protected StudentFilter iFilter = null;

    public void init(Solver<Request, Enrollment> solver) {
        this.iRequests = new LinkedList<Request>();
        this.iNrRounds = solver.getProperties().getPropertyInt("UnassignedRequestSelection.NrRounds", 1);
    }

    public Request selectVariable(Solution<Request, Enrollment> solution) {
        return this.nextRequest(solution);
    }

    protected synchronized Request nextRequest(Solution<Request, Enrollment> solution) {
        if (this.iRequests.isEmpty() && this.iNrRounds > 0) {
            --this.iNrRounds;
            ArrayList<Request> variables = new ArrayList<Request>();
            for (Request r : solution.getModel().unassignedVariables(solution.getAssignment())) {
                if (r instanceof FreeTimeRequest || this.iFilter != null && !this.iFilter.accept(r.getStudent())) continue;
                variables.add(r);
            }
            Collections.shuffle(variables);
            this.iRequests.addAll(variables);
        }
        return this.iRequests.poll();
    }

    public StudentFilter getFilter() {
        return this.iFilter;
    }

    public UnassignedRequestSelection withFilter(StudentFilter filter) {
        this.iFilter = filter;
        return this;
    }
}

