/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.heuristics;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import org.cpsolver.coursett.heuristics.NeighbourSelectionWithSuggestions;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AssignmentContext;
import org.cpsolver.ifs.assignment.context.NeighbourSelectionWithContext;
import org.cpsolver.ifs.heuristics.NeighbourSelection;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.model.SimpleNeighbour;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.Progress;

public class FixCompleteSolutionNeighbourSelection
extends NeighbourSelectionWithContext<Lecture, Placement, FixCompleteSolutionNeighbourContext> {
    private NeighbourSelection<Lecture, Placement> iParent = null;
    private long iLastCompleteSolutionFixIteration = -1L;
    private long iLastIncompleteSolutionFixIteration = -1L;
    private long iCompleteSolutionFixInterval = 1L;
    private long iIncompleteSolutionFixInterval = 5000L;
    private NeighbourSelectionWithSuggestions iSuggestions = null;
    private Progress iProgress = null;
    private Solver<Lecture, Placement> iSolver = null;

    public FixCompleteSolutionNeighbourSelection(DataProperties config, NeighbourSelection<Lecture, Placement> parent) throws Exception {
        this.iParent = parent;
        this.iSuggestions = new NeighbourSelectionWithSuggestions(config);
    }

    public FixCompleteSolutionNeighbourSelection(DataProperties config) throws Exception {
        this(config, (NeighbourSelection<Lecture, Placement>)new NeighbourSelectionWithSuggestions(config));
    }

    public void init(Solver<Lecture, Placement> solver) {
        super.init(solver);
        this.iCompleteSolutionFixInterval = solver.getProperties().getPropertyLong("General.CompleteSolutionFixInterval", this.iCompleteSolutionFixInterval);
        this.iIncompleteSolutionFixInterval = solver.getProperties().getPropertyLong("General.IncompleteSolutionFixInterval", this.iIncompleteSolutionFixInterval);
        this.iSuggestions.init(solver);
        this.iParent.init(solver);
        this.iProgress = Progress.getInstance((Object)solver.currentSolution().getModel());
        this.iLastIncompleteSolutionFixIteration = -1L;
        this.iLastCompleteSolutionFixIteration = -1L;
        this.iSolver = solver;
    }

    public Neighbour<Lecture, Placement> selectNeighbour(Solution<Lecture, Placement> solution) {
        FixCompleteSolutionNeighbourContext context = (FixCompleteSolutionNeighbourContext)this.getContext(solution.getAssignment());
        if (context.getPhase() == 0) {
            if (solution.getModel().nrUnassignedVariables(solution.getAssignment()) == 0) {
                if (this.iCompleteSolutionFixInterval < 0L) {
                    return this.iParent.selectNeighbour(solution);
                }
                if (this.iCompleteSolutionFixInterval == 0L ? this.iLastCompleteSolutionFixIteration >= 0L : this.iLastCompleteSolutionFixIteration >= 0L && solution.getIteration() - this.iLastCompleteSolutionFixIteration < this.iCompleteSolutionFixInterval) {
                    return this.iParent.selectNeighbour(solution);
                }
                if (solution.getBestIteration() == solution.getIteration()) {
                    context.incPhase(solution);
                }
            } else if (!solution.isBestComplete()) {
                if (this.iIncompleteSolutionFixInterval < 0L) {
                    return this.iParent.selectNeighbour(solution);
                }
                if (this.iIncompleteSolutionFixInterval == 0L ? this.iLastIncompleteSolutionFixIteration >= 0L : solution.getIteration() - this.iLastIncompleteSolutionFixIteration < this.iIncompleteSolutionFixInterval) {
                    return this.iParent.selectNeighbour(solution);
                }
                if (solution.getBestIteration() == solution.getIteration()) {
                    context.incPhase(solution);
                }
            }
        }
        while (context.getPhase() > 0 && !this.iSolver.isStop()) {
            if (context.hasMoreElements()) {
                Lecture variable = context.nextElement();
                if (context.getPhase() == 1) {
                    Placement bestValue = null;
                    double bestVal = 0.0;
                    Placement currentValue = (Placement)solution.getAssignment().getValue((Variable)variable);
                    if (currentValue == null) continue;
                    double currentVal = currentValue.toDouble((Assignment<Lecture, Placement>)solution.getAssignment());
                    for (Placement value : variable.values((Assignment<Lecture, Placement>)solution.getAssignment())) {
                        if (value.equals((Object)currentValue) || !solution.getModel().conflictValues(solution.getAssignment(), (Value)value).isEmpty()) continue;
                        double val = value.toDouble((Assignment<Lecture, Placement>)solution.getAssignment());
                        if (bestValue != null && !(val < bestVal)) continue;
                        bestValue = value;
                        bestVal = val;
                    }
                    if (bestValue == null || !(bestVal < currentVal)) continue;
                    return new SimpleNeighbour((Variable)variable, bestValue);
                }
                Neighbour<Lecture, Placement> n = this.iSuggestions.selectNeighbourWithSuggestions(solution, variable, 2);
                if (n == null || !(n.value(solution.getAssignment()) <= solution.getModel().getTotalValue(solution.getAssignment()))) continue;
                return n;
            }
            context.incPhase(solution);
        }
        return this.iParent.selectNeighbour(solution);
    }

    public FixCompleteSolutionNeighbourContext createAssignmentContext(Assignment<Lecture, Placement> assignment) {
        return new FixCompleteSolutionNeighbourContext(assignment);
    }

    public class FixCompleteSolutionNeighbourContext
    implements AssignmentContext,
    Enumeration<Lecture> {
        private int iPhase = 0;
        private Iterator<Lecture> iLectures = null;

        public FixCompleteSolutionNeighbourContext(Assignment<Lecture, Placement> assignment) {
        }

        public int getPhase() {
            return this.iPhase;
        }

        public void incPhase(Solution<Lecture, Placement> solution) {
            if (this.iPhase == 0) {
                this.iPhase = 1;
                solution.saveBest();
                FixCompleteSolutionNeighbourSelection.this.iProgress.info("[" + Thread.currentThread().getName() + "] Fixing solution...");
                this.iLectures = new ArrayList(solution.getModel().variables()).iterator();
            } else if (this.iPhase == 1 && solution.isComplete()) {
                this.iPhase = 2;
                FixCompleteSolutionNeighbourSelection.this.iProgress.info("[" + Thread.currentThread().getName() + "] Fixing complete solution...");
                this.iLectures = new ArrayList(solution.getModel().variables()).iterator();
            } else {
                if (this.iPhase == 1) {
                    FixCompleteSolutionNeighbourSelection.this.iLastIncompleteSolutionFixIteration = solution.getIteration();
                } else {
                    FixCompleteSolutionNeighbourSelection.this.iLastCompleteSolutionFixIteration = solution.getIteration();
                }
                this.iPhase = 0;
                this.iLectures = null;
            }
        }

        @Override
        public boolean hasMoreElements() {
            return this.iLectures != null && this.iLectures.hasNext();
        }

        @Override
        public Lecture nextElement() {
            return this.iLectures.next();
        }
    }
}

