/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.criteria;

import org.cpsolver.coursett.criteria.StudentConflict;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.ifs.util.DataProperties;

public class StudentDistanceConflict
extends StudentConflict {
    @Override
    public boolean inConflict(Placement p1, Placement p2) {
        return StudentDistanceConflict.distance(this.getMetrics(), p1, p2);
    }

    @Override
    public boolean isApplicable(Lecture l1, Lecture l2) {
        return l1 != null && l2 != null && !StudentDistanceConflict.ignore(l1, l2) && StudentDistanceConflict.applicable(l1, l2);
    }

    public double getWeightDefault(DataProperties config) {
        return config.getPropertyDouble("Comparator.DistStudentConflictWeight", 0.2);
    }

    @Override
    public String getPlacementSelectionWeightName() {
        return "Placement.NrDistStudConfsWeight";
    }
}

