/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.sectioning;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.cpsolver.coursett.model.Configuration;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.Student;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.coursett.sectioning.StudentSwap;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.heuristics.NeighbourSelection;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.ToolBox;

public class StudentSwapGenerator
implements NeighbourSelection<Lecture, Placement> {
    Iterator<Lecture> iLectures = null;
    Lecture iLecture = null;
    Iterator<Student> iStudents = null;

    public void init(Solver<Lecture, Placement> solver) {
    }

    public Neighbour<Lecture, Placement> selectNeighbour(Solution<Lecture, Placement> solution) {
        TimetableModel model = (TimetableModel)solution.getModel();
        if (model.getAllStudents().isEmpty()) {
            return null;
        }
        boolean next = false;
        while (this.iLecture == null || this.iStudents == null || !this.iStudents.hasNext()) {
            if (this.iLectures == null || !this.iLectures.hasNext()) {
                if (next) {
                    return null;
                }
                this.iLectures = model.variables().iterator();
                next = true;
            }
            this.iLecture = this.iLectures.next();
            if (this.iLecture.getConfiguration() == null || this.iLecture.getConfiguration().getAltConfigurations().isEmpty() && this.iLecture.isSingleSection()) continue;
            this.iStudents = this.iLecture.conflictStudents((Assignment<Lecture, Placement>)solution.getAssignment()).iterator();
        }
        return this.generateSwap(model, (Assignment<Lecture, Placement>)solution.getAssignment(), this.iStudents.next(), this.iLecture.getConfiguration());
    }

    public Neighbour<Lecture, Placement> selectNeighbour(Assignment<Lecture, Placement> assignment, Lecture lecture) {
        return this.generateSwap((TimetableModel)lecture.getModel(), assignment, (Student)ToolBox.random(lecture.students()), lecture.getConfiguration());
    }

    public Neighbour<Lecture, Placement> generateSwap(TimetableModel model, Assignment<Lecture, Placement> assignment, Student student, Configuration config) {
        int idx;
        if (student == null || config == null) {
            return null;
        }
        if (!config.getAltConfigurations().isEmpty() && (idx = ToolBox.random((int)(config.getAltConfigurations().size() + 2))) > 1) {
            config = config.getAltConfigurations().get(idx - 2);
        }
        Long subpartId = (Long)ToolBox.random(config.getTopSubpartIds());
        int nrAttempts = ToolBox.random((int)10);
        for (int i = 0; i < nrAttempts; ++i) {
            Object swap;
            Lecture lecture = (Lecture)((Object)ToolBox.random(config.getTopLectures(subpartId)));
            Student other = (Student)ToolBox.random(lecture.students());
            if (other == null || student.equals(other) || !((StudentSwap)(swap = new StudentSwap(model, assignment, student, other, config.getOfferingId()))).isAllowed()) continue;
            return swap;
        }
        ArrayList<Lecture> lectures = new ArrayList<Lecture>();
        LinkedList<Set<Lecture>> queue = new LinkedList<Set<Lecture>>(config.getTopLectures().values());
        while (!queue.isEmpty()) {
            ArrayList<Lecture> adepts = new ArrayList<Lecture>();
            for (Lecture adept : (Collection)queue.poll()) {
                if (!student.canEnroll(adept)) continue;
                adepts.add(adept);
            }
            if (adepts.isEmpty()) {
                return null;
            }
            Lecture lect = (Lecture)((Object)ToolBox.random(adepts));
            lectures.add(lect);
            if (!lect.hasAnyChildren()) continue;
            queue.addAll(lect.getChildren().values());
        }
        StudentSwap swap = new StudentSwap(model, assignment, student, lectures);
        return swap.isAllowed() ? swap : null;
    }
}

