/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.criteria.additional;

import java.util.Collection;
import java.util.Set;
import org.cpsolver.exam.criteria.ExamCriterion;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.model.ExamRoomPlacement;
import org.cpsolver.ifs.assignment.Assignment;

public class RoomViolation
extends ExamCriterion {
    @Override
    public String getWeightName() {
        return "Exam.SoftRooms";
    }

    @Override
    public String getXmlWeightName() {
        return "softRooms";
    }

    @Override
    public double getValue(Assignment<Exam, ExamPlacement> assignment, ExamPlacement value, Set<ExamPlacement> conflicts) {
        double penalty = 0.0;
        if (value.getRoomPlacements() != null) {
            for (ExamRoomPlacement r : value.getRoomPlacements()) {
                penalty += this.getWeight() == (double)r.getPenalty() || this.getWeight() == (double)r.getRoom().getPenalty(value.getPeriod()) ? 1.0 / (double)value.getRoomPlacements().size() : 0.0;
            }
        }
        return penalty;
    }

    @Override
    public double[] getBounds(Assignment<Exam, ExamPlacement> assignment, Collection<Exam> variables) {
        double[] bounds = new double[]{0.0, 0.0};
        block0: for (Exam exam : variables) {
            if (exam.getRoomPlacements().isEmpty()) continue;
            for (ExamRoomPlacement roomPlacement : exam.getRoomPlacements()) {
                if (this.getWeight() != (double)roomPlacement.getPenalty() || !roomPlacement.getRoom().isAvailable()) continue;
                bounds[1] = bounds[1] + 1.0;
                continue block0;
            }
        }
        return bounds;
    }

    @Override
    public String toString(Assignment<Exam, ExamPlacement> assignment) {
        return this.getValue(assignment) <= 0.0 ? "" : "!R:" + sDoubleFormat.format(this.getValue(assignment));
    }

    @Override
    public boolean isPeriodCriterion() {
        return false;
    }
}

