/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.criteria.placement;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.cpsolver.coursett.criteria.placement.PlacementSelectionCriterion;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.criteria.AbstractCriterion;
import org.cpsolver.ifs.extension.ConflictStatistics;
import org.cpsolver.ifs.extension.Extension;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solution.SolutionListener;
import org.cpsolver.ifs.solver.Solver;

public class WeightedHardConflicts
extends PlacementSelectionCriterion
implements SolutionListener<Lecture, Placement> {
    protected ConflictStatistics<Lecture, Placement> iStat = null;

    public boolean init(Solver<Lecture, Placement> solver) {
        super.init(solver);
        for (Extension extension : solver.getExtensions()) {
            if (!ConflictStatistics.class.isInstance(extension)) continue;
            this.iStat = (ConflictStatistics)extension;
        }
        solver.currentSolution().addSolutionListener((SolutionListener)this);
        return true;
    }

    @Override
    public String getPlacementSelectionWeightName() {
        return "Placement.NrConflictsWeight";
    }

    public double getValue(Assignment<Lecture, Placement> assignment, Placement value, Set<Placement> conflicts) {
        if (this.iStat != null && conflicts != null && !conflicts.isEmpty()) {
            return this.iStat.countRemovals(((IterationContext)this.getContext(assignment)).getIteration(), conflicts, (Value)value);
        }
        return 0.0;
    }

    @Override
    public double getPlacementSelectionWeightDefault(int level) {
        return level == 0 ? 3.0 : 0.0;
    }

    public void solutionUpdated(Solution<Lecture, Placement> solution) {
        ((IterationContext)this.getContext(solution.getAssignment())).setIteration(solution.getIteration());
    }

    public void getInfo(Solution<Lecture, Placement> solution, Map<String, String> info) {
    }

    public void getInfo(Solution<Lecture, Placement> solution, Map<String, String> info, Collection<Lecture> variables) {
    }

    public void bestCleared(Solution<Lecture, Placement> solution) {
        ((IterationContext)this.getContext(solution.getAssignment())).setIteration(solution.getIteration());
    }

    public void bestSaved(Solution<Lecture, Placement> solution) {
        ((IterationContext)this.getContext(solution.getAssignment())).setIteration(solution.getIteration());
    }

    public void bestRestored(Solution<Lecture, Placement> solution) {
        ((IterationContext)this.getContext(solution.getAssignment())).setIteration(solution.getIteration());
    }

    public AbstractCriterion.ValueContext createAssignmentContext(Assignment<Lecture, Placement> assignment) {
        return new IterationContext(assignment);
    }

    public class IterationContext
    extends AbstractCriterion.ValueContext {
        protected long iIteration;

        protected IterationContext(Assignment<Lecture, Placement> assignment) {
            super((AbstractCriterion)WeightedHardConflicts.this, assignment);
            this.iIteration = 0L;
        }

        public void setIteration(long iteration) {
            this.iIteration = iteration;
        }

        public long getIteration() {
            return this.iIteration;
        }
    }
}

