/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.criteria.placement;

import java.util.Set;
import org.cpsolver.coursett.criteria.placement.PlacementSelectionCriterion;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.DataProperties;

public class DeltaTimePreference
extends PlacementSelectionCriterion {
    private double iLevel1DefaultWeight = 0.0;

    @Override
    public void configure(DataProperties properties) {
        super.configure(properties);
        this.iLevel1DefaultWeight = properties.getPropertyDouble("Comparator.TimePreferenceWeight", 1.0) / 2.0;
    }

    @Override
    public String getPlacementSelectionWeightName() {
        return "Placement.DeltaTimePreferenceWeight";
    }

    public double getValue(Assignment<Lecture, Placement> assignment, Placement value, Set<Placement> conflicts) {
        double ret = ((Lecture)value.variable()).getWeight() * (value.getTimeLocation().getNormalizedPreference() - ((Lecture)value.variable()).getBestTimePreference());
        if (conflicts != null) {
            for (Placement placement : conflicts) {
                double timePref = placement.getTimeLocation().getNormalizedPreference();
                ret -= ((Lecture)placement.variable()).getWeight() * (timePref - ((Lecture)placement.variable()).getBestTimePreference());
            }
        }
        return ret;
    }

    @Override
    public double getPlacementSelectionWeightDefault(int level) {
        return level == 0 ? this.iLevel1DefaultWeight : 0.0;
    }
}

