/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.reports;

import java.util.ArrayList;
import java.util.TreeSet;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamModel;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.model.ExamRoomPlacement;
import org.cpsolver.exam.reports.ExamRoomComparator;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.CSVFile;

public class ExamRoomSplit {
    private ExamModel iModel = null;

    public ExamRoomSplit(ExamModel model) {
        this.iModel = model;
    }

    public CSVFile report(Assignment<Exam, ExamPlacement> assignment) {
        CSVFile csv = new CSVFile();
        csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)"Exam"), new CSVFile.CSVField((Object)"Enrl"), new CSVFile.CSVField((Object)"Period"), new CSVFile.CSVField((Object)"Date"), new CSVFile.CSVField((Object)"Time"), new CSVFile.CSVField((Object)"Room 1"), new CSVFile.CSVField((Object)"Cap 1"), new CSVFile.CSVField((Object)"Room 2"), new CSVFile.CSVField((Object)"Cap 2"), new CSVFile.CSVField((Object)"Room 3"), new CSVFile.CSVField((Object)"Cap 3"), new CSVFile.CSVField((Object)"Room 4"), new CSVFile.CSVField((Object)"Cap 4")});
        for (Exam exam : this.iModel.variables()) {
            ExamPlacement placement = (ExamPlacement)assignment.getValue((Variable)exam);
            if (placement == null || placement.getRoomPlacements().size() <= 1) continue;
            ArrayList<CSVFile.CSVField> fields = new ArrayList<CSVFile.CSVField>();
            fields.add(new CSVFile.CSVField((Object)exam.getName()));
            fields.add(new CSVFile.CSVField(exam.getStudents().size()));
            fields.add(new CSVFile.CSVField(placement.getPeriod().getIndex() + 1));
            fields.add(new CSVFile.CSVField((Object)placement.getPeriod().getDayStr()));
            fields.add(new CSVFile.CSVField((Object)placement.getPeriod().getTimeStr()));
            TreeSet<ExamRoomPlacement> rooms = new TreeSet<ExamRoomPlacement>(new ExamRoomComparator(exam, false));
            rooms.addAll(placement.getRoomPlacements());
            for (ExamRoomPlacement room : rooms) {
                fields.add(new CSVFile.CSVField((Object)room.getName()));
                fields.add(new CSVFile.CSVField(room.getSize(exam.hasAltSeating())));
            }
            csv.addLine(fields);
        }
        return csv;
    }
}

