/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.criteria;

import java.util.Map;
import java.util.Set;
import org.cpsolver.exam.criteria.ExamCriterion;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.model.ExamRoomPlacement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.criteria.AbstractCriterion;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.DataProperties;

public class RoomSplitDistancePenalty
extends ExamCriterion {
    public AbstractCriterion.ValueContext createAssignmentContext(Assignment<Exam, ExamPlacement> assignment) {
        return new RoomSplitContext(assignment);
    }

    @Override
    public String getWeightName() {
        return "Exams.RoomSplitDistanceWeight";
    }

    @Override
    public String getXmlWeightName() {
        return "roomSplitDistanceWeight";
    }

    public double getWeightDefault(DataProperties config) {
        return 0.01;
    }

    public double getValue(Assignment<Exam, ExamPlacement> assignment, ExamPlacement value, Set<ExamPlacement> conflicts) {
        if (value.getRoomPlacements() == null || value.getRoomPlacements().size() <= 1) {
            return 0.0;
        }
        double distance = 0.0;
        for (ExamRoomPlacement r : value.getRoomPlacements()) {
            for (ExamRoomPlacement w : value.getRoomPlacements()) {
                if (r.getRoom().getId() >= w.getRoom().getId()) continue;
                distance += r.getRoom().getDistanceInMeters(w.getRoom());
            }
        }
        int pairs = value.getRoomPlacements().size() * (value.getRoomPlacements().size() - 1) / 2;
        return distance / (double)pairs;
    }

    @Override
    public void getInfo(Assignment<Exam, ExamPlacement> assignment, Map<String, String> info) {
        if (this.getValue(assignment) != 0.0) {
            info.put(this.getName(), sDoubleFormat.format(this.getValue(assignment) / (double)this.nrRoomSplits(assignment)) + " m");
        }
    }

    public String toString(Assignment<Exam, ExamPlacement> assignment) {
        return "RSd:" + sDoubleFormat.format(this.getValue(assignment) / (double)this.nrRoomSplits(assignment));
    }

    public int nrRoomSplits(Assignment<Exam, ExamPlacement> assignment) {
        return ((RoomSplitContext)this.getContext(assignment)).nrRoomSplits();
    }

    @Override
    public boolean isPeriodCriterion() {
        return false;
    }

    protected class RoomSplitContext
    extends AbstractCriterion.ValueContext {
        private int iRoomSplits;

        public RoomSplitContext(Assignment<Exam, ExamPlacement> assignment) {
            super((AbstractCriterion)RoomSplitDistancePenalty.this, assignment);
            this.iRoomSplits = 0;
            for (Exam exam : RoomSplitDistancePenalty.this.getModel().variables()) {
                ExamPlacement placement = (ExamPlacement)assignment.getValue((Variable)exam);
                if (placement == null || placement.getRoomPlacements() == null || placement.getRoomPlacements().size() <= 1) continue;
                ++this.iRoomSplits;
            }
        }

        public void assigned(Assignment<Exam, ExamPlacement> assignment, ExamPlacement value) {
            super.assigned(assignment, (Value)value);
            if (value.getRoomPlacements() != null && value.getRoomPlacements().size() > 1) {
                ++this.iRoomSplits;
            }
        }

        public void unassigned(Assignment<Exam, ExamPlacement> assignment, ExamPlacement value) {
            super.unassigned(assignment, (Value)value);
            if (value.getRoomPlacements() != null && value.getRoomPlacements().size() > 1) {
                --this.iRoomSplits;
            }
        }

        public int nrRoomSplits() {
            return this.iRoomSplits;
        }
    }
}

