/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.report;

import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.report.AbstractStudentSectioningReport;

public class RequestPriorityTable
extends AbstractStudentSectioningReport {
    public RequestPriorityTable(StudentSectioningModel model) {
        super(model);
    }

    @Override
    public CSVFile createTable(Assignment<Request, Enrollment> assignment, DataProperties properties) {
        CSVFile csv = new CSVFile();
        csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)"__Student"), new CSVFile.CSVField((Object)"Student"), new CSVFile.CSVField((Object)"Course"), new CSVFile.CSVField((Object)"Alternative"), new CSVFile.CSVField((Object)"Enrolled"), new CSVFile.CSVField((Object)"Primary"), new CSVFile.CSVField((Object)"Priority"), new CSVFile.CSVField((Object)"Alternativity")});
        for (Student student : this.getModel().getStudents()) {
            if (student.isDummy()) continue;
            int regPriority = 1;
            int altPriority = 1;
            for (Request r : student.getRequests()) {
                Enrollment e;
                CourseRequest cr;
                if (!(r instanceof CourseRequest) || !this.matches(cr = (CourseRequest)r, e = (Enrollment)cr.getAssignment(assignment))) continue;
                int primary = cr.isAlternative() ? 0 : 1;
                int priority = 0;
                priority = cr.isAlternative() ? altPriority++ : regPriority++;
                int alternativity = 0;
                for (Course course : cr.getCourses()) {
                    int alternative = primary == 0 || alternativity > 0 ? 1 : 0;
                    int enrolled = e != null && e.getCourse().equals((Object)course) ? 1 : 0;
                    csv.addLine(new CSVFile.CSVField[]{new CSVFile.CSVField(student.getId()), new CSVFile.CSVField((Object)student.getExternalId()), new CSVFile.CSVField((Object)cr.getCourses().get(alternativity).getName()), new CSVFile.CSVField(alternative), new CSVFile.CSVField(enrolled), new CSVFile.CSVField(primary), new CSVFile.CSVField(priority), new CSVFile.CSVField(alternativity)});
                    ++alternativity;
                }
            }
        }
        return csv;
    }
}

