/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.heuristics.selection;

import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.studentsct.heuristics.selection.BranchBoundSelection;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Student;

public class MinCreditBranchAndBoundSelection
extends BranchBoundSelection {
    protected boolean iMPP = false;
    private Request.RequestPriority iPriority;

    public MinCreditBranchAndBoundSelection(DataProperties properties, Request.RequestPriority priority) {
        super(properties);
        this.iMPP = properties.getPropertyBoolean("General.MPP", false);
        this.iTimeout = properties.getPropertyInt("Neighbour.MinCreditBranchAndBoundTimeout", 10000);
        this.iPriority = priority;
    }

    public MinCreditBranchAndBoundSelection(DataProperties properties) {
        this(properties, Request.RequestPriority.Important);
    }

    @Override
    public void init(Solver<Request, Enrollment> solver) {
        this.init(solver, "Min Credit B&B...");
    }

    @Override
    public Neighbour<Request, Enrollment> selectNeighbour(Solution<Request, Enrollment> solution) {
        Student student = null;
        while ((student = this.nextStudent()) != null) {
            BranchBoundSelection.BranchBoundNeighbour neighbour;
            Progress.getInstance((Object)solution.getModel()).incProgress();
            if (!(student.getMinCredit() > 0.0f) || !(student.getAssignedCredit((Assignment<Request, Enrollment>)solution.getAssignment()) < student.getMinCredit()) || (neighbour = this.getSelection((Assignment<Request, Enrollment>)solution.getAssignment(), student).select()) == null) continue;
            return neighbour;
        }
        return null;
    }

    @Override
    public BranchBoundSelection.Selection getSelection(Assignment<Request, Enrollment> assignment, Student student) {
        return new MinCreditSelection(student, assignment);
    }

    public class MinCreditSelection
    extends BranchBoundSelection.Selection {
        public MinCreditSelection(Student student, Assignment<Request, Enrollment> assignment) {
            super(student, assignment);
        }

        public double getCredit(int idx) {
            float credit = 0.0f;
            for (int i = 0; i < idx; ++i) {
                if (this.iAssignment[i] == null) continue;
                credit += this.iAssignment[i].getCredit();
            }
            return credit;
        }

        public boolean isCritical(int idx) {
            for (int i = idx; i < this.iStudent.getRequests().size(); ++i) {
                Request r = this.iStudent.getRequests().get(i);
                if (r.isAlternative() || !MinCreditBranchAndBoundSelection.this.iPriority.isCritical(r)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void backTrack(int idx) {
            if (this.getCredit(idx) >= (double)this.iStudent.getMinCredit() && !this.isCritical(idx)) {
                if (MinCreditBranchAndBoundSelection.this.iMinimizePenalty) {
                    if (this.getBestAssignment() == null || this.getNrAssigned() > this.getBestNrAssigned() || this.getNrAssigned() == this.getBestNrAssigned() && this.getPenalty() < this.getBestValue()) {
                        this.saveBest();
                    }
                } else if (this.getBestAssignment() == null || this.getValue() < this.getBestValue()) {
                    this.saveBest();
                }
                return;
            }
            if (idx < this.iAssignment.length && this.getCredit(idx) >= (double)this.iStudent.getMinCredit() && !MinCreditBranchAndBoundSelection.this.iPriority.isCritical(this.iStudent.getRequests().get(idx)) && (!MinCreditBranchAndBoundSelection.this.iMPP || this.iStudent.getRequests().get(idx).getInitialAssignment() == null) && this.canLeaveUnassigned(this.iStudent.getRequests().get(idx)) && this.canLeaveUnassigned(this.iStudent.getRequests().get(idx))) {
                this.backTrack(idx + 1);
            } else {
                super.backTrack(idx);
            }
        }
    }
}

