/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.heuristics.selection;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.heuristics.NeighbourSelection;
import org.cpsolver.ifs.model.GlobalConstraint;
import org.cpsolver.ifs.model.InfoProvider;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.solver.SolverListener;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.JProf;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.constraint.DependentCourses;
import org.cpsolver.studentsct.constraint.LinkedSections;
import org.cpsolver.studentsct.extension.DistanceConflict;
import org.cpsolver.studentsct.extension.StudentQuality;
import org.cpsolver.studentsct.extension.TimeOverlapsCounter;
import org.cpsolver.studentsct.filter.StudentFilter;
import org.cpsolver.studentsct.heuristics.studentord.StudentGroupsChoiceRealFirstOrder;
import org.cpsolver.studentsct.heuristics.studentord.StudentOrder;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Unavailability;
import org.cpsolver.studentsct.online.selection.OnlineSectioningCriterion;

public class BranchBoundSelection
implements NeighbourSelection<Request, Enrollment>,
InfoProvider<Request, Enrollment>,
SolverListener<Request, Enrollment> {
    private static Logger sLog = LogManager.getLogger(BranchBoundSelection.class);
    private static DecimalFormat sDF = new DecimalFormat("0.00");
    protected int iTimeout = 10000;
    protected DistanceConflict iDistanceConflict = null;
    protected TimeOverlapsCounter iTimeOverlaps = null;
    protected StudentQuality iStudentQuality = null;
    protected StudentSectioningModel iModel = null;
    public static boolean sDebug = false;
    protected LinkedList<Student> iStudents = null;
    protected boolean iMinimizePenalty = false;
    protected StudentOrder iOrder = new StudentGroupsChoiceRealFirstOrder();
    protected double iDistConfWeight = 1.0;
    protected boolean iBranchWhenSelectedHasNoConflict = false;
    protected boolean iTimesToAvoidHeuristics = true;
    protected StudentFilter iFilter = null;
    protected long iNbrIterations = 0L;
    protected long iTotalTime = 0L;
    protected long iNbrTimeoutReached = 0L;
    protected long iNbrNoSolution = 0L;
    protected long iNbrStudents = 0L;

    public BranchBoundSelection(DataProperties properties) {
        this.iTimeout = properties.getPropertyInt("Neighbour.BranchAndBoundTimeout", this.iTimeout);
        this.iMinimizePenalty = properties.getPropertyBoolean("Neighbour.BranchAndBoundMinimizePenalty", this.iMinimizePenalty);
        if (this.iMinimizePenalty) {
            sLog.info("Overall penalty is going to be minimized (together with the maximization of the number of assigned requests and minimization of distance conflicts).");
        }
        if (properties.getProperty("Neighbour.BranchAndBoundOrder") != null) {
            try {
                this.iOrder = (StudentOrder)Class.forName(properties.getProperty("Neighbour.BranchAndBoundOrder")).getConstructor(DataProperties.class).newInstance(properties);
            }
            catch (Exception e) {
                sLog.error("Unable to set student order, reason:" + e.getMessage(), (Throwable)e);
            }
        }
        this.iDistConfWeight = properties.getPropertyDouble("DistanceConflict.Weight", this.iDistConfWeight);
        this.iBranchWhenSelectedHasNoConflict = properties.getPropertyBoolean("Students.BranchWhenSelectedHasNoConflict", this.iBranchWhenSelectedHasNoConflict);
        this.iTimesToAvoidHeuristics = properties.getPropertyBoolean("OnlineStudentSectioning.TimesToAvoidHeuristics", this.iTimesToAvoidHeuristics);
    }

    public void init(Solver<Request, Enrollment> solver, String name) {
        this.setModel((StudentSectioningModel)solver.currentSolution().getModel());
        Progress.getInstance((Object)solver.currentSolution().getModel()).setPhase(name, (long)this.iModel.getStudents().size());
        this.iNbrIterations = 0L;
        this.iNbrTimeoutReached = 0L;
        this.iNbrNoSolution = 0L;
        this.iTotalTime = 0L;
        this.iNbrStudents = this.iStudents.size();
    }

    public void setModel(StudentSectioningModel model) {
        this.iModel = model;
        List<Student> students = this.iOrder.order(this.iModel.getStudents());
        this.iStudents = new LinkedList<Student>(students);
        this.iTimeOverlaps = model.getTimeOverlaps();
        this.iDistanceConflict = model.getDistanceConflict();
        this.iStudentQuality = model.getStudentQuality();
    }

    public void init(Solver<Request, Enrollment> solver) {
        this.init(solver, "Branch&bound" + (this.iFilter == null ? "" : " (" + this.iFilter.getName().toLowerCase() + " students)") + "...");
    }

    protected synchronized Student nextStudent() {
        Student student;
        do {
            if ((student = this.iStudents.poll()) != null) continue;
            return null;
        } while (this.iFilter != null && !this.iFilter.accept(student));
        return student;
    }

    public synchronized void addStudent(Student student) {
        if (this.iStudents != null && !student.isDummy()) {
            this.iStudents.addFirst(student);
        }
    }

    public Neighbour<Request, Enrollment> selectNeighbour(Solution<Request, Enrollment> solution) {
        Student student = null;
        block2: while ((student = this.nextStudent()) != null) {
            Progress.getInstance((Object)solution.getModel()).setProgress(this.iNbrStudents - (long)this.iStudents.size());
            for (int i = 0; i < 5; ++i) {
                try {
                    BranchBoundNeighbour neighbour = this.getSelection((Assignment<Request, Enrollment>)solution.getAssignment(), student).select();
                    if (neighbour == null) continue block2;
                    return neighbour;
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    continue;
                }
            }
        }
        return null;
    }

    public Selection getSelection(Assignment<Request, Enrollment> assignment, Student student) {
        return new Selection(student, assignment);
    }

    public void getInfo(Assignment<Request, Enrollment> assignment, Map<String, String> info) {
        if (this.iNbrIterations > 0L) {
            info.put("Timing of " + this.getClass().getSimpleName(), sDF.format((double)this.iTotalTime / (double)this.iNbrIterations) + " ms/it (" + this.iNbrIterations + " iterations, " + (this.iNbrNoSolution == 0L ? "" : sDF.format(100.0 * (double)this.iNbrNoSolution / (double)this.iNbrIterations) + "% no solution, ") + sDF.format(100.0 * (double)this.iNbrTimeoutReached / (double)this.iNbrIterations) + "% time limit of " + sDF.format((double)this.iTimeout / 1000.0) + " seconds reached)");
        }
    }

    public void getInfo(Assignment<Request, Enrollment> assignment, Map<String, String> info, Collection<Request> variables) {
    }

    public StudentFilter getFilter() {
        return this.iFilter;
    }

    public BranchBoundSelection withFilter(StudentFilter filter) {
        this.iFilter = filter;
        return this;
    }

    public boolean variableSelected(Assignment<Request, Enrollment> assignment, long iteration, Request variable) {
        return false;
    }

    public boolean valueSelected(Assignment<Request, Enrollment> assignment, long iteration, Request variable, Enrollment value) {
        return false;
    }

    public boolean neighbourSelected(Assignment<Request, Enrollment> assignment, long iteration, Neighbour<Request, Enrollment> neighbour) {
        return false;
    }

    public void neighbourFailed(Assignment<Request, Enrollment> assignment, long iteration, Neighbour<Request, Enrollment> neighbour) {
        if (neighbour instanceof BranchBoundNeighbour) {
            this.addStudent(((BranchBoundNeighbour)neighbour).getStudent());
        }
    }

    public static class BranchBoundNeighbour
    implements Neighbour<Request, Enrollment> {
        private double iValue;
        private Enrollment[] iAssignment;
        private Student iStudent;

        public BranchBoundNeighbour(Student student, double value, Enrollment[] assignment) {
            this.iValue = value;
            this.iAssignment = assignment;
            this.iStudent = student;
        }

        public double value(Assignment<Request, Enrollment> assignment) {
            return this.iValue;
        }

        public Enrollment[] getAssignment() {
            return this.iAssignment;
        }

        public Student getStudent() {
            return this.iStudent;
        }

        public void assign(Assignment<Request, Enrollment> assignment, long iteration) {
            int i;
            for (i = 0; i < this.iAssignment.length; ++i) {
                assignment.unassign(iteration, (Variable)this.iStudent.getRequests().get(i), (Value)this.iAssignment[i]);
            }
            for (i = 0; i < this.iAssignment.length; ++i) {
                if (this.iAssignment[i] == null) continue;
                assignment.assign(iteration, (Value)this.iAssignment[i]);
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("B&B{ " + this.iStudent + " " + sDF.format(-this.iValue * 100.0) + "%");
            int idx = 0;
            for (Request request : this.iStudent.getRequests()) {
                sb.append("\n  " + (Object)((Object)request));
                Enrollment enrollment = this.iAssignment[idx];
                if (enrollment == null) {
                    sb.append("  -- not assigned");
                } else {
                    sb.append("  -- " + (Object)((Object)enrollment));
                }
                ++idx;
            }
            sb.append("\n}");
            return sb.toString();
        }

        public Map<Request, Enrollment> assignments() {
            HashMap<Request, Enrollment> ret = new HashMap<Request, Enrollment>();
            for (int i = 0; i < this.iAssignment.length; ++i) {
                ret.put(this.iStudent.getRequests().get(i), this.iAssignment[i]);
            }
            return ret;
        }
    }

    public class Selection {
        protected Student iStudent;
        protected long iT0;
        protected long iT1;
        protected boolean iTimeoutReached;
        protected Enrollment[] iAssignment;
        protected Enrollment[] iBestAssignment;
        protected double iBestValue;
        protected HashMap<CourseRequest, List<Enrollment>> iValues;
        protected Assignment<Request, Enrollment> iCurrentAssignment;
        protected ArrayList<OnlineSectioningCriterion.TimeToAvoid> iTimesToAvoid = null;

        public Selection(Student student, Assignment<Request, Enrollment> assignment) {
            this.iStudent = student;
            this.iCurrentAssignment = assignment;
            if (BranchBoundSelection.this.iTimesToAvoidHeuristics) {
                this.iTimesToAvoid = new ArrayList();
                for (Request r : this.iStudent.getRequests()) {
                    if (r instanceof CourseRequest) {
                        List<Enrollment> enrollments = ((CourseRequest)r).getAvaiableEnrollmentsSkipSameTime(assignment);
                        if (enrollments.size() > 5) continue;
                        int penalty = (7 - enrollments.size()) * (r.isAlternative() ? 1 : 7 - enrollments.size());
                        for (Enrollment enrollment : enrollments) {
                            for (Section section : enrollment.getSections()) {
                                if (section.getTime() == null) continue;
                                this.iTimesToAvoid.add(new OnlineSectioningCriterion.TimeToAvoid(section.getTime(), penalty, r.getPriority()));
                            }
                        }
                        continue;
                    }
                    if (!(r instanceof FreeTimeRequest)) continue;
                    this.iTimesToAvoid.add(new OnlineSectioningCriterion.TimeToAvoid(((FreeTimeRequest)r).getTime(), 1, Integer.MAX_VALUE));
                }
                for (Unavailability unavailability : this.iStudent.getUnavailabilities()) {
                    if (unavailability.getTime() == null) continue;
                    this.iTimesToAvoid.add(new OnlineSectioningCriterion.TimeToAvoid(unavailability.getTime(), 1, Integer.MAX_VALUE));
                }
            }
        }

        public BranchBoundNeighbour select() {
            this.iT0 = JProf.currentTimeMillis();
            this.iTimeoutReached = false;
            this.iAssignment = new Enrollment[this.iStudent.getRequests().size()];
            this.iBestAssignment = null;
            this.iBestValue = 0.0;
            int i = 0;
            for (Request r : this.iStudent.getRequests()) {
                this.iAssignment[i++] = (Enrollment)this.iCurrentAssignment.getValue((Variable)r);
            }
            this.saveBest();
            for (int j = 0; j < this.iAssignment.length; ++j) {
                this.iAssignment[j] = null;
            }
            this.iValues = new HashMap();
            this.backTrack(0);
            this.iT1 = JProf.currentTimeMillis();
            ++BranchBoundSelection.this.iNbrIterations;
            BranchBoundSelection.this.iTotalTime += this.iT1 - this.iT0;
            if (this.iTimeoutReached) {
                ++BranchBoundSelection.this.iNbrTimeoutReached;
            }
            if (this.iBestAssignment == null) {
                ++BranchBoundSelection.this.iNbrNoSolution;
            }
            if (this.iBestAssignment == null) {
                return null;
            }
            return new BranchBoundNeighbour(this.iStudent, this.iBestValue, this.iBestAssignment);
        }

        public boolean isTimeoutReached() {
            return this.iTimeoutReached;
        }

        public long getTime() {
            return this.iT1 - this.iT0;
        }

        public Enrollment[] getBestAssignment() {
            return this.iBestAssignment;
        }

        public double getBestValue() {
            return this.iBestValue;
        }

        public int getBestNrAssigned() {
            int nrAssigned = 0;
            for (int i = 0; i < this.iBestAssignment.length; ++i) {
                if (this.iBestAssignment[i] == null) continue;
                nrAssigned += this.iBestAssignment[i].isCourseRequest() ? 10 : 1;
            }
            return nrAssigned;
        }

        public int getNrAssignedBound(int idx) {
            int bound = 0;
            int i = 0;
            int alt = 0;
            for (Request r : this.iStudent.getRequests()) {
                boolean cr = r instanceof CourseRequest;
                if (i < idx) {
                    if (this.iAssignment[i] != null) {
                        bound += cr ? 10 : 1;
                    }
                    if (r.isAlternative()) {
                        if (this.iAssignment[i] != null || cr && ((CourseRequest)r).isWaitlist()) {
                            --alt;
                        }
                    } else if (cr && !((CourseRequest)r).isWaitlist() && this.iAssignment[i] == null) {
                        ++alt;
                    }
                } else if (!r.isAlternative()) {
                    bound += cr ? 10 : 1;
                } else if (alt > 0) {
                    bound += cr ? 10 : 1;
                    --alt;
                }
                ++i;
            }
            return bound;
        }

        public Set<DistanceConflict.Conflict> getDistanceConflicts(int idx) {
            if (BranchBoundSelection.this.iDistanceConflict == null || this.iAssignment[idx] == null) {
                return null;
            }
            Set<DistanceConflict.Conflict> dist = BranchBoundSelection.this.iDistanceConflict.conflicts(this.iAssignment[idx]);
            for (int x = 0; x < idx; ++x) {
                if (this.iAssignment[x] == null) continue;
                dist.addAll(BranchBoundSelection.this.iDistanceConflict.conflicts(this.iAssignment[x], this.iAssignment[idx]));
            }
            return dist;
        }

        public Set<TimeOverlapsCounter.Conflict> getTimeOverlappingConflicts(int idx) {
            if (BranchBoundSelection.this.iTimeOverlaps == null || this.iAssignment[idx] == null) {
                return null;
            }
            HashSet<TimeOverlapsCounter.Conflict> overlaps = new HashSet<TimeOverlapsCounter.Conflict>();
            for (int x = 0; x < idx; ++x) {
                if (this.iAssignment[x] != null) {
                    overlaps.addAll(BranchBoundSelection.this.iTimeOverlaps.conflicts(this.iAssignment[x], this.iAssignment[idx]));
                    continue;
                }
                if (!(this.iStudent.getRequests().get(x) instanceof FreeTimeRequest)) continue;
                overlaps.addAll(BranchBoundSelection.this.iTimeOverlaps.conflicts(((FreeTimeRequest)this.iStudent.getRequests().get(x)).createEnrollment(), this.iAssignment[idx]));
            }
            overlaps.addAll(BranchBoundSelection.this.iTimeOverlaps.notAvailableTimeConflicts(this.iAssignment[idx]));
            return overlaps;
        }

        public Set<StudentQuality.Conflict> getStudentQualityConflicts(int idx) {
            if (BranchBoundSelection.this.iStudentQuality == null || this.iAssignment[idx] == null) {
                return null;
            }
            HashSet<StudentQuality.Conflict> conflicts = new HashSet<StudentQuality.Conflict>();
            for (StudentQuality.Type t : StudentQuality.Type.values()) {
                conflicts.addAll(BranchBoundSelection.this.iStudentQuality.conflicts(t, this.iAssignment[idx]));
                for (int x = 0; x < idx; ++x) {
                    if (this.iAssignment[x] == null) continue;
                    conflicts.addAll(BranchBoundSelection.this.iStudentQuality.conflicts(t, this.iAssignment[x], this.iAssignment[idx]));
                }
            }
            return conflicts;
        }

        @Deprecated
        protected double getWeight(Enrollment enrollment, Set<DistanceConflict.Conflict> distanceConflicts, Set<TimeOverlapsCounter.Conflict> timeOverlappingConflicts) {
            double weight = -BranchBoundSelection.this.iModel.getStudentWeights().getWeight(this.iCurrentAssignment, enrollment);
            if (distanceConflicts != null) {
                for (DistanceConflict.Conflict conflict : distanceConflicts) {
                    Enrollment other = conflict.getE1().equals((Object)enrollment) ? conflict.getE2() : conflict.getE1();
                    if (other.getRequest().getPriority() > enrollment.getRequest().getPriority()) continue;
                    weight += BranchBoundSelection.this.iModel.getStudentWeights().getDistanceConflictWeight(this.iCurrentAssignment, conflict);
                }
            }
            if (timeOverlappingConflicts != null) {
                for (TimeOverlapsCounter.Conflict conflict : timeOverlappingConflicts) {
                    weight += BranchBoundSelection.this.iModel.getStudentWeights().getTimeOverlapConflictWeight(this.iCurrentAssignment, enrollment, conflict);
                }
            }
            return enrollment.getRequest().getWeight() * weight;
        }

        protected double getWeight(Enrollment enrollment, Set<StudentQuality.Conflict> conflicts) {
            double weight = -BranchBoundSelection.this.iModel.getStudentWeights().getWeight(this.iCurrentAssignment, enrollment);
            if (conflicts != null) {
                for (StudentQuality.Conflict c : conflicts) {
                    weight += BranchBoundSelection.this.iModel.getStudentWeights().getStudentQualityConflictWeight(this.iCurrentAssignment, enrollment, c);
                }
            }
            return enrollment.getRequest().getWeight() * weight;
        }

        protected double getBound(Request r) {
            return r.getBound();
        }

        public double getBound(int idx) {
            double bound = 0.0;
            int i = 0;
            int alt = 0;
            for (Request r : this.iStudent.getRequests()) {
                if (i < idx) {
                    if (this.iAssignment[i] != null) {
                        bound = BranchBoundSelection.this.iStudentQuality != null ? (bound += this.getWeight(this.iAssignment[i], this.getStudentQualityConflicts(i))) : (bound += this.getWeight(this.iAssignment[i], this.getDistanceConflicts(i), this.getTimeOverlappingConflicts(i)));
                    }
                    if (r.isAlternative()) {
                        if (this.iAssignment[i] != null || r instanceof CourseRequest && ((CourseRequest)r).isWaitlist()) {
                            --alt;
                        }
                    } else if (r instanceof CourseRequest && !((CourseRequest)r).isWaitlist() && this.iAssignment[i] == null) {
                        ++alt;
                    }
                } else if (!r.isAlternative()) {
                    bound += this.getBound(r);
                } else if (alt > 0) {
                    bound += this.getBound(r);
                    --alt;
                }
                ++i;
            }
            return bound;
        }

        public double getValue() {
            double value = 0.0;
            for (int i = 0; i < this.iAssignment.length; ++i) {
                if (this.iAssignment[i] == null) continue;
                if (BranchBoundSelection.this.iStudentQuality != null) {
                    value += this.getWeight(this.iAssignment[i], this.getStudentQualityConflicts(i));
                    continue;
                }
                value += this.getWeight(this.iAssignment[i], this.getDistanceConflicts(i), this.getTimeOverlappingConflicts(i));
            }
            return value;
        }

        protected double getAssignmentPenalty(int i) {
            return this.iAssignment[i].getPenalty() + BranchBoundSelection.this.iDistConfWeight * (double)this.getDistanceConflicts(i).size();
        }

        public double getPenalty() {
            double bestPenalty = 0.0;
            for (int i = 0; i < this.iAssignment.length; ++i) {
                if (this.iAssignment[i] == null) continue;
                bestPenalty += this.getAssignmentPenalty(i);
            }
            return bestPenalty;
        }

        public double getPenaltyBound(int idx) {
            double bound = 0.0;
            int i = 0;
            int alt = 0;
            for (Request r : this.iStudent.getRequests()) {
                if (i < idx) {
                    if (this.iAssignment[i] != null) {
                        bound += this.getAssignmentPenalty(i);
                    }
                    if (r.isAlternative()) {
                        if (this.iAssignment[i] != null || r instanceof CourseRequest && ((CourseRequest)r).isWaitlist()) {
                            --alt;
                        }
                    } else if (r instanceof CourseRequest && !((CourseRequest)r).isWaitlist() && this.iAssignment[i] == null) {
                        ++alt;
                    }
                } else if (!r.isAlternative()) {
                    if (r instanceof CourseRequest) {
                        bound += ((CourseRequest)r).getMinPenalty();
                    }
                } else if (alt > 0) {
                    if (r instanceof CourseRequest) {
                        bound += ((CourseRequest)r).getMinPenalty();
                    }
                    --alt;
                }
                ++i;
            }
            return bound;
        }

        public void saveBest() {
            if (this.iBestAssignment == null) {
                this.iBestAssignment = new Enrollment[this.iAssignment.length];
            }
            for (int i = 0; i < this.iAssignment.length; ++i) {
                this.iBestAssignment[i] = this.iAssignment[i];
            }
            this.iBestValue = BranchBoundSelection.this.iMinimizePenalty ? this.getPenalty() : this.getValue();
        }

        public boolean inConflict(final int idx, final Enrollment enrollment) {
            for (GlobalConstraint constraint : ((Request)enrollment.variable()).getModel().globalConstraints()) {
                if (!(constraint instanceof DependentCourses ? ((DependentCourses)constraint).isPartialScheduleInConflict(this.iStudent, new LinkedSections.EnrollmentAssignment(){

                    @Override
                    public Enrollment getEnrollment(Request request, int index) {
                        return index == idx ? enrollment : Selection.this.iAssignment[index];
                    }
                }, idx) : constraint.inConflict(this.iCurrentAssignment, (Value)enrollment))) continue;
                return true;
            }
            for (LinkedSections linkedSections : this.iStudent.getLinkedSections()) {
                if (linkedSections.inConflict(enrollment, new LinkedSections.EnrollmentAssignment(){

                    @Override
                    public Enrollment getEnrollment(Request request, int index) {
                        return index == idx ? enrollment : Selection.this.iAssignment[index];
                    }
                }) == null) continue;
                return true;
            }
            float credit = enrollment.getCredit();
            for (int i = 0; i < this.iAssignment.length; ++i) {
                if (this.iAssignment[i] == null || i == idx || !((credit += this.iAssignment[i].getCredit()) > this.iStudent.getMaxCredit()) && !this.iAssignment[i].isOverlapping(enrollment)) continue;
                return true;
            }
            return false;
        }

        public Enrollment firstConflict(int idx, Enrollment enrollment) {
            Set conflicts = ((Request)enrollment.variable()).getModel().conflictValues(this.iCurrentAssignment, (Value)enrollment);
            if (conflicts.contains((Object)enrollment)) {
                return enrollment;
            }
            if (!conflicts.isEmpty()) {
                for (Enrollment conflict : conflicts) {
                    if (conflict.getStudent().equals(this.iStudent)) continue;
                    return conflict;
                }
            }
            float credit = enrollment.getCredit();
            for (int i = 0; i < this.iAssignment.length; ++i) {
                if (this.iAssignment[i] == null || i == idx || !((credit += this.iAssignment[i].getCredit()) > this.iStudent.getMaxCredit()) && !this.iAssignment[i].isOverlapping(enrollment)) continue;
                return this.iAssignment[i];
            }
            return null;
        }

        public boolean canAssign(Request request, int idx) {
            if (this.iAssignment[idx] != null) {
                return true;
            }
            int alt = 0;
            int i = 0;
            float credit = 0.0f;
            for (Request r : this.iStudent.getRequests()) {
                if (r.equals((Object)request)) {
                    credit += r.getMinCredit();
                } else if (this.iAssignment[i] != null) {
                    credit += this.iAssignment[i].getCredit();
                }
                if (!r.equals((Object)request)) {
                    if (r.isAlternative()) {
                        if (this.iAssignment[i] != null || r instanceof CourseRequest && ((CourseRequest)r).isWaitlist()) {
                            --alt;
                        }
                    } else if (r instanceof CourseRequest && !((CourseRequest)r).isWaitlist() && this.iAssignment[i] == null) {
                        ++alt;
                    }
                }
                ++i;
            }
            return (!request.isAlternative() || alt > 0) && credit <= this.iStudent.getMaxCredit();
        }

        public int getNrAssigned() {
            int assigned = 0;
            for (int i = 0; i < this.iAssignment.length; ++i) {
                if (this.iAssignment[i] == null) continue;
                assigned += this.iAssignment[i].isCourseRequest() ? 10 : 1;
            }
            return assigned;
        }

        protected boolean canLeaveUnassigned(Request request) {
            if (request instanceof CourseRequest && ((CourseRequest)request).getFixedValue() != null) {
                return false;
            }
            if (request.isMPP() && BranchBoundSelection.this.iModel.getKeepInitialAssignments()) {
                return false;
            }
            return BranchBoundSelection.this.iModel.getDependentCoursesConstraint() == null || BranchBoundSelection.this.iModel.getDependentCoursesConstraint().canLeaveUnassigned(this.iStudent, new LinkedSections.EnrollmentAssignment(){

                @Override
                public Enrollment getEnrollment(Request r, int index) {
                    return Selection.this.iAssignment[index];
                }
            }, request);
        }

        protected List<Enrollment> values(final CourseRequest request) {
            List<Enrollment> values = request.getAvaiableEnrollments(this.iCurrentAssignment, false);
            Collections.sort(values, new Comparator<Enrollment>(){
                private HashMap<Enrollment, Double> iValues = new HashMap();

                private Double value(Enrollment e) {
                    Double value = this.iValues.get((Object)e);
                    if (value == null) {
                        value = BranchBoundSelection.this.iModel.getStudentQuality() != null ? Double.valueOf(BranchBoundSelection.this.iModel.getStudentWeights().getWeight(Selection.this.iCurrentAssignment, e, BranchBoundSelection.this.iModel.getStudentQuality().conflicts(e))) : Double.valueOf(BranchBoundSelection.this.iModel.getStudentWeights().getWeight(Selection.this.iCurrentAssignment, e, BranchBoundSelection.this.iModel.getDistanceConflict() == null ? null : BranchBoundSelection.this.iModel.getDistanceConflict().conflicts(e), BranchBoundSelection.this.iModel.getTimeOverlaps() == null ? null : BranchBoundSelection.this.iModel.getTimeOverlaps().conflicts(e)));
                        this.iValues.put(e, value);
                    }
                    return value;
                }

                @Override
                public int compare(Enrollment e1, Enrollment e2) {
                    Double v2;
                    Double v1;
                    if (e1.equals((Object)e2)) {
                        return 0;
                    }
                    if (e1.equals(Selection.this.iCurrentAssignment.getValue((Variable)request))) {
                        return -1;
                    }
                    if (e2.equals(Selection.this.iCurrentAssignment.getValue((Variable)request))) {
                        return 1;
                    }
                    if (Selection.this.iTimesToAvoid != null) {
                        double o1 = 0.0;
                        double o2 = 0.0;
                        for (Section s : e1.getSections()) {
                            if (s.getTime() == null) continue;
                            for (OnlineSectioningCriterion.TimeToAvoid avoid : Selection.this.iTimesToAvoid) {
                                if (avoid.priority() <= e1.getRequest().getPriority()) continue;
                                o1 += avoid.overlap(s.getTime());
                            }
                        }
                        for (Section s : e2.getSections()) {
                            if (s.getTime() == null) continue;
                            for (OnlineSectioningCriterion.TimeToAvoid avoid : Selection.this.iTimesToAvoid) {
                                if (avoid.priority() <= e2.getRequest().getPriority()) continue;
                                o2 += avoid.overlap(s.getTime());
                            }
                        }
                        if (o1 < o2) {
                            return -1;
                        }
                        if (o2 < o1) {
                            return 1;
                        }
                    }
                    return (v1 = this.value(e1)).equals(v2 = this.value(e2)) ? e1.compareTo(Selection.this.iCurrentAssignment, e2) : v2.compareTo(v1);
                }
            });
            return values;
        }

        public void backTrack(int idx) {
            if (sDebug) {
                sLog.debug("backTrack(" + this.getNrAssigned() + "/" + this.getValue() + "," + idx + ")");
            }
            if (BranchBoundSelection.this.iTimeout > 0 && JProf.currentTimeMillis() - this.iT0 > (long)BranchBoundSelection.this.iTimeout) {
                if (sDebug) {
                    sLog.debug("  -- timeout reached");
                }
                this.iTimeoutReached = true;
                return;
            }
            if (BranchBoundSelection.this.iMinimizePenalty) {
                if (this.getBestAssignment() != null && (this.getNrAssignedBound(idx) < this.getBestNrAssigned() || this.getNrAssignedBound(idx) == this.getBestNrAssigned() && this.getPenaltyBound(idx) >= this.getBestValue())) {
                    if (sDebug) {
                        sLog.debug("  -- branch number of assigned " + this.getNrAssignedBound(idx) + "<" + this.getBestNrAssigned() + ", or penalty " + this.getPenaltyBound(idx) + ">=" + this.getBestValue());
                    }
                    return;
                }
                if (idx == this.iAssignment.length) {
                    if (this.getBestAssignment() == null || this.getNrAssigned() > this.getBestNrAssigned() || this.getNrAssigned() == this.getBestNrAssigned() && this.getPenalty() < this.getBestValue()) {
                        if (sDebug) {
                            sLog.debug("  -- best solution found " + this.getNrAssigned() + "/" + this.getPenalty());
                        }
                        this.saveBest();
                    }
                    return;
                }
            } else {
                if (this.getBestAssignment() != null && this.getBound(idx) >= this.getBestValue()) {
                    if (sDebug) {
                        sLog.debug("  -- branch " + this.getBound(idx) + " >= " + this.getBestValue());
                    }
                    return;
                }
                if (idx == this.iAssignment.length) {
                    if (this.getBestAssignment() == null || this.getValue() < this.getBestValue()) {
                        if (sDebug) {
                            sLog.debug("  -- best solution found " + this.getNrAssigned() + "/" + this.getValue());
                        }
                        this.saveBest();
                    }
                    return;
                }
            }
            Request request = this.iStudent.getRequests().get(idx);
            if (sDebug) {
                sLog.debug("  -- request: " + (Object)((Object)request));
            }
            if (!this.canAssign(request, idx)) {
                if (sDebug) {
                    sLog.debug("    -- cannot assign");
                }
                this.backTrack(idx + 1);
                return;
            }
            List<Enrollment> values = null;
            if (request instanceof CourseRequest) {
                Enrollment enrollment;
                CourseRequest courseRequest = (CourseRequest)request;
                if (courseRequest.getInitialAssignment() != null && BranchBoundSelection.this.iModel.isMPP() && !this.inConflict(idx, enrollment = (Enrollment)courseRequest.getInitialAssignment())) {
                    this.iAssignment[idx] = enrollment;
                    this.backTrack(idx + 1);
                    this.iAssignment[idx] = null;
                    return;
                }
                if (!courseRequest.getSelectedChoices().isEmpty()) {
                    if (sDebug) {
                        sLog.debug("    -- selection among selected enrollments");
                    }
                    if ((values = courseRequest.getSelectedEnrollments(this.iCurrentAssignment, true)) != null && !values.isEmpty()) {
                        boolean hasNoConflictValue = false;
                        for (Enrollment enrollment2 : values) {
                            if (this.inConflict(idx, enrollment2)) continue;
                            hasNoConflictValue = true;
                            if (sDebug) {
                                sLog.debug("      -- nonconflicting enrollment found: " + (Object)((Object)enrollment2));
                            }
                            this.iAssignment[idx] = enrollment2;
                            this.backTrack(idx + 1);
                            this.iAssignment[idx] = null;
                        }
                        if (hasNoConflictValue && BranchBoundSelection.this.iBranchWhenSelectedHasNoConflict) {
                            return;
                        }
                    }
                }
                if ((values = this.iValues.get((Object)courseRequest)) == null) {
                    values = this.values(courseRequest);
                    this.iValues.put(courseRequest, values);
                }
            } else {
                values = request.computeEnrollments(this.iCurrentAssignment);
            }
            if (sDebug) {
                sLog.debug("  -- nrValues: " + values.size());
                int vIdx = 1;
                for (Enrollment enrollment : values) {
                    if (!sDebug) continue;
                    sLog.debug("    -- [" + vIdx + "]: " + (Object)((Object)enrollment));
                }
            }
            boolean hasNoConflictValue = false;
            for (Enrollment enrollment : values) {
                if (sDebug) {
                    sLog.debug("    -- enrollment: " + (Object)((Object)enrollment));
                }
                if (sDebug) {
                    Enrollment conflict = this.firstConflict(idx, enrollment);
                    if (conflict != null) {
                        sLog.debug("        -- in conflict with: " + (Object)((Object)conflict));
                        continue;
                    }
                } else if (this.inConflict(idx, enrollment)) continue;
                hasNoConflictValue = true;
                this.iAssignment[idx] = enrollment;
                this.backTrack(idx + 1);
                this.iAssignment[idx] = null;
            }
            if (this.canLeaveUnassigned(request) && (!hasNoConflictValue || request instanceof CourseRequest)) {
                this.backTrack(idx + 1);
            }
        }
    }
}

