/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.algorithms;

import org.cpsolver.ifs.algorithms.NeighbourSearch;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;

public class HillClimber<V extends Variable<V, T>, T extends Value<V, T>>
extends NeighbourSearch<V, T> {
    protected int iMaxIdleIters = 10000;
    protected boolean iSetHCMode = false;
    protected static double sEPS = 1.0E-5;

    public HillClimber(DataProperties properties) {
        super(properties);
        this.iMaxIdleIters = properties.getPropertyInt(this.getParameterBaseName() + ".MaxIdle", this.iMaxIdleIters);
        this.iSetHCMode = properties.getPropertyBoolean(this.getParameterBaseName() + ".SetHCMode", this.iSetHCMode);
    }

    public void setPhase(String phase) {
        this.iPhase = phase;
    }

    @Override
    public void init(Solver<V, T> solver) {
        super.init(solver);
        if (this.iSetHCMode) {
            this.setHCMode(true);
        }
    }

    @Override
    public String getParameterBaseName() {
        return "HillClimber";
    }

    @Override
    public NeighbourSearch.NeighbourSearchContext createAssignmentContext(Assignment<V, T> assignment) {
        return new HillClimberContext();
    }

    public class HillClimberContext
    extends NeighbourSearch.NeighbourSearchContext {
        protected int iLastImprovingIter;

        public HillClimberContext() {
            super(HillClimber.this);
            this.iLastImprovingIter = 0;
        }

        @Override
        protected void incIteration(Solution<V, T> solution) {
            super.incIteration(solution);
            if (this.iIter % 10000 == 0) {
                HillClimber.this.info("Iter=" + this.iIter / 1000 + "k, NonImpIter=" + HillClimber.this.iDF2.format((double)(this.iIter - this.iLastImprovingIter) / 1000.0) + "k, Speed=" + HillClimber.this.iDF2.format(1000.0 * (double)this.iIter / (double)this.getTimeMillis()) + " it/s");
                HillClimber.this.logNeibourStatus();
            }
            HillClimber.this.setProgress(Math.round(100.0 * (double)(this.iIter - this.iLastImprovingIter) / (double)HillClimber.this.iMaxIdleIters));
        }

        @Override
        protected boolean canContinue(Solution<V, T> solution) {
            return this.iIter - this.iLastImprovingIter < HillClimber.this.iMaxIdleIters;
        }

        @Override
        protected void activate(Solution<V, T> solution) {
            super.activate(solution);
            this.iLastImprovingIter = this.iIter;
        }

        @Override
        protected boolean accept(Assignment<V, T> assignment, Model<V, T> model, Neighbour<V, T> neighbour, double value, boolean lazy) {
            if (value < -sEPS) {
                this.iLastImprovingIter = this.iIter;
            }
            return value <= 0.0;
        }
    }
}

