/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.online.selection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.GlobalConstraint;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.JProf;
import org.cpsolver.studentsct.constraint.DependentCourses;
import org.cpsolver.studentsct.constraint.LinkedSections;
import org.cpsolver.studentsct.heuristics.selection.BranchBoundSelection;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.online.OnlineSectioningModel;
import org.cpsolver.studentsct.online.selection.EqualWeightCriterion;
import org.cpsolver.studentsct.online.selection.OnlineSectioningCriterion;
import org.cpsolver.studentsct.online.selection.OnlineSectioningSelection;

public class MultiCriteriaBranchAndBoundSelection
implements OnlineSectioningSelection {
    protected int iTimeout = 1000;
    protected OnlineSectioningModel iModel = null;
    protected Assignment<Request, Enrollment> iAssignment = null;
    protected SelectionCriterion iComparator = null;
    private boolean iPriorityWeighting = true;
    protected boolean iBranchWhenSelectedHasNoConflict = false;
    private double iMaxOverExpected = -1.0;
    protected Student iStudent;
    protected long iT0;
    protected long iT1;
    protected boolean iTimeoutReached;
    protected Enrollment[] iCurrentAssignment;
    protected Enrollment[] iBestAssignment;
    protected HashMap<CourseRequest, List<Enrollment>> iValues;
    private Set<FreeTimeRequest> iRequiredFreeTimes;
    private Hashtable<CourseRequest, Set<Section>> iPreferredSections;
    private Hashtable<CourseRequest, Config> iRequiredConfig = new Hashtable();
    private Hashtable<CourseRequest, Hashtable<Subpart, Section>> iRequiredSection = new Hashtable();
    private Set<CourseRequest> iRequiredUnassinged = null;

    public MultiCriteriaBranchAndBoundSelection(DataProperties config) {
        this.iTimeout = config.getPropertyInt("Neighbour.BranchAndBoundTimeout", this.iTimeout);
        this.iPriorityWeighting = config.getPropertyBoolean("StudentWeights.PriorityWeighting", this.iPriorityWeighting);
        this.iBranchWhenSelectedHasNoConflict = config.getPropertyBoolean("Students.BranchWhenSelectedHasNoConflict", this.iBranchWhenSelectedHasNoConflict);
    }

    @Override
    public void setModel(OnlineSectioningModel model) {
        this.iModel = model;
    }

    @Override
    public void setPreferredSections(Hashtable<CourseRequest, Set<Section>> preferredSections) {
        this.iPreferredSections = preferredSections;
    }

    public void setTimeout(int timeout) {
        this.iTimeout = timeout;
    }

    @Override
    public void setRequiredSections(Hashtable<CourseRequest, Set<Section>> requiredSections) {
        if (requiredSections != null) {
            for (Map.Entry<CourseRequest, Set<Section>> entry : requiredSections.entrySet()) {
                Hashtable<Subpart, Section> subSection = new Hashtable<Subpart, Section>();
                this.iRequiredSection.put(entry.getKey(), subSection);
                for (Section section : entry.getValue()) {
                    if (subSection.isEmpty()) {
                        this.iRequiredConfig.put(entry.getKey(), section.getSubpart().getConfig());
                    }
                    subSection.put(section.getSubpart(), section);
                }
            }
        }
    }

    @Override
    public void setRequiredFreeTimes(Set<FreeTimeRequest> requiredFreeTimes) {
        this.iRequiredFreeTimes = requiredFreeTimes;
    }

    public BranchBoundSelection.BranchBoundNeighbour select(Assignment<Request, Enrollment> assignment, Student student, SelectionCriterion comparator) {
        this.iStudent = student;
        this.iComparator = comparator;
        this.iAssignment = assignment;
        return this.select();
    }

    @Override
    public BranchBoundSelection.BranchBoundNeighbour select(Assignment<Request, Enrollment> assignment, Student student) {
        OnlineSectioningCriterion comparator = null;
        comparator = this.iPriorityWeighting ? new OnlineSectioningCriterion(student, this.iModel, assignment, this.iPreferredSections) : new EqualWeightCriterion(student, this.iModel, assignment, this.iPreferredSections);
        return this.select(assignment, student, comparator);
    }

    public BranchBoundSelection.BranchBoundNeighbour select() {
        this.iT0 = JProf.currentTimeMillis();
        this.iTimeoutReached = false;
        this.iCurrentAssignment = new Enrollment[this.iStudent.getRequests().size()];
        this.iBestAssignment = null;
        int i = 0;
        for (Request r : this.iStudent.getRequests()) {
            this.iCurrentAssignment[i++] = (Enrollment)this.iAssignment.getValue((Variable)r);
        }
        this.saveBest();
        for (int j = 0; j < this.iCurrentAssignment.length; ++j) {
            this.iCurrentAssignment[j] = null;
        }
        this.iValues = new HashMap();
        this.backTrack(0);
        this.iT1 = JProf.currentTimeMillis();
        if (this.iBestAssignment == null) {
            return null;
        }
        return new BranchBoundSelection.BranchBoundNeighbour(this.iStudent, this.iComparator.getTotalWeight(this.iAssignment, this.iBestAssignment), this.iBestAssignment);
    }

    public boolean isTimeoutReached() {
        return this.iTimeoutReached;
    }

    public long getTime() {
        return this.iT1 - this.iT0;
    }

    public void saveBest() {
        if (this.iBestAssignment == null) {
            this.iBestAssignment = new Enrollment[this.iCurrentAssignment.length];
        }
        for (int i = 0; i < this.iCurrentAssignment.length; ++i) {
            this.iBestAssignment[i] = this.iCurrentAssignment[i];
        }
    }

    public boolean inConflict(final int idx, final Enrollment enrollment) {
        for (GlobalConstraint constraint : ((Request)enrollment.variable()).getModel().globalConstraints()) {
            if (!(constraint instanceof DependentCourses ? ((DependentCourses)constraint).isPartialScheduleInConflict(this.iStudent, new LinkedSections.EnrollmentAssignment(){

                @Override
                public Enrollment getEnrollment(Request request, int index) {
                    return index == idx ? enrollment : MultiCriteriaBranchAndBoundSelection.this.iCurrentAssignment[index];
                }
            }, idx) : constraint.inConflict(this.iAssignment, (Value)enrollment))) continue;
            return true;
        }
        for (LinkedSections linkedSections : this.iStudent.getLinkedSections()) {
            if (linkedSections.inConflict(enrollment, new LinkedSections.EnrollmentAssignment(){

                @Override
                public Enrollment getEnrollment(Request request, int index) {
                    return index == idx ? enrollment : MultiCriteriaBranchAndBoundSelection.this.iCurrentAssignment[index];
                }
            }) == null) continue;
            return true;
        }
        float credit = enrollment.getCredit();
        for (int i = 0; i < this.iCurrentAssignment.length; ++i) {
            if (this.iCurrentAssignment[i] == null || i == idx || !((credit += this.iCurrentAssignment[i].getCredit()) > this.iStudent.getMaxCredit()) && !this.iCurrentAssignment[i].isOverlapping(enrollment)) continue;
            return true;
        }
        if (this.iMaxOverExpected >= 0.0) {
            double penalty = 0.0;
            for (int i = 0; i < idx; ++i) {
                if (this.iCurrentAssignment[i] == null || this.iCurrentAssignment[i].getAssignments() == null || !this.iCurrentAssignment[i].isCourseRequest()) continue;
                for (Section section : this.iCurrentAssignment[i].getSections()) {
                    penalty += this.iModel.getOverExpected(this.iAssignment, this.iCurrentAssignment, i, section, this.iCurrentAssignment[i].getRequest());
                }
            }
            if (enrollment.isCourseRequest()) {
                for (Section section : enrollment.getSections()) {
                    penalty += this.iModel.getOverExpected(this.iAssignment, this.iCurrentAssignment, idx, section, enrollment.getRequest());
                }
            }
            if (penalty > this.iMaxOverExpected) {
                return true;
            }
        }
        return !this.isAllowed(idx, enrollment);
    }

    public boolean canAssign(Request request, int idx) {
        if (this.iCurrentAssignment[idx] != null) {
            return true;
        }
        int alt = 0;
        int i = 0;
        float credit = 0.0f;
        for (Request r : this.iStudent.getRequests()) {
            if (r.equals((Object)request)) {
                credit += r.getMinCredit();
            } else if (this.iCurrentAssignment[i] != null) {
                credit += this.iCurrentAssignment[i].getCredit();
            }
            if (!r.equals((Object)request)) {
                if (r.isAlternative()) {
                    if (this.iCurrentAssignment[i] != null || r instanceof CourseRequest && ((CourseRequest)r).isWaitlist()) {
                        --alt;
                    }
                } else if (r instanceof CourseRequest && !((CourseRequest)r).isWaitlist() && this.iCurrentAssignment[i] == null) {
                    ++alt;
                }
            }
            ++i;
        }
        return (!request.isAlternative() || alt > 0) && credit <= request.getStudent().getMaxCredit();
    }

    public boolean isAllowed(int idx, Enrollment enrollment) {
        if (enrollment.isCourseRequest()) {
            CourseRequest request = (CourseRequest)enrollment.getRequest();
            if (this.iRequiredUnassinged != null && this.iRequiredUnassinged.contains((Object)request)) {
                return false;
            }
            Config reqConfig = this.iRequiredConfig.get((Object)request);
            if (reqConfig != null) {
                if (!reqConfig.equals((Object)enrollment.getConfig())) {
                    return false;
                }
                Hashtable<Subpart, Section> reqSections = this.iRequiredSection.get((Object)request);
                for (Section section : enrollment.getSections()) {
                    Section reqSection = reqSections.get(section.getSubpart());
                    if (reqSection == null || section.equals(reqSection)) continue;
                    return false;
                }
            }
        } else if (this.iRequiredFreeTimes.contains((Object)enrollment.getRequest()) && (enrollment.getAssignments() == null || enrollment.getAssignments().isEmpty())) {
            return false;
        }
        return true;
    }

    protected boolean canLeaveUnassigned(Request request) {
        if (request instanceof CourseRequest ? this.iRequiredConfig.get((Object)request) != null : this.iRequiredFreeTimes.contains((Object)request)) {
            return false;
        }
        return this.iModel.getDependentCoursesConstraint() == null || this.iModel.getDependentCoursesConstraint().canLeaveUnassigned(this.iStudent, new LinkedSections.EnrollmentAssignment(){

            @Override
            public Enrollment getEnrollment(Request r, int index) {
                return MultiCriteriaBranchAndBoundSelection.this.iCurrentAssignment[index];
            }
        }, request);
    }

    protected List<Enrollment> values(CourseRequest request) {
        if (this.iRequiredUnassinged != null && this.iRequiredUnassinged.contains((Object)request)) {
            return new ArrayList<Enrollment>();
        }
        List<Enrollment> values = request.getAvaiableEnrollments(this.iAssignment, false);
        Collections.sort(values, new Comparator<Enrollment>(){

            @Override
            public int compare(Enrollment o1, Enrollment o2) {
                return MultiCriteriaBranchAndBoundSelection.this.iComparator.compare(MultiCriteriaBranchAndBoundSelection.this.iAssignment, o1, o2);
            }
        });
        return values;
    }

    public void backTrack(int idx) {
        if (this.iTimeout > 0 && JProf.currentTimeMillis() - this.iT0 > (long)this.iTimeout) {
            this.iTimeoutReached = true;
            return;
        }
        if (idx == this.iCurrentAssignment.length) {
            if (this.iBestAssignment == null || this.iComparator.compare(this.iAssignment, this.iCurrentAssignment, this.iBestAssignment) < 0) {
                this.saveBest();
            }
            return;
        }
        if (this.iBestAssignment != null && !this.iComparator.canImprove(this.iAssignment, idx, this.iCurrentAssignment, this.iBestAssignment)) {
            return;
        }
        Request request = this.iStudent.getRequests().get(idx);
        if (!this.canAssign(request, idx)) {
            this.backTrack(idx + 1);
            return;
        }
        List<Enrollment> values = null;
        if (request instanceof CourseRequest) {
            CourseRequest courseRequest = (CourseRequest)request;
            if (!courseRequest.getSelectedChoices().isEmpty() && (values = courseRequest.getSelectedEnrollments(this.iAssignment, true)) != null && !values.isEmpty()) {
                boolean hasNoConflictValue = false;
                for (Enrollment enrollment : values) {
                    if (this.inConflict(idx, enrollment)) continue;
                    hasNoConflictValue = true;
                    this.iCurrentAssignment[idx] = enrollment;
                    this.backTrack(idx + 1);
                    this.iCurrentAssignment[idx] = null;
                }
                if (hasNoConflictValue && this.iBranchWhenSelectedHasNoConflict) {
                    return;
                }
            }
            if ((values = this.iValues.get((Object)courseRequest)) == null) {
                values = this.values(courseRequest);
                this.iValues.put(courseRequest, values);
            }
        } else {
            values = request.computeEnrollments(this.iAssignment);
        }
        boolean hasNoConflictValue = false;
        for (Enrollment enrollment : values) {
            if (this.inConflict(idx, enrollment)) continue;
            hasNoConflictValue = true;
            this.iCurrentAssignment[idx] = enrollment;
            this.backTrack(idx + 1);
            this.iCurrentAssignment[idx] = null;
        }
        if (this.canLeaveUnassigned(request) || !hasNoConflictValue && request instanceof CourseRequest) {
            this.backTrack(idx + 1);
        }
    }

    @Override
    public void setRequiredUnassinged(Set<CourseRequest> requiredUnassignedRequests) {
        this.iRequiredUnassinged = requiredUnassignedRequests;
    }

    @Override
    public void setMaxOverExpected(double maxOverExpected) {
        this.iMaxOverExpected = maxOverExpected;
    }

    public static interface SelectionCriterion
    extends SelectionComparator {
        public int compare(Assignment<Request, Enrollment> var1, Enrollment[] var2, Enrollment[] var3);

        public boolean canImprove(Assignment<Request, Enrollment> var1, int var2, Enrollment[] var3, Enrollment[] var4);

        public double getTotalWeight(Assignment<Request, Enrollment> var1, Enrollment[] var2);
    }

    public static interface SelectionComparator {
        public int compare(Assignment<Request, Enrollment> var1, Enrollment var2, Enrollment var3);
    }
}

