/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.model;

import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.cpsolver.exam.criteria.ExamCriterion;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamPeriod;
import org.cpsolver.exam.model.ExamPeriodPlacement;
import org.cpsolver.exam.model.ExamRoom;
import org.cpsolver.exam.model.ExamRoomPlacement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.criteria.Criterion;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;

public class ExamPlacement
extends Value<Exam, ExamPlacement> {
    private ExamPeriodPlacement iPeriodPlacement;
    private Set<ExamRoomPlacement> iRoomPlacements;
    private Integer iHashCode = null;

    public ExamPlacement(Exam exam, ExamPeriodPlacement periodPlacement, Set<ExamRoomPlacement> roomPlacements) {
        super((Variable)exam);
        this.iPeriodPlacement = periodPlacement;
        this.iRoomPlacements = roomPlacements == null ? new HashSet<ExamRoomPlacement>() : roomPlacements;
    }

    public ExamPeriod getPeriod() {
        return this.iPeriodPlacement.getPeriod();
    }

    public ExamPeriodPlacement getPeriodPlacement() {
        return this.iPeriodPlacement;
    }

    public Set<ExamRoomPlacement> getRoomPlacements() {
        return this.iRoomPlacements;
    }

    public double getDistanceInMeters(ExamPlacement other) {
        if (this.getRoomPlacements().isEmpty() || other.getRoomPlacements().isEmpty()) {
            return 0.0;
        }
        double maxDistance = 0.0;
        for (ExamRoomPlacement r1 : this.getRoomPlacements()) {
            for (ExamRoomPlacement r2 : other.getRoomPlacements()) {
                maxDistance = Math.max(maxDistance, r1.getDistanceInMeters(r2));
            }
        }
        return maxDistance;
    }

    public double toDouble(Assignment<Exam, ExamPlacement> assignment) {
        double ret = 0.0;
        for (Criterion criterion : ((Exam)this.variable()).getModel().getCriteria()) {
            ret += criterion.getWeightedValue(assignment, (Value)this, null);
        }
        return ret;
    }

    public double getTimeCost(Assignment<Exam, ExamPlacement> assignment) {
        double weight = 0.0;
        for (Criterion criterion : ((Exam)this.variable()).getModel().getCriteria()) {
            if (!((ExamCriterion)criterion).isPeriodCriterion()) continue;
            weight += criterion.getWeight() * ((ExamCriterion)criterion).getPeriodValue(assignment, this);
        }
        return weight;
    }

    public double getRoomCost(Assignment<Exam, ExamPlacement> assignment) {
        double weight = 0.0;
        for (Criterion criterion : ((Exam)this.variable()).getModel().getCriteria()) {
            if (!((ExamCriterion)criterion).isRoomCriterion()) continue;
            weight += criterion.getWeight() * ((ExamCriterion)criterion).getRoomValue(assignment, this);
        }
        return weight;
    }

    public String getRoomName(String delim) {
        String roomName = "";
        Iterator<ExamRoomPlacement> i = this.getRoomPlacements().iterator();
        while (i.hasNext()) {
            ExamRoomPlacement r = i.next();
            roomName = roomName + r.getRoom().getName();
            if (!i.hasNext()) continue;
            roomName = roomName + delim;
        }
        return roomName;
    }

    public String getName() {
        return this.getPeriod() + " " + this.getRoomName(",");
    }

    public String toString(Assignment<Exam, ExamPlacement> assignment) {
        String ret = "";
        for (Criterion criterion : ((Exam)this.variable()).getModel().getCriteria()) {
            String val = ((ExamCriterion)criterion).toString(assignment);
            if (val.isEmpty()) continue;
            ret = ret + (!ret.isEmpty() && !ret.endsWith(",") ? "," : "") + val;
        }
        return ((Exam)this.variable()).getName() + " = " + this.getName() + " (" + new DecimalFormat("0.00").format(this.toDouble(assignment)) + "/" + ret + ")";
    }

    public String toString() {
        return ((Exam)this.variable()).getName() + " = " + this.getName();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ExamPlacement)) {
            return false;
        }
        ExamPlacement p = (ExamPlacement)((Object)o);
        return ((Exam)p.variable()).equals(this.variable()) && p.getPeriod().equals(this.getPeriod()) && p.getRoomPlacements().equals(this.getRoomPlacements());
    }

    public int hashCode() {
        if (this.iHashCode == null) {
            this.iHashCode = this.getName().hashCode();
        }
        return this.iHashCode;
    }

    public boolean contains(ExamRoom room) {
        return this.getRoomPlacements().contains(new ExamRoomPlacement(room));
    }
}

