/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.heuristics.studentord;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.heuristics.studentord.StudentOrder;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Subpart;

public class StudentChoiceOrder
implements StudentOrder,
Comparator<Student> {
    private boolean iReverse = false;
    private boolean iFast = true;
    private boolean iCriticalOnly = false;
    private Request.RequestPriority iPriority = Request.RequestPriority.Critical;
    private HashMap<Config, Integer> iCache = new HashMap();

    public StudentChoiceOrder(DataProperties config) {
        this.iReverse = config.getPropertyBoolean("StudentChoiceOrder.Reverse", this.iReverse);
        this.iFast = config.getPropertyBoolean("StudentChoiceOrder.Fast", this.iFast);
        this.iCriticalOnly = config.getPropertyBoolean("StudentChoiceOrder.CriticalOnly", this.iCriticalOnly);
    }

    public boolean isReverse() {
        return this.iReverse;
    }

    public void setReverse(boolean reverse) {
        this.iReverse = reverse;
    }

    public boolean isCriticalOnly() {
        return this.iCriticalOnly;
    }

    public void setCriticalOnly(boolean critOnly) {
        this.iCriticalOnly = critOnly;
    }

    public void setRequestPriority(Request.RequestPriority priority) {
        this.iPriority = priority;
    }

    public Request.RequestPriority getRequestPriority() {
        return this.iPriority;
    }

    @Override
    public List<Student> order(List<Student> students) {
        ArrayList<Student> ret = new ArrayList<Student>(students);
        Collections.sort(ret, this);
        return ret;
    }

    @Override
    public int compare(Student s1, Student s2) {
        if (s1.getPriority() != s2.getPriority()) {
            return s1.getPriority().ordinal() < s2.getPriority().ordinal() ? -1 : 1;
        }
        try {
            int cmp = -Double.compare(this.avgNrChoices(s1), this.avgNrChoices(s2));
            if (cmp != 0) {
                return (this.iReverse ? -1 : 1) * cmp;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (this.iReverse ? -1 : 1) * Double.compare(s1.getId(), s2.getId());
    }

    private int nrChoices(Config config, int idx, HashSet<Section> sections) {
        if (this.iFast) {
            int nrChoices = 1;
            for (Subpart subpart : config.getSubparts()) {
                if (!subpart.getChildren().isEmpty()) continue;
                nrChoices *= subpart.getSections().size();
            }
            return nrChoices;
        }
        if (config.getSubparts().size() == idx) {
            return 1;
        }
        Subpart subpart = config.getSubparts().get(idx);
        int choicesThisSubpart = 0;
        for (Section section : subpart.getSections()) {
            if (section.getParent() != null && !sections.contains(section.getParent()) || section.isOverlapping(sections)) continue;
            sections.add(section);
            choicesThisSubpart += this.nrChoices(config, idx + 1, sections);
            sections.remove(section);
        }
        return choicesThisSubpart;
    }

    public double avgNrChoices(Student student) {
        int nrRequests = 0;
        int nrChoices = 0;
        for (Request request : student.getRequests()) {
            if (!(request instanceof CourseRequest)) continue;
            CourseRequest cr = (CourseRequest)request;
            if (this.iCriticalOnly && (!this.iPriority.isCritical(cr) || cr.isAlternative())) continue;
            for (Course course : cr.getCourses()) {
                for (Config config : course.getOffering().getConfigs()) {
                    Integer nrChoicesThisCfg = this.iCache.get((Object)config);
                    if (nrChoicesThisCfg == null) {
                        nrChoicesThisCfg = this.nrChoices(config, 0, new HashSet<Section>());
                        this.iCache.put(config, nrChoicesThisCfg);
                    }
                    nrChoices += nrChoicesThisCfg.intValue();
                }
            }
            ++nrRequests;
        }
        return nrRequests == 0 ? 0.0 : (double)nrChoices / (double)nrRequests;
    }
}

