/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.criteria.additional;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.cpsolver.coursett.constraint.JenrlConstraint;
import org.cpsolver.coursett.criteria.StudentConflict;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.Student;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.DataProperties;

public class StudentMinimizeDaysOfWeek
extends StudentConflict {
    public static double dayDistance(Placement p1, Placement p2) {
        if (p1 == null || p2 == null) {
            return 0.0;
        }
        return StudentMinimizeDaysOfWeek.dayDistance(p1.getTimeLocation(), p2.getTimeLocation());
    }

    private static double dayDistance(TimeLocation t1, TimeLocation t2) {
        if (!t1.shareWeeks(t2)) {
            return 0.0;
        }
        return 1.0 - (double)t1.nrSharedDays(t2) / (double)Math.min(t1.getNrMeetings(), t2.getNrMeetings());
    }

    @Override
    public boolean inConflict(Placement p1, Placement p2) {
        return StudentMinimizeDaysOfWeek.dayDistance(p1, p2) > 0.0;
    }

    @Override
    protected double jointEnrollment(JenrlConstraint jenrl, Placement p1, Placement p2) {
        return StudentMinimizeDaysOfWeek.dayDistance(p1, p2) * jenrl.jenrl();
    }

    @Override
    protected double jointEnrollment(JenrlConstraint jenrl) {
        double max = 0.0;
        for (TimeLocation t1 : ((Lecture)jenrl.first()).timeLocations()) {
            for (TimeLocation t2 : ((Lecture)jenrl.second()).timeLocations()) {
                double distance = StudentMinimizeDaysOfWeek.dayDistance(t1, t2);
                if (!(distance > max)) continue;
                max = distance;
            }
        }
        return max;
    }

    @Override
    public boolean isApplicable(Lecture l1, Lecture l2) {
        return l1 != null && l2 != null && !StudentMinimizeDaysOfWeek.ignore(l1, l2) && StudentMinimizeDaysOfWeek.applicable(l1, l2);
    }

    @Override
    public void incJenrl(Assignment<Lecture, Placement> assignment, JenrlConstraint jenrl, double studentWeight, Double conflictPriority, Student student) {
        if (this.isApplicable(student, (Lecture)jenrl.first(), (Lecture)jenrl.second())) {
            this.inc(assignment, studentWeight * StudentMinimizeDaysOfWeek.dayDistance((Placement)assignment.getValue(jenrl.first()), (Placement)assignment.getValue(jenrl.second())));
        }
    }

    public double getWeightDefault(DataProperties config) {
        return config.getPropertyDouble("Comparator.MinimizeStudentScheduleDaysWeight", 0.05 * config.getPropertyDouble("Comparator.StudentConflictWeight", 1.0));
    }

    @Override
    public String getPlacementSelectionWeightName() {
        return "Placement.MinimizeStudentScheduleDaysWeight";
    }

    public void getInfo(Assignment<Lecture, Placement> assignment, Map<String, String> info) {
        super.getInfo(assignment, info);
        double total = 0.0;
        for (JenrlConstraint jenrl : ((TimetableModel)this.getModel()).getJenrlConstraints()) {
            if (jenrl.isToBeIgnored()) continue;
            total += jenrl.jenrl();
        }
        info.put("Student different days", sDoubleFormat.format(this.getValue(assignment) / total));
    }

    public void getInfo(Assignment<Lecture, Placement> assignment, Map<String, String> info, Collection<Lecture> variables) {
        super.getInfo(assignment, info, variables);
        HashSet<JenrlConstraint> jenrls = new HashSet<JenrlConstraint>();
        double distance = 0.0;
        double total = 0.0;
        for (Lecture lecture : variables) {
            for (JenrlConstraint jenrl : lecture.jenrlConstraints()) {
                if (!jenrls.add(jenrl) || jenrl.isToBeIgnored()) continue;
                distance += jenrl.jenrl() * StudentMinimizeDaysOfWeek.dayDistance((Placement)assignment.getValue(jenrl.first()), (Placement)assignment.getValue(jenrl.second()));
                total += jenrl.jenrl();
            }
        }
        info.put("Student different days", sDoubleFormat.format(distance / total));
    }
}

