/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.neighbours;

import java.util.Collection;
import java.util.Set;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamModel;
import org.cpsolver.exam.model.ExamPeriodPlacement;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.model.ExamRoomPlacement;
import org.cpsolver.exam.neighbours.ExamSimpleNeighbour;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.heuristics.NeighbourSelection;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ToolBox;

public class ExamTimeMove
implements NeighbourSelection<Exam, ExamPlacement> {
    private boolean iCheckStudentConflicts = false;
    private boolean iCheckDistributionConstraints = true;

    public ExamTimeMove(DataProperties properties) {
        this.iCheckStudentConflicts = properties.getPropertyBoolean("ExamTimeMove.CheckStudentConflicts", this.iCheckStudentConflicts);
        this.iCheckDistributionConstraints = properties.getPropertyBoolean("ExamTimeMove.CheckDistributionConstraints", this.iCheckDistributionConstraints);
    }

    public void init(Solver<Exam, ExamPlacement> solver) {
    }

    public Neighbour<Exam, ExamPlacement> selectNeighbour(Solution<Exam, ExamPlacement> solution) {
        ExamModel model = (ExamModel)solution.getModel();
        Assignment assignment = solution.getAssignment();
        Exam exam = (Exam)((Object)ToolBox.random((Collection)model.variables()));
        ExamPlacement placement = (ExamPlacement)assignment.getValue((Variable)exam);
        int px = ToolBox.random((int)exam.getPeriodPlacements().size());
        for (int p = 0; p < exam.getPeriodPlacements().size(); ++p) {
            Set<ExamRoomPlacement> rooms;
            ExamPeriodPlacement period = exam.getPeriodPlacements().get((p + px) % exam.getPeriodPlacements().size());
            if (placement != null && placement.getPeriod().equals(period.getPeriod()) || this.iCheckStudentConflicts && exam.countStudentConflicts((Assignment<Exam, ExamPlacement>)assignment, period) > 0 || this.iCheckDistributionConstraints && !exam.checkDistributionConstraints((Assignment<Exam, ExamPlacement>)assignment, period)) continue;
            if (placement != null) {
                boolean ok = true;
                for (ExamRoomPlacement room : placement.getRoomPlacements()) {
                    if (room.isAvailable(period.getPeriod()) && !room.getRoom().inConflict((Assignment<Exam, ExamPlacement>)assignment, exam, period.getPeriod())) continue;
                    ok = false;
                    break;
                }
                if (ok) {
                    return new ExamSimpleNeighbour((Assignment<Exam, ExamPlacement>)assignment, new ExamPlacement(exam, period, placement.getRoomPlacements()));
                }
            }
            if ((rooms = exam.findBestAvailableRooms((Assignment<Exam, ExamPlacement>)assignment, period)) == null) continue;
            return new ExamSimpleNeighbour((Assignment<Exam, ExamPlacement>)assignment, new ExamPlacement(exam, period, rooms));
        }
        return null;
    }
}

