/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.reports;

import java.util.ArrayList;
import java.util.Iterator;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamModel;
import org.cpsolver.exam.model.ExamOwner;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.model.ExamRoomPlacement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.CSVFile;

public class ExamCourseSectionAssignments {
    private ExamModel iModel = null;

    public ExamCourseSectionAssignments(ExamModel model) {
        this.iModel = model;
    }

    public CSVFile report(Assignment<Exam, ExamPlacement> assignment) {
        CSVFile csv = new CSVFile();
        csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)"Section/Course"), new CSVFile.CSVField((Object)"Enrl"), new CSVFile.CSVField((Object)"Alt"), new CSVFile.CSVField((Object)"Period"), new CSVFile.CSVField((Object)"Date"), new CSVFile.CSVField((Object)"Time"), new CSVFile.CSVField((Object)"Room"), new CSVFile.CSVField((Object)"Cap")});
        for (Exam exam : this.iModel.variables()) {
            ExamPlacement placement = (ExamPlacement)assignment.getValue((Variable)exam);
            for (ExamOwner owner : exam.getOwners()) {
                ArrayList<CSVFile.CSVField> fields = new ArrayList<CSVFile.CSVField>();
                fields.add(new CSVFile.CSVField((Object)owner.getName()));
                fields.add(new CSVFile.CSVField(owner.getStudents().size()));
                fields.add(new CSVFile.CSVField((Object)(exam.hasAltSeating() ? "Yes" : "No")));
                if (placement == null) {
                    fields.add(new CSVFile.CSVField((Object)""));
                    fields.add(new CSVFile.CSVField((Object)""));
                    fields.add(new CSVFile.CSVField((Object)""));
                    fields.add(new CSVFile.CSVField((Object)""));
                    fields.add(new CSVFile.CSVField((Object)""));
                } else {
                    fields.add(new CSVFile.CSVField(placement.getPeriod().getIndex() + 1));
                    fields.add(new CSVFile.CSVField((Object)placement.getPeriod().getDayStr()));
                    fields.add(new CSVFile.CSVField((Object)placement.getPeriod().getTimeStr()));
                    String rooms = "";
                    String roomSizes = "";
                    Iterator<ExamRoomPlacement> i = placement.getRoomPlacements().iterator();
                    while (i.hasNext()) {
                        ExamRoomPlacement room = i.next();
                        rooms = rooms + room.getName();
                        roomSizes = roomSizes + room.getSize(exam.hasAltSeating());
                        if (!i.hasNext()) continue;
                        rooms = rooms + ", ";
                        roomSizes = roomSizes + ", ";
                    }
                    fields.add(new CSVFile.CSVField((Object)rooms));
                    fields.add(new CSVFile.CSVField((Object)roomSizes));
                }
                csv.addLine(fields);
            }
        }
        return csv;
    }
}

