/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.heuristics;

import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamModel;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.heuristics.VariableSelection;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ToolBox;

public class ExamUnassignedVariableSelection
implements VariableSelection<Exam, ExamPlacement> {
    private boolean iRandomSelection = true;

    public ExamUnassignedVariableSelection(DataProperties properties) {
        this.iRandomSelection = properties.getPropertyBoolean("ExamUnassignedVariableSelection.random", this.iRandomSelection);
    }

    public void init(Solver<Exam, ExamPlacement> solver) {
    }

    public Exam selectVariable(Solution<Exam, ExamPlacement> solution) {
        ExamModel model = (ExamModel)solution.getModel();
        Assignment assignment = solution.getAssignment();
        if (model.variables().size() == assignment.nrAssignedVariables()) {
            return null;
        }
        if (this.iRandomSelection) {
            int idx = ToolBox.random((int)(model.variables().size() - assignment.nrAssignedVariables()));
            for (Exam v : model.variables()) {
                if (assignment.getValue((Variable)v) != null) continue;
                if (idx == 0) {
                    return v;
                }
                --idx;
            }
        }
        Exam variable = null;
        for (Exam v : model.variables()) {
            if (assignment.getValue((Variable)v) != null || variable != null && v.compareTo(variable) >= 0) continue;
            variable = v;
        }
        return variable;
    }
}

