/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.criteria.additional;

import java.util.Collection;
import java.util.Set;
import org.cpsolver.exam.criteria.ExamCriterion;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamPeriodPlacement;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.ifs.assignment.Assignment;

public class PeriodViolation
extends ExamCriterion {
    @Override
    public String getWeightName() {
        return "Exam.SoftPeriods";
    }

    @Override
    public String getXmlWeightName() {
        return "softPeriods";
    }

    public double getValue(Assignment<Exam, ExamPlacement> assignment, ExamPlacement value, Set<ExamPlacement> conflicts) {
        return (double)value.getPeriodPlacement().getExamPenalty() == this.getWeight() || (double)value.getPeriodPlacement().getPeriod().getPenalty() == this.getWeight() ? 1.0 : 0.0;
    }

    @Override
    public double[] getBounds(Assignment<Exam, ExamPlacement> assignment, Collection<Exam> variables) {
        double[] bounds = new double[]{0.0, 0.0};
        block0: for (Exam exam : variables) {
            if (exam.getPeriodPlacements().isEmpty()) continue;
            for (ExamPeriodPlacement periodPlacement : exam.getPeriodPlacements()) {
                if ((double)periodPlacement.getExamPenalty() != this.getWeight() && (double)periodPlacement.getPeriod().getPenalty() != this.getWeight()) continue;
                bounds[1] = bounds[1] + 1.0;
                continue block0;
            }
        }
        return bounds;
    }

    public String toString(Assignment<Exam, ExamPlacement> assignment) {
        return this.getValue(assignment) <= 0.0 ? "" : "!P:" + sDoubleFormat.format(this.getValue(assignment));
    }
}

