/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.criteria;

import java.util.Map;
import java.util.Set;
import org.cpsolver.exam.criteria.ExamCriterion;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.criteria.AbstractCriterion;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.DataProperties;

public class ExamRotationPenalty
extends ExamCriterion {
    public AbstractCriterion.ValueContext createAssignmentContext(Assignment<Exam, ExamPlacement> assignment) {
        return new RotationContext(assignment);
    }

    @Override
    public String getWeightName() {
        return "Exams.RotationWeight";
    }

    @Override
    public String getXmlWeightName() {
        return "examRotationWeight";
    }

    public double getWeightDefault(DataProperties config) {
        return 0.001;
    }

    public double getValue(Assignment<Exam, ExamPlacement> assignment, ExamPlacement value, Set<ExamPlacement> conflicts) {
        if (((Exam)value.variable()).getAveragePeriod() < 0) {
            return 0.0;
        }
        return (1 + value.getPeriod().getIndex()) * (1 + ((Exam)value.variable()).getAveragePeriod());
    }

    public int nrAssignedExamsWithAvgPeriod(Assignment<Exam, ExamPlacement> assignment) {
        return ((RotationContext)this.getContext(assignment)).nrAssignedExamsWithAvgPeriod();
    }

    public double averagePeriod(Assignment<Exam, ExamPlacement> assignment) {
        return ((RotationContext)this.getContext(assignment)).averagePeriod();
    }

    @Override
    public void getInfo(Assignment<Exam, ExamPlacement> assignment, Map<String, String> info) {
        if (this.getValue(assignment) != 0.0) {
            info.put(this.getName(), sDoubleFormat.format(Math.sqrt(this.getValue(assignment) / (double)this.nrAssignedExamsWithAvgPeriod(assignment)) - 1.0));
        }
    }

    public String toString(Assignment<Exam, ExamPlacement> assignment) {
        return "@P:" + sDoubleFormat.format(Math.sqrt(this.getValue(assignment) / (double)this.nrAssignedExamsWithAvgPeriod(assignment)) - 1.0);
    }

    protected class RotationContext
    extends AbstractCriterion.ValueContext {
        private int iAssignedExamsWithAvgPeriod;
        private double iAveragePeriod;

        public RotationContext(Assignment<Exam, ExamPlacement> assignment) {
            super((AbstractCriterion)ExamRotationPenalty.this, assignment);
            this.iAssignedExamsWithAvgPeriod = 0;
            this.iAveragePeriod = 0.0;
            for (Exam exam : ExamRotationPenalty.this.getModel().variables()) {
                ExamPlacement placement;
                if (exam.getAveragePeriod() <= 0 || (placement = (ExamPlacement)assignment.getValue((Variable)exam)) == null) continue;
                ++this.iAssignedExamsWithAvgPeriod;
                this.iAveragePeriod += (double)exam.getAveragePeriod();
            }
        }

        public void assigned(Assignment<Exam, ExamPlacement> assignment, ExamPlacement value) {
            super.assigned(assignment, (Value)value);
            if (((Exam)value.variable()).getAveragePeriod() >= 0) {
                ++this.iAssignedExamsWithAvgPeriod;
                this.iAveragePeriod += (double)((Exam)value.variable()).getAveragePeriod();
            }
        }

        public void unassigned(Assignment<Exam, ExamPlacement> assignment, ExamPlacement value) {
            super.unassigned(assignment, (Value)value);
            if (((Exam)value.variable()).getAveragePeriod() >= 0) {
                --this.iAssignedExamsWithAvgPeriod;
                this.iAveragePeriod -= (double)((Exam)value.variable()).getAveragePeriod();
            }
        }

        public int nrAssignedExamsWithAvgPeriod() {
            return this.iAssignedExamsWithAvgPeriod;
        }

        public double averagePeriod() {
            return this.iAveragePeriod / (double)this.iAssignedExamsWithAvgPeriod;
        }
    }
}

