/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.report;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.model.Choice;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.report.AbstractStudentSectioningReport;
import org.cpsolver.studentsct.reservation.Reservation;

public class TableauReport
extends AbstractStudentSectioningReport {
    public TableauReport(StudentSectioningModel model) {
        super(model);
    }

    @Override
    public CSVFile createTable(Assignment<Request, Enrollment> assignment, DataProperties properties) {
        CSVFile csv = new CSVFile();
        boolean simple = properties.getPropertyBoolean("simple", false);
        if (simple) {
            csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)"__Student"), new CSVFile.CSVField((Object)"Student"), new CSVFile.CSVField((Object)"Course"), new CSVFile.CSVField((Object)"Course Limit"), new CSVFile.CSVField((Object)"Primary"), new CSVFile.CSVField((Object)"Priority"), new CSVFile.CSVField((Object)"Alternativity"), new CSVFile.CSVField((Object)"Enrolled"), new CSVFile.CSVField((Object)"Request Type")});
        } else {
            csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)"__Student"), new CSVFile.CSVField((Object)"Student"), new CSVFile.CSVField((Object)"Course"), new CSVFile.CSVField((Object)"Course Limit"), new CSVFile.CSVField((Object)"Controlling Course"), new CSVFile.CSVField((Object)"Primary"), new CSVFile.CSVField((Object)"Priority"), new CSVFile.CSVField((Object)"Alternativity"), new CSVFile.CSVField((Object)"Enrolled"), new CSVFile.CSVField((Object)"Credits"), new CSVFile.CSVField((Object)"Sections"), new CSVFile.CSVField((Object)"Preferred Sections"), new CSVFile.CSVField((Object)"Required Sections"), new CSVFile.CSVField((Object)"Instructional Method"), new CSVFile.CSVField((Object)"Preferred Instructional Methods"), new CSVFile.CSVField((Object)"Required Instructional Methods"), new CSVFile.CSVField((Object)"Request Type")});
        }
        for (Student student : this.getModel().getStudents()) {
            if (student.isDummy()) continue;
            int regPriority = 1;
            int altPriority = 1;
            for (Request r : student.getRequests()) {
                CourseRequest cr;
                Enrollment e;
                if (!(r instanceof CourseRequest) || !this.matches(r, e = (Enrollment)(cr = (CourseRequest)r).getAssignment(assignment))) continue;
                boolean primary = !cr.isAlternative();
                int priority = 0;
                priority = cr.isAlternative() ? altPriority++ : regPriority++;
                int alternativity = 0;
                for (Course course : cr.getCourses()) {
                    Object im;
                    boolean enrolled = e != null && e.getCourse().equals((Object)course);
                    String sect = null;
                    if (e != null && e.getCourse().equals((Object)course)) {
                        sect = "";
                        HashSet<Object> added = new HashSet<Object>();
                        for (Section s : e.getSections()) {
                            Object x = s.getName(e.getCourse().getId());
                            if (((String)x).indexOf(45) > 0) {
                                x = ((String)x).substring(0, ((String)x).indexOf(45));
                            }
                            if (!added.add(x)) continue;
                            sect = sect + (sect.isEmpty() ? "" : ",") + (String)x;
                        }
                    }
                    String imR = "";
                    String sctR = "";
                    HashSet<Object> addedR = new HashSet<Object>();
                    for (Choice ch : cr.getRequiredChoices()) {
                        if (!course.getOffering().equals(ch.getOffering())) continue;
                        if (ch.getConfigId() != null) {
                            for (Config config : ch.getOffering().getConfigs()) {
                                if (!ch.getConfigId().equals(config.getId()) || (im = config.getInstructionalMethodReference()) == null || !addedR.add(im)) continue;
                                imR = imR + (imR.isEmpty() ? "" : ",") + (String)im;
                            }
                        }
                        if (ch.getSectionId() == null) continue;
                        String x = ch.getOffering().getSection(ch.getSectionId()).getName(course.getId());
                        if (x.indexOf(45) > 0) {
                            x = x.substring(0, x.indexOf(45));
                        }
                        if (!addedR.add(x)) continue;
                        sctR = sctR + (sctR.isEmpty() ? "" : ",") + x;
                    }
                    for (Reservation rs : cr.getReservations(course)) {
                        if (!rs.mustBeUsed()) continue;
                        for (Map.Entry entry : rs.getSections().entrySet()) {
                            im = ((Set)entry.getValue()).iterator();
                            while (im.hasNext()) {
                                Section s = (Section)im.next();
                                String x = s.getName(course.getId());
                                if (x.indexOf(45) > 0) {
                                    x = x.substring(0, x.indexOf(45));
                                }
                                if (!addedR.add(x)) continue;
                                sctR = sctR + (sctR.isEmpty() ? "" : ",") + x;
                            }
                        }
                        if (!rs.getSections().isEmpty()) continue;
                        for (Config config : rs.getConfigs()) {
                            im = config.getInstructionalMethodReference();
                            if (im == null || !addedR.add(im)) continue;
                            imR = imR + (imR.isEmpty() ? "" : ",") + (String)im;
                        }
                    }
                    String imP = "";
                    String sctP = "";
                    for (Choice choice : cr.getSelectedChoices()) {
                        HashSet<String> added = new HashSet<String>();
                        if (!course.getOffering().equals(choice.getOffering())) continue;
                        if (choice.getConfigId() != null) {
                            for (Config cfg : choice.getOffering().getConfigs()) {
                                String im2;
                                if (!choice.getConfigId().equals(cfg.getId()) || (im2 = cfg.getInstructionalMethodReference()) == null || !added.add(im2)) continue;
                                imP = imP + (imP.isEmpty() ? "" : ",") + im2;
                            }
                        }
                        if (choice.getSectionId() == null) continue;
                        String x = choice.getOffering().getSection(choice.getSectionId()).getName(course.getId());
                        if (x.indexOf(45) > 0) {
                            x = x.substring(0, x.indexOf(45));
                        }
                        if (!added.add(x)) continue;
                        sctP = sctP + (sctP.isEmpty() ? "" : ",") + x;
                    }
                    if (simple) {
                        csv.addLine(new CSVFile.CSVField[]{new CSVFile.CSVField(student.getId()), new CSVFile.CSVField((Object)student.getExternalId()), new CSVFile.CSVField((Object)course.getName()), new CSVFile.CSVField(course.getLimit() < 0 ? null : Integer.valueOf(course.getLimit())), new CSVFile.CSVField((Object)(primary ? "Yes" : "No")), new CSVFile.CSVField(priority), new CSVFile.CSVField(alternativity), new CSVFile.CSVField((Object)(enrolled ? "Yes" : "No")), new CSVFile.CSVField((Object)(cr.getRequestPriority() == null ? "" : cr.getRequestPriority().name()))});
                    } else {
                        csv.addLine(new CSVFile.CSVField[]{new CSVFile.CSVField(student.getId()), new CSVFile.CSVField((Object)student.getExternalId()), new CSVFile.CSVField((Object)course.getName()), new CSVFile.CSVField(course.getLimit() < 0 ? null : Integer.valueOf(course.getLimit())), new CSVFile.CSVField(course.getOffering().getCourses().size() <= 1 ? null : course.getOffering().getName()), new CSVFile.CSVField((Object)(primary ? "Yes" : "No")), new CSVFile.CSVField(priority), new CSVFile.CSVField(alternativity), new CSVFile.CSVField((Object)(enrolled ? "Yes" : "No")), new CSVFile.CSVField(enrolled ? e.getCredit() : (course.getCreditValue() == null ? 0.0f : course.getCreditValue().floatValue())), new CSVFile.CSVField((Object)sect), new CSVFile.CSVField((Object)sctP), new CSVFile.CSVField((Object)sctR), new CSVFile.CSVField(e != null ? e.getConfig().getInstructionalMethodReference() : null), new CSVFile.CSVField((Object)imP), new CSVFile.CSVField((Object)imR), new CSVFile.CSVField((Object)(cr.getRequestPriority() == null ? "" : cr.getRequestPriority().name()))});
                    }
                    ++alternativity;
                }
            }
        }
        return csv;
    }
}

