/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.DefaultSingleAssignment;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.constraint.SectionLimit;
import org.cpsolver.studentsct.constraint.StudentConflict;
import org.cpsolver.studentsct.heuristics.selection.BranchBoundSelection;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Student;

public class StudentSctBBTest
extends Model<Request, Enrollment> {
    private Student iStudent = null;
    private Solution<Request, Enrollment> iSolution = null;
    private long iTime;
    private boolean iTimeoutReached = false;

    public StudentSctBBTest(Student student) {
        this.iStudent = student;
        for (Request request : this.iStudent.getRequests()) {
            this.addVariable((Variable)request);
        }
        this.addGlobalConstraint(new SectionLimit(new DataProperties()));
        this.addConstraint(new StudentConflict(student));
    }

    public Student getStudent() {
        return this.iStudent;
    }

    public Solution<Request, Enrollment> getSolution() {
        if (this.iSolution == null) {
            this.iSolution = new Solution((Model)this, (Assignment)new DefaultSingleAssignment());
            BranchBoundSelection.Selection selection = new BranchBoundSelection(new DataProperties()).getSelection((Assignment<Request, Enrollment>)this.iSolution.getAssignment(), this.getStudent());
            BranchBoundSelection.BranchBoundNeighbour neighbour = selection.select();
            if (neighbour != null) {
                neighbour.assign(this.iSolution.getAssignment(), 0L);
            }
            this.iTime = selection.getTime();
            this.iTimeoutReached = selection.isTimeoutReached();
        }
        return this.iSolution;
    }

    public List<Message> getMessages() {
        Assignment assignment = this.getSolution().getAssignment();
        ArrayList<Message> ret = new ArrayList<Message>();
        ret.add(new Message(Message.sMsgLevelInfo, null, "<li>Solution found in " + this.iTime + " ms."));
        if (this.iTimeoutReached) {
            ret.add(new Message(Message.sMsgLevelInfo, null, "<li>Time out reached, solution optimality can not be guaranteed."));
        }
        for (Request request : this.getStudent().getRequests()) {
            if (!request.isAlternative() && assignment.getValue((Variable)request) == null) {
                ret.add(new Message(Message.sMsgLevelWarn, request, "<li>Unable to enroll to " + (Object)((Object)request) + ", " + (request instanceof CourseRequest ? (((CourseRequest)request).getCourses().size() == 1 ? "course is" : "courses are") : "time is") + " not available."));
                List<Enrollment> values = request instanceof CourseRequest ? ((CourseRequest)request).getAvaiableEnrollmentsSkipSameTime((Assignment<Request, Enrollment>)assignment) : request.computeEnrollments((Assignment<Request, Enrollment>)assignment);
                for (Enrollment enrollment : values) {
                    Set conf = this.conflictValues(assignment, enrollment);
                    if (conf == null || conf.isEmpty()) continue;
                    Enrollment conflict = (Enrollment)((Object)conf.iterator().next());
                    if (conflict.equals((Object)enrollment)) {
                        ret.add(new Message(Message.sMsgLevelInfo, request, "<ul>Assignment of " + enrollment.getName().replaceAll("\n", "<br>&nbsp;&nbsp;&nbsp;&nbsp;") + "<br> is not available."));
                        continue;
                    }
                    ret.add(new Message(Message.sMsgLevelInfo, request, "<ul>Assignment of " + enrollment.getName().replaceAll("\n", "<br>&nbsp;&nbsp;&nbsp;&nbsp;") + "<br> conflicts with " + conflict.getName().replaceAll("\n", "<br>&nbsp;&nbsp;&nbsp;&nbsp;") + "</ul>"));
                }
            }
            if (!(request instanceof CourseRequest) || assignment.getValue((Variable)request) == null) continue;
            CourseRequest courseRequest = (CourseRequest)request;
            Enrollment enrollment = (Enrollment)assignment.getValue((Variable)request);
            List<Enrollment> selectedEnrollments = courseRequest.getSelectedEnrollments((Assignment<Request, Enrollment>)assignment, false);
            if (selectedEnrollments == null || selectedEnrollments.isEmpty() || selectedEnrollments.contains((Object)enrollment)) continue;
            Course course = courseRequest.getSelectedChoices().iterator().next().getOffering().getCourse(this.getStudent());
            Enrollment selected = selectedEnrollments.get(0);
            Set conf = this.conflictValues(assignment, selected);
            if (conf != null && !conf.isEmpty()) {
                ret.add(new Message(Message.sMsgLevelWarn, request, "<li>Unable to enroll selected enrollment for " + course.getName() + ", seleted " + (courseRequest.getSelectedChoices().size() == 1 ? "class is" : "classes are") + " conflicting with other choices."));
                Enrollment conflict = (Enrollment)((Object)conf.iterator().next());
                if (conflict.equals((Object)selected)) {
                    ret.add(new Message(Message.sMsgLevelInfo, request, "<ul>Assignment of " + selected.getName().replaceAll("\n", "<br>&nbsp;&nbsp;&nbsp;&nbsp;") + "<br> is not available."));
                    continue;
                }
                ret.add(new Message(Message.sMsgLevelInfo, request, "<ul>Assignment of " + selected.getName().replaceAll("\n", "<br>&nbsp;&nbsp;&nbsp;&nbsp;") + "<br> conflicts with " + conflict.getName().replaceAll("\n", "<br>&nbsp;&nbsp;&nbsp;&nbsp;") + "</ul>"));
                continue;
            }
            ret.add(new Message(Message.sMsgLevelWarn, request, "<li>Unable to enroll selected enrollment for " + course.getName() + "."));
        }
        return ret;
    }

    public static class Message {
        public static String[] sMsgLevels = new String[]{"INFO", "WARN", "ERROR"};
        public static int sMsgLevelInfo = 0;
        public static int sMsgLevelWarn = 1;
        public static int sMsgLevelError = 2;
        private int iLevel;
        private Request iRequest;
        private String iMessage;

        public Message(int level, Request request, String message) {
            this.iLevel = level;
            this.iRequest = request;
            this.iMessage = message;
        }

        public int getLevel() {
            return this.iLevel;
        }

        public String getLevelString() {
            return sMsgLevels[this.iLevel];
        }

        public Request getRequest() {
            return this.iRequest;
        }

        public String getMessage() {
            return this.iMessage;
        }

        public String toString() {
            return this.getLevelString() + ":" + this.getMessage();
        }
    }
}

