/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.criteria.additional;

import java.util.Map;
import java.util.Set;
import org.cpsolver.exam.criteria.ExamCriterion;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.model.ExamRoomPlacement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.DataProperties;

public class DistanceToStronglyPreferredRoom
extends ExamCriterion {
    @Override
    public String getWeightName() {
        return "Exams.DistanceToStronglyPreferredRoomWeight";
    }

    @Override
    public String getXmlWeightName() {
        return "distanceToStronglyPreferredRoomWeight";
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return 0.001;
    }

    @Override
    public double getValue(Assignment<Exam, ExamPlacement> assignment, ExamPlacement value, Set<ExamPlacement> conflicts) {
        Average ret = new Average();
        for (ExamRoomPlacement assigned : value.getRoomPlacements()) {
            for (ExamRoomPlacement preferred : ((Exam)value.variable()).getPreferredRoomPlacements()) {
                ret.add(assigned.getDistanceInMeters(preferred));
            }
        }
        return ret.average();
    }

    @Override
    public String toString(Assignment<Exam, ExamPlacement> assignment) {
        return "@D:" + sDoubleFormat.format(this.getValue(assignment) / (double)assignment.nrAssignedVariables());
    }

    @Override
    public double[] getBounds(Assignment<Exam, ExamPlacement> assignment) {
        return new double[]{0.0, 0.0};
    }

    @Override
    public void getInfo(Assignment<Exam, ExamPlacement> assignment, Map<String, String> info) {
        if (this.getValue(assignment) > 0.0) {
            info.put(this.getName(), sDoubleFormat.format(this.getValue(assignment) / (double)assignment.nrAssignedVariables()) + " m");
        }
    }

    private static class Average {
        double iValue = 0.0;
        int iCount = 0;

        private Average() {
        }

        private void add(double value) {
            this.iValue += value;
            ++this.iCount;
        }

        public double average() {
            return this.iCount == 0 ? 0.0 : this.iValue / (double)this.iCount;
        }
    }
}

