/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.weights;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.DefaultSingleAssignment;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ToolBox;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.extension.DistanceConflict;
import org.cpsolver.studentsct.extension.TimeOverlapsCounter;
import org.cpsolver.studentsct.model.Choice;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Instructor;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.weights.PriorityStudentWeights;

public class EqualStudentWeights
extends PriorityStudentWeights {
    public EqualStudentWeights(DataProperties config) {
        super(config);
    }

    @Override
    public double getWeight(Request request) {
        if (request.getStudent().isDummy() && this.iProjectedStudentWeight >= 0.0) {
            double weight = this.iProjectedStudentWeight;
            if (request.isAlternative()) {
                weight *= this.iAlternativeRequestFactor;
            }
            return weight;
        }
        double weight = 1.0 / (double)request.getStudent().nrRequests();
        if (request.isAlternative()) {
            weight *= this.iAlternativeRequestFactor;
        }
        return this.round(weight);
    }

    @Override
    public boolean isBetterThanBestSolution(Solution<Request, Enrollment> currentSolution) {
        if (currentSolution.getBestInfo() == null) {
            return true;
        }
        if (this.iMPP) {
            return super.isBetterThanBestSolution(currentSolution);
        }
        int unassigned = currentSolution.getModel().nrUnassignedVariables(currentSolution.getAssignment());
        if (currentSolution.getModel().getBestUnassignedVariables() != unassigned) {
            return currentSolution.getModel().getBestUnassignedVariables() > unassigned;
        }
        return ((StudentSectioningModel)currentSolution.getModel()).getTotalValue(currentSolution.getAssignment(), this.iPreciseComparison) < currentSolution.getBestValue();
    }

    @Override
    public boolean isFreeTimeAllowOverlaps() {
        return true;
    }

    public static void main(String[] args) {
        HashSet<Section> other;
        Enrollment e;
        HashSet<Section> sections;
        Config cfg;
        HashSet<Section> other2;
        HashSet<Section> sections2;
        Config cfg2;
        Enrollment e2;
        HashSet<DistanceConflict.Conflict> dc;
        Enrollment e3;
        HashSet<Section> sections3;
        Config cfg3;
        int i;
        double[] w;
        CourseRequest cr;
        EqualStudentWeights pw = new EqualStudentWeights(new DataProperties());
        DecimalFormat df = new DecimalFormat("0.0000");
        Student s = new Student(0L);
        new CourseRequest(1L, 0, false, s, ToolBox.toList(new Course(1L, "A", "1", new Offering(0L, "A")), new Course(1L, "A", "2", new Offering(0L, "A")), new Course(1L, "A", "3", new Offering(0L, "A"))), false, null);
        new CourseRequest(2L, 1, false, s, ToolBox.toList(new Course(1L, "B", "1", new Offering(0L, "B")), new Course(1L, "B", "2", new Offering(0L, "B")), new Course(1L, "B", "3", new Offering(0L, "B"))), false, null);
        new CourseRequest(3L, 2, false, s, ToolBox.toList(new Course(1L, "C", "1", new Offering(0L, "C")), new Course(1L, "C", "2", new Offering(0L, "C")), new Course(1L, "C", "3", new Offering(0L, "C"))), false, null);
        new CourseRequest(5L, 4, false, s, ToolBox.toList(new Course(1L, "E", "1", new Offering(0L, "E")), new Course(1L, "E", "2", new Offering(0L, "E")), new Course(1L, "E", "3", new Offering(0L, "E"))), false, null);
        new CourseRequest(6L, 5, true, s, ToolBox.toList(new Course(1L, "F", "1", new Offering(0L, "F")), new Course(1L, "F", "2", new Offering(0L, "F")), new Course(1L, "F", "3", new Offering(0L, "F"))), false, null);
        new CourseRequest(7L, 6, true, s, ToolBox.toList(new Course(1L, "G", "1", new Offering(0L, "G")), new Course(1L, "G", "2", new Offering(0L, "G")), new Course(1L, "G", "3", new Offering(0L, "G"))), false, null);
        DefaultSingleAssignment<Request, Enrollment> assignment = new DefaultSingleAssignment<Request, Enrollment>();
        Placement p = new Placement(null, new TimeLocation(1, 90, 12, 0, 0.0, null, null, new BitSet(), 10), new ArrayList());
        for (Request r : s.getRequests()) {
            cr = (CourseRequest)r;
            w = new double[]{0.0, 0.0, 0.0};
            for (i = 0; i < cr.getCourses().size(); ++i) {
                cfg3 = new Config(0L, -1, "", cr.getCourses().get(i).getOffering());
                sections3 = new HashSet<Section>();
                sections3.add(new Section(0L, 1, "x", new Subpart(0L, "Lec", "Lec", cfg3, null), p, null, new Instructor[0]));
                e3 = new Enrollment(cr, i, cfg3, sections3, assignment);
                w[i] = pw.getWeight(assignment, e3, null, null);
            }
            System.out.println(cr + ": " + df.format(w[0]) + "  " + df.format(w[1]) + "  " + df.format(w[2]));
        }
        System.out.println("With one distance conflict:");
        for (Request r : s.getRequests()) {
            cr = (CourseRequest)r;
            w = new double[]{0.0, 0.0, 0.0};
            for (i = 0; i < cr.getCourses().size(); ++i) {
                cfg3 = new Config(0L, -1, "", cr.getCourses().get(i).getOffering());
                sections3 = new HashSet();
                sections3.add(new Section(0L, 1, "x", new Subpart(0L, "Lec", "Lec", cfg3, null), p, null, new Instructor[0]));
                e3 = new Enrollment(cr, i, cfg3, sections3, assignment);
                dc = new HashSet<DistanceConflict.Conflict>();
                dc.add(new DistanceConflict.Conflict(s, e3, (Section)sections3.iterator().next(), e3, (Section)sections3.iterator().next()));
                w[i] = pw.getWeight(assignment, e3, dc, null);
            }
            System.out.println(cr + ": " + df.format(w[0]) + "  " + df.format(w[1]) + "  " + df.format(w[2]));
        }
        System.out.println("With two distance conflicts:");
        for (Request r : s.getRequests()) {
            cr = (CourseRequest)r;
            w = new double[]{0.0, 0.0, 0.0};
            for (i = 0; i < cr.getCourses().size(); ++i) {
                cfg3 = new Config(0L, -1, "", cr.getCourses().get(i).getOffering());
                sections3 = new HashSet();
                sections3.add(new Section(0L, 1, "x", new Subpart(0L, "Lec", "Lec", cfg3, null), p, null, new Instructor[0]));
                e3 = new Enrollment(cr, i, cfg3, sections3, assignment);
                dc = new HashSet();
                dc.add(new DistanceConflict.Conflict(s, e3, (Section)sections3.iterator().next(), e3, (Section)sections3.iterator().next()));
                dc.add(new DistanceConflict.Conflict(s, e3, (Section)sections3.iterator().next(), e3, new Section(1L, 1, "x", new Subpart(0L, "Lec", "Lec", cfg3, null), p, null, new Instructor[0])));
                w[i] = pw.getWeight(assignment, e3, dc, null);
            }
            System.out.println(cr + ": " + df.format(w[0]) + "  " + df.format(w[1]) + "  " + df.format(w[2]));
        }
        System.out.println("With 25% time overlapping conflict:");
        for (Request r : s.getRequests()) {
            cr = (CourseRequest)r;
            w = new double[]{0.0, 0.0, 0.0};
            for (i = 0; i < cr.getCourses().size(); ++i) {
                cfg3 = new Config(0L, -1, "", cr.getCourses().get(i).getOffering());
                sections3 = new HashSet();
                sections3.add(new Section(0L, 1, "x", new Subpart(0L, "Lec", "Lec", cfg3, null), p, null, new Instructor[0]));
                e3 = new Enrollment(cr, i, cfg3, sections3, assignment);
                HashSet<TimeOverlapsCounter.Conflict> toc = new HashSet<TimeOverlapsCounter.Conflict>();
                toc.add(new TimeOverlapsCounter.Conflict(s, 3, e3, (SctAssignment)sections3.iterator().next(), e3, (SctAssignment)sections3.iterator().next()));
                w[i] = pw.getWeight(assignment, e3, null, toc);
            }
            System.out.println(cr + ": " + df.format(w[0]) + "  " + df.format(w[1]) + "  " + df.format(w[2]));
        }
        System.out.println("Disbalanced sections (by 2 / 10 students):");
        for (Request r : s.getRequests()) {
            cr = (CourseRequest)r;
            w = new double[]{0.0, 0.0, 0.0};
            for (i = 0; i < cr.getCourses().size(); ++i) {
                cfg3 = new Config(0L, -1, "", cr.getCourses().get(i).getOffering());
                sections3 = new HashSet();
                Subpart x = new Subpart(0L, "Lec", "Lec", cfg3, null);
                Section a = new Section(0L, 10, "x", x, p, null, new Instructor[0]);
                new Section(1L, 10, "y", x, p, null, new Instructor[0]);
                sections3.add(a);
                a.assigned(assignment, new Enrollment(s.getRequests().get(0), i, cfg3, sections3, assignment));
                a.assigned(assignment, new Enrollment(s.getRequests().get(0), i, cfg3, sections3, assignment));
                ((Config.ConfigContext)cfg3.getContext(assignment)).assigned((Assignment<Request, Enrollment>)assignment, new Enrollment(s.getRequests().get(0), i, cfg3, sections3, assignment));
                ((Config.ConfigContext)cfg3.getContext(assignment)).assigned((Assignment<Request, Enrollment>)assignment, new Enrollment(s.getRequests().get(0), i, cfg3, sections3, assignment));
                e2 = new Enrollment(cr, i, cfg3, sections3, assignment);
                w[i] = pw.getWeight(assignment, e2, null, null);
            }
            System.out.println(cr + ": " + df.format(w[0]) + "  " + df.format(w[1]) + "  " + df.format(w[2]));
        }
        System.out.println("Same sections:");
        pw.iMPP = true;
        for (Request r : s.getRequests()) {
            cr = (CourseRequest)r;
            w = new double[]{0.0, 0.0, 0.0};
            double dif = 0.0;
            for (int i2 = 0; i2 < cr.getCourses().size(); ++i2) {
                cfg2 = new Config(0L, -1, "", cr.getCourses().get(i2).getOffering());
                sections2 = new HashSet<Section>();
                sections2.add(new Section(0L, 1, "x", new Subpart(0L, "Lec", "Lec", cfg2, null), p, null, new Instructor[0]));
                e2 = new Enrollment(cr, i2, cfg2, sections2, assignment);
                cr.setInitialAssignment(new Enrollment(cr, i2, cfg2, sections2, assignment));
                w[i2] = pw.getWeight(assignment, e2, null, null);
                dif = pw.getDifference(e2);
            }
            System.out.println(cr + ": " + df.format(w[0]) + "  " + df.format(w[1]) + "  " + df.format(w[2]) + " (" + df.format(dif) + ")");
        }
        System.out.println("Same choice sections:");
        pw.iMPP = true;
        for (Request r : s.getRequests()) {
            cr = (CourseRequest)r;
            w = new double[]{0.0, 0.0, 0.0};
            double dif = 0.0;
            for (int i3 = 0; i3 < cr.getCourses().size(); ++i3) {
                cfg2 = new Config(0L, -1, "", cr.getCourses().get(i3).getOffering());
                sections2 = new HashSet();
                sections2.add(new Section(0L, 1, "x", new Subpart(0L, "Lec", "Lec", cfg2, null), p, null, new Instructor[0]));
                e2 = new Enrollment(cr, i3, cfg2, sections2, assignment);
                other2 = new HashSet<Section>();
                other2.add(new Section(1L, 1, "x", new Subpart(0L, "Lec", "Lec", cfg2, null), p, null, new Instructor[0]));
                cr.setInitialAssignment(new Enrollment(cr, i3, cfg2, other2, assignment));
                w[i3] = pw.getWeight(assignment, e2, null, null);
                dif = pw.getDifference(e2);
            }
            System.out.println(cr + ": " + df.format(w[0]) + "  " + df.format(w[1]) + "  " + df.format(w[2]) + " (" + df.format(dif) + ")");
        }
        System.out.println("Same time sections:");
        for (Request r : s.getRequests()) {
            cr = (CourseRequest)r;
            double dif = 0.0;
            double[] w2 = new double[]{0.0, 0.0, 0.0};
            for (int i4 = 0; i4 < cr.getCourses().size(); ++i4) {
                cfg2 = new Config(0L, -1, "", cr.getCourses().get(i4).getOffering());
                sections2 = new HashSet();
                sections2.add(new Section(0L, 1, "x", new Subpart(0L, "Lec", "Lec", cfg2, null), p, null, new Instructor[0]));
                e2 = new Enrollment(cr, i4, cfg2, sections2, assignment);
                other2 = new HashSet();
                other2.add(new Section(1L, 1, "x", new Subpart(0L, "Lec", "Lec", cfg2, null), p, null, new Instructor(1L, null, "Josef Novak", null)));
                cr.setInitialAssignment(new Enrollment(cr, i4, cfg2, other2, assignment));
                w2[i4] = pw.getWeight(assignment, e2, null, null);
                dif = pw.getDifference(e2);
            }
            System.out.println(cr + ": " + df.format(w2[0]) + "  " + df.format(w2[1]) + "  " + df.format(w2[2]) + " (" + df.format(dif) + ")");
        }
        System.out.println("Same configuration sections:");
        for (Request r : s.getRequests()) {
            cr = (CourseRequest)r;
            double[] w3 = new double[]{0.0, 0.0, 0.0};
            double dif = 0.0;
            for (int i5 = 0; i5 < cr.getCourses().size(); ++i5) {
                cfg2 = new Config(0L, -1, "", cr.getCourses().get(i5).getOffering());
                sections2 = new HashSet();
                sections2.add(new Section(0L, 1, "x", new Subpart(0L, "Lec", "Lec", cfg2, null), p, null, new Instructor[0]));
                e2 = new Enrollment(cr, i5, cfg2, sections2, assignment);
                cr.getSelectedChoices().add(new Choice(cfg2));
                cr.setInitialAssignment(null);
                w3[i5] = pw.getWeight(assignment, e2, null, null);
                dif = pw.getDifference(e2);
            }
            System.out.println(cr + ": " + df.format(w3[0]) + "  " + df.format(w3[1]) + "  " + df.format(w3[2]) + " (" + df.format(dif) + ")");
        }
        System.out.println("Different time sections:");
        Placement q = new Placement(null, new TimeLocation(1, 102, 12, 0, 0.0, null, null, new BitSet(), 10), new ArrayList());
        for (Request r : s.getRequests()) {
            CourseRequest cr2 = (CourseRequest)r;
            double[] w4 = new double[]{0.0, 0.0, 0.0};
            double dif = 0.0;
            for (int i6 = 0; i6 < cr2.getCourses().size(); ++i6) {
                cfg = new Config(0L, -1, "", cr2.getCourses().get(i6).getOffering());
                sections = new HashSet<Section>();
                sections.add(new Section(0L, 1, "x", new Subpart(0L, "Lec", "Lec", cfg, null), p, null, new Instructor[0]));
                e = new Enrollment(cr2, i6, cfg, sections, assignment);
                other = new HashSet<Section>();
                other.add(new Section(1L, 1, "x", new Subpart(0L, "Lec", "Lec", cfg, null), q, null, new Instructor[0]));
                cr2.setInitialAssignment(new Enrollment(cr2, i6, cfg, other, assignment));
                w4[i6] = pw.getWeight(assignment, e, null, null);
                dif = pw.getDifference(e);
            }
            System.out.println(cr2 + ": " + df.format(w4[0]) + "  " + df.format(w4[1]) + "  " + df.format(w4[2]) + " (" + df.format(dif) + ")");
        }
        System.out.println("Two sections, one same choice, one same time:");
        for (Request r : s.getRequests()) {
            CourseRequest cr3 = (CourseRequest)r;
            double[] w5 = new double[]{0.0, 0.0, 0.0};
            double dif = 0.0;
            for (int i7 = 0; i7 < cr3.getCourses().size(); ++i7) {
                cfg = new Config(0L, -1, "", cr3.getCourses().get(i7).getOffering());
                sections = new HashSet();
                sections.add(new Section(0L, 1, "x", new Subpart(0L, "Lec", "Lec", cfg, null), p, null, new Instructor[0]));
                sections.add(new Section(1L, 1, "y", new Subpart(1L, "Rec", "Rec", cfg, null), p, null, new Instructor[0]));
                e = new Enrollment(cr3, i7, cfg, sections, assignment);
                other = new HashSet();
                other.add(new Section(2L, 1, "x", new Subpart(0L, "Lec", "Lec", cfg, null), p, null, new Instructor[0]));
                other.add(new Section(3L, 1, "y", new Subpart(1L, "Rec", "Rec", cfg, null), p, null, new Instructor(1L, null, "Josef Novak", null)));
                cr3.setInitialAssignment(new Enrollment(cr3, i7, cfg, other, assignment));
                w5[i7] = pw.getWeight(assignment, e, null, null);
                dif = pw.getDifference(e);
            }
            System.out.println(cr3 + ": " + df.format(w5[0]) + "  " + df.format(w5[1]) + "  " + df.format(w5[2]) + " (" + df.format(dif) + ")");
        }
    }
}

