/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.studentsct.constraint.LinkedSections;
import org.cpsolver.studentsct.model.AreaClassificationMajor;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Instructor;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.StudentGroup;
import org.cpsolver.studentsct.model.Unavailability;

public class Student
implements Comparable<Student> {
    private long iId;
    private String iExternalId = null;
    private String iName = null;
    private StudentPriority iPriority = StudentPriority.Normal;
    private List<Request> iRequests = new ArrayList<Request>();
    private List<AreaClassificationMajor> iMajors = new ArrayList<AreaClassificationMajor>();
    private List<AreaClassificationMajor> iMinors = new ArrayList<AreaClassificationMajor>();
    private List<LinkedSections> iLinkedSections = new ArrayList<LinkedSections>();
    private Set<String> iAccommodations = new HashSet<String>();
    private List<StudentGroup> iGroups = new ArrayList<StudentGroup>();
    private String iStatus = null;
    private Long iEmailTimeStamp = null;
    private List<Unavailability> iUnavailabilities = new ArrayList<Unavailability>();
    private boolean iNeedShortDistances = false;
    private boolean iAllowDisabled = false;
    private Float iMinCredit = null;
    private Float iMaxCredit = null;
    private List<Instructor> iAdvisors = new ArrayList<Instructor>();

    public Student(long id) {
        this.iId = id;
    }

    public Student(long id, boolean dummy) {
        this.iId = id;
        this.iPriority = dummy ? StudentPriority.Dummy : StudentPriority.Normal;
    }

    public long getId() {
        return this.iId;
    }

    public void setId(long id) {
        this.iId = id;
    }

    public List<Request> getRequests() {
        return this.iRequests;
    }

    public int nrRequests() {
        int ret = 0;
        for (Request r : this.getRequests()) {
            if (r.isAlternative()) continue;
            ++ret;
        }
        return ret;
    }

    public int nrAlternativeRequests() {
        int ret = 0;
        for (Request r : this.getRequests()) {
            if (!r.isAlternative()) continue;
            ++ret;
        }
        return ret;
    }

    public boolean canAssign(Assignment<Request, Enrollment> assignment, Request request) {
        if (request.isAssigned(assignment)) {
            return true;
        }
        int alt = 0;
        float credit = 0.0f;
        boolean found = false;
        for (Request r : this.getRequests()) {
            boolean waitlist;
            if (r.equals((Object)request)) {
                found = true;
            }
            boolean assigned = r.isAssigned(assignment) || r.equals((Object)request);
            boolean course = r instanceof CourseRequest;
            boolean bl = waitlist = course && ((CourseRequest)r).isWaitlist();
            if (r.isAlternative()) {
                if (assigned || !found && waitlist) {
                    --alt;
                }
            } else if (course && !waitlist && !assigned) {
                ++alt;
            }
            if (r.equals((Object)request)) {
                credit += r.getMinCredit();
                continue;
            }
            Enrollment e = (Enrollment)r.getAssignment(assignment);
            if (e == null) continue;
            credit += e.getCredit();
        }
        return alt >= 0 && credit <= this.getMaxCredit();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isComplete(Assignment<Request, Enrollment> assignment) {
        int nrRequests = 0;
        int nrAssignedRequests = 0;
        float credit = 0.0f;
        Float minCredit = null;
        for (Request r : this.getRequests()) {
            Enrollment e;
            if (!(r instanceof CourseRequest)) continue;
            if (!r.isAlternative()) {
                ++nrRequests;
            }
            if (r.isAssigned(assignment)) {
                ++nrAssignedRequests;
            }
            if ((e = (Enrollment)r.getAssignment(assignment)) != null) {
                credit += e.getCredit();
                continue;
            }
            if (!(r instanceof CourseRequest)) continue;
            minCredit = Float.valueOf(minCredit == null ? r.getMinCredit() : Math.min(minCredit.floatValue(), r.getMinCredit()));
        }
        if (nrAssignedRequests == nrRequests) return true;
        float f = minCredit == null ? 0.0f : minCredit.floatValue();
        if (!(credit + f > this.getMaxCredit())) return false;
        return true;
    }

    public int nrAssignedRequests(Assignment<Request, Enrollment> assignment) {
        int nrAssignedRequests = 0;
        for (Request r : this.getRequests()) {
            if (!(r instanceof CourseRequest) || !r.isAssigned(assignment)) continue;
            ++nrAssignedRequests;
        }
        return nrAssignedRequests;
    }

    public String toString() {
        return (this.isDummy() ? "D" : "") + "S[" + this.getId() + "]";
    }

    public boolean isDummy() {
        return this.iPriority == StudentPriority.Dummy;
    }

    public void setDummy(boolean dummy) {
        if (dummy) {
            this.iPriority = StudentPriority.Dummy;
        } else if (this.iPriority == StudentPriority.Dummy) {
            this.iPriority = StudentPriority.Normal;
        }
    }

    public StudentPriority getPriority() {
        return this.iPriority;
    }

    public void setPriority(StudentPriority priority) {
        this.iPriority = priority;
    }

    @Deprecated
    public void setPriority(boolean priority) {
        if (priority) {
            this.iPriority = StudentPriority.Priority;
        } else if (StudentPriority.Normal.isHigher(this)) {
            this.iPriority = StudentPriority.Normal;
        }
    }

    @Deprecated
    public boolean isPriority() {
        return StudentPriority.Normal.isHigher(this);
    }

    public List<StudentGroup> getGroups() {
        return this.iGroups;
    }

    public Set<String> getAccommodations() {
        return this.iAccommodations;
    }

    public List<AreaClassificationMajor> getAreaClassificationMajors() {
        return this.iMajors;
    }

    public List<AreaClassificationMajor> getAreaClassificationMinors() {
        return this.iMinors;
    }

    public List<Instructor> getAdvisors() {
        return this.iAdvisors;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Student)) {
            return false;
        }
        return this.getId() == ((Student)object).getId() && this.isDummy() == ((Student)object).isDummy();
    }

    public int hashCode() {
        return (int)(this.iId ^ this.iId >>> 32);
    }

    public int countFreeTimeOverlaps(Enrollment enrollment) {
        if (!enrollment.isCourseRequest()) {
            return 0;
        }
        int ret = 0;
        for (Section section : enrollment.getSections()) {
            TimeLocation time = section.getTime();
            if (time == null) continue;
            ret += this.countFreeTimeOverlaps(time);
        }
        return ret;
    }

    public int countFreeTimeOverlaps(TimeLocation time) {
        int ret = 0;
        for (Request r : this.iRequests) {
            TimeLocation freeTime;
            if (!(r instanceof FreeTimeRequest) || !time.hasIntersection(freeTime = ((FreeTimeRequest)r).getTime())) continue;
            ret += freeTime.nrSharedHours(time) * freeTime.nrSharedDays(time);
        }
        return ret;
    }

    public String getExternalId() {
        return this.iExternalId;
    }

    public void setExternalId(String externalId) {
        this.iExternalId = externalId;
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    public List<LinkedSections> getLinkedSections() {
        return this.iLinkedSections;
    }

    public String getStatus() {
        return this.iStatus;
    }

    public void setStatus(String status) {
        this.iStatus = status;
    }

    public Long getEmailTimeStamp() {
        return this.iEmailTimeStamp;
    }

    public void setEmailTimeStamp(Long emailTimeStamp) {
        this.iEmailTimeStamp = emailTimeStamp;
    }

    @Override
    public int compareTo(Student s) {
        if (this.getPriority() != s.getPriority()) {
            return this.getPriority().ordinal() < s.getPriority().ordinal() ? -1 : 1;
        }
        return new Long(this.getId()).compareTo(s.getId());
    }

    public List<Unavailability> getUnavailabilities() {
        return this.iUnavailabilities;
    }

    public boolean isAvailable(Section section) {
        if (section.isAllowOverlap() || section.getTime() == null) {
            return true;
        }
        for (Unavailability unavailability : this.getUnavailabilities()) {
            if (!unavailability.isOverlapping(section)) continue;
            return false;
        }
        return true;
    }

    public boolean isAvailable(Enrollment enrollment) {
        if (enrollment != null && enrollment.isCourseRequest() && !enrollment.isAllowOverlap()) {
            for (Section section : enrollment.getSections()) {
                if (this.isAvailable(section)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isNeedShortDistances() {
        return this.iNeedShortDistances;
    }

    public void setNeedShortDistances(boolean needShortDistances) {
        this.iNeedShortDistances = needShortDistances;
    }

    public boolean isAllowDisabled() {
        return this.iAllowDisabled;
    }

    public void setAllowDisabled(boolean allowDisabled) {
        this.iAllowDisabled = allowDisabled;
    }

    public boolean hasMinCredit() {
        return this.iMinCredit != null;
    }

    public float getMinCredit() {
        return this.iMinCredit == null ? 0.0f : this.iMinCredit.floatValue();
    }

    @Deprecated
    public boolean hasCritical() {
        for (Request r : this.iRequests) {
            if (r.isAlternative() || !r.isCritical()) continue;
            return true;
        }
        return false;
    }

    public boolean hasCritical(Request.RequestPriority rp) {
        for (Request r : this.iRequests) {
            if (r.isAlternative() || !rp.isCritical(r)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean hasUnassignedCritical(Assignment<Request, Enrollment> assignment) {
        for (Request r : this.iRequests) {
            if (r.isAlternative() || !r.isCritical() || assignment.getValue((Variable)r) != null) continue;
            return true;
        }
        return false;
    }

    public boolean hasUnassignedCritical(Assignment<Request, Enrollment> assignment, Request.RequestPriority rp) {
        for (Request r : this.iRequests) {
            if (r.isAlternative() || !rp.isCritical(r) || assignment.getValue((Variable)r) != null) continue;
            return true;
        }
        return false;
    }

    public void setMinCredit(Float maxCredit) {
        this.iMinCredit = maxCredit;
    }

    public boolean hasMaxCredit() {
        return this.iMaxCredit != null;
    }

    public float getMaxCredit() {
        return this.iMaxCredit == null ? Float.MAX_VALUE : this.iMaxCredit.floatValue();
    }

    public void setMaxCredit(Float maxCredit) {
        this.iMaxCredit = maxCredit;
    }

    public float getAssignedCredit(Assignment<Request, Enrollment> assignment) {
        float credit = 0.0f;
        for (Request r : this.getRequests()) {
            Enrollment e = (Enrollment)r.getAssignment(assignment);
            if (e == null) continue;
            credit += e.getCredit();
        }
        return credit;
    }

    public boolean hasAccommodation(String code) {
        return code != null && !code.isEmpty() && this.iAccommodations.contains(code);
    }

    public static enum StudentPriority {
        Priority("P", 1.0),
        Senior("4", 0.7),
        Junior("3", 0.49),
        Sophomore("2", 0.33),
        Freshmen("1", 0.24),
        Normal("N", null),
        Dummy("D", null);

        String iCode;
        Double iBoost;

        private StudentPriority(String code, Double boost) {
            this.iCode = code;
            this.iBoost = boost;
        }

        public String code() {
            return this.iCode;
        }

        public Double getBoost() {
            return this.iBoost;
        }

        public boolean isSameOrHigher(Student s) {
            return s.getPriority().ordinal() <= this.ordinal();
        }

        public boolean isHigher(Student s) {
            return this.ordinal() < s.getPriority().ordinal();
        }

        public boolean isSame(Student s) {
            return this.ordinal() == s.getPriority().ordinal();
        }

        public static StudentPriority getPriority(String value) {
            if ("true".equalsIgnoreCase(value)) {
                return Priority;
            }
            if ("false".equalsIgnoreCase(value)) {
                return Normal;
            }
            for (StudentPriority sp : StudentPriority.values()) {
                if (!sp.name().equalsIgnoreCase(value)) continue;
                return sp;
            }
            return Normal;
        }
    }
}

