/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.heuristics.selection;

import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.ifs.util.ToolBox;
import org.cpsolver.studentsct.heuristics.selection.ProblemStudentsProvider;
import org.cpsolver.studentsct.heuristics.selection.RandomUnassignmentSelection;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Student;

public class RndUnProblStudSelection
extends RandomUnassignmentSelection {
    private ProblemStudentsProvider iProblemStudentsProvider = null;
    private Set<Student> iProblemStudents = null;

    public RndUnProblStudSelection(DataProperties properties, ProblemStudentsProvider psp) {
        super(properties);
        this.iProblemStudentsProvider = psp;
        this.iRandom = properties.getPropertyDouble("Neighbour.RandomUnassignmentOfProblemStudentProb", 0.9);
    }

    @Override
    public void init(Solver<Request, Enrollment> solver) {
        this.iProblemStudents = this.iProblemStudentsProvider.getProblemStudents();
        Progress.getInstance((Object)solver.currentSolution().getModel()).setPhase("Random unassignment of problematic students...", 1L);
    }

    @Override
    public synchronized Neighbour<Request, Enrollment> selectNeighbour(Solution<Request, Enrollment> solution) {
        if (Math.random() < this.iRandom) {
            while (!this.iProblemStudents.isEmpty()) {
                Student student = (Student)ToolBox.random(this.iProblemStudents);
                this.iProblemStudents.remove(student);
                if (student.hasMinCredit() && student.getAssignedCredit((Assignment<Request, Enrollment>)solution.getAssignment()) < student.getMinCredit()) continue;
                return new RandomUnassignmentSelection.UnassignStudentNeighbour(student, (Assignment<Request, Enrollment>)solution.getAssignment(), Request.RequestPriority.Important);
            }
        }
        Progress.getInstance((Object)solution.getModel()).incProgress();
        return null;
    }
}

