/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.model;

import java.util.HashMap;
import java.util.Map;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.LazyNeighbour;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;

public class LazySwap<V extends Variable<V, T>, T extends Value<V, T>>
extends LazyNeighbour<V, T> {
    private T iV1;
    private T iV2;
    private T iOldV1 = null;
    private T iOldV2 = null;

    public LazySwap(T v1, T v2) {
        this.iV1 = v1;
        this.iV2 = v2;
    }

    @Override
    protected void doAssign(Assignment<V, T> assignment, long iteration) {
        this.iOldV1 = assignment.getValue(((Value)this.iV1).variable());
        this.iOldV2 = assignment.getValue(((Value)this.iV2).variable());
        if (this.iOldV1 != null) {
            assignment.unassign(iteration, ((Value)this.iV1).variable());
        }
        if (this.iOldV2 != null) {
            assignment.unassign(iteration, ((Value)this.iV2).variable());
        }
        assignment.assign(iteration, this.iV1);
        assignment.assign(iteration, this.iV2);
    }

    @Override
    protected void undoAssign(Assignment<V, T> assignment, long iteration) {
        assignment.unassign(iteration, ((Value)this.iV1).variable());
        assignment.unassign(iteration, ((Value)this.iV2).variable());
        if (this.iOldV1 != null) {
            assignment.assign(iteration, this.iOldV1);
        }
        if (this.iOldV2 != null) {
            assignment.assign(iteration, this.iOldV2);
        }
    }

    @Override
    public Model<V, T> getModel() {
        return ((Variable)((Value)this.iV1).variable()).getModel();
    }

    public String toString() {
        return "Lazy " + this.iOldV1 + " -> " + this.iV1 + ", " + this.iOldV2 + " -> " + this.iV2;
    }

    @Override
    public Map<V, T> assignments() {
        HashMap ret = new HashMap();
        ret.put(((Value)this.iV1).variable(), this.iV1);
        ret.put(((Value)this.iV2).variable(), this.iV2);
        return ret;
    }
}

