/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.sectioning;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.cpsolver.coursett.constraint.JenrlConstraint;
import org.cpsolver.coursett.criteria.StudentConflict;
import org.cpsolver.coursett.model.Configuration;
import org.cpsolver.coursett.model.DefaultStudentSectioning;
import org.cpsolver.coursett.model.InitialSectioning;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.Student;
import org.cpsolver.coursett.model.StudentGroup;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.coursett.sectioning.SctSectioning;
import org.cpsolver.coursett.sectioning.StudentMove;
import org.cpsolver.coursett.sectioning.StudentSwapGenerator;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.criteria.Criterion;
import org.cpsolver.ifs.model.InfoProvider;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.termination.TerminationCondition;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.JProf;

public class StudentSwapSectioning
extends DefaultStudentSectioning
implements InfoProvider<Lecture, Placement> {
    List<StudentConflict> iStudentConflictCriteria = null;
    private static double sEps = 1.0E-4;
    private double iGroupWeight = 0.1;
    private boolean iUseCriteria = true;
    private int iMaxIdleResection = 1000;

    public StudentSwapSectioning(TimetableModel model) {
        super(model);
        this.iUseCriteria = model.getProperties().getPropertyBoolean("StudentSwaps.UseCriteria", true);
        this.iGroupWeight = model.getProperties().getPropertyDouble("StudentSwaps.GroupWeight", 10.0);
        this.iMaxIdleResection = model.getProperties().getPropertyInt("StudentSwaps.MaxIdleResection", 1000);
    }

    protected List<StudentConflict> getStudentConflictCriteria() {
        if (!this.iUseCriteria) {
            return null;
        }
        if (this.iStudentConflictCriteria == null && this.iModel != null) {
            this.iStudentConflictCriteria = new ArrayList<StudentConflict>();
            for (Criterion criterion : this.iModel.getCriteria()) {
                if (!(criterion instanceof StudentConflict)) continue;
                this.iStudentConflictCriteria.add((StudentConflict)criterion);
            }
        }
        return this.iStudentConflictCriteria;
    }

    @Override
    public boolean hasFinalSectioning() {
        return true;
    }

    protected double objective(Neighbour<Lecture, Placement> n, Assignment<Lecture, Placement> assignment) {
        if (n instanceof StudentMove) {
            return ((StudentMove)n).value(this.getStudentConflictCriteria(), assignment);
        }
        return n.value(assignment);
    }

    protected double group(Neighbour<Lecture, Placement> n, Assignment<Lecture, Placement> assignment) {
        if (n instanceof StudentMove) {
            return ((StudentMove)n).group(this.getStudentConflictCriteria(), assignment);
        }
        return 0.0;
    }

    protected double value(Neighbour<Lecture, Placement> n, Assignment<Lecture, Placement> assignment) {
        if (n instanceof StudentMove) {
            return ((StudentMove)n).value(this.getStudentConflictCriteria(), assignment) - this.iGroupWeight * ((StudentMove)n).group(this.getStudentConflictCriteria(), assignment);
        }
        return n.value(assignment);
    }

    protected double objective(Solution<Lecture, Placement> solution) {
        List<StudentConflict> criteria = this.getStudentConflictCriteria();
        if (criteria == null) {
            double value = 0.0;
            for (JenrlConstraint constraint : ((TimetableModel)solution.getModel()).getJenrlConstraints()) {
                if (!constraint.isInConflict((Assignment<Lecture, Placement>)solution.getAssignment())) continue;
                value += constraint.jenrl();
            }
            return value;
        }
        double value = 0.0;
        for (StudentConflict criterion : criteria) {
            value += criterion.getWeightedValue(solution.getAssignment());
        }
        return value;
    }

    public static double group(TimetableModel model) {
        double ret = 0.0;
        for (StudentGroup group : model.getStudentGroups()) {
            HashMap<Long, Match> match = new HashMap<Long, Match>();
            HashSet<Long> offeringIds = new HashSet<Long>();
            for (Student student : group.getStudents()) {
                for (Lecture lecture : student.getLectures()) {
                    if (lecture.getConfiguration() == null) continue;
                    offeringIds.add(lecture.getConfiguration().getOfferingId());
                    Match m = (Match)match.get(lecture.getSchedulingSubpartId());
                    if (m == null) {
                        m = new Match(group, lecture.getConfiguration());
                        match.put(lecture.getSchedulingSubpartId(), m);
                    }
                    m.inc(lecture);
                }
            }
            double value = 0.0;
            for (Match m : match.values()) {
                value += m.value();
            }
            ret += value / (double)offeringIds.size();
        }
        return ret;
    }

    public static double gp(TimetableModel model, Collection<Lecture> variables) {
        if (model.getStudentGroups().isEmpty()) {
            return 0.0;
        }
        double ret = 0.0;
        int count = 0;
        for (StudentGroup group : model.getStudentGroups()) {
            HashMap<Long, Match> match = new HashMap<Long, Match>();
            HashSet<Long> offeringIds = new HashSet<Long>();
            for (Student student : group.getStudents()) {
                for (Lecture lecture : student.getLectures()) {
                    if (lecture.getConfiguration() == null || variables != null && !variables.contains((Object)lecture)) continue;
                    offeringIds.add(lecture.getConfiguration().getOfferingId());
                    Match m = (Match)match.get(lecture.getSchedulingSubpartId());
                    if (m == null) {
                        m = new Match(group, lecture.getConfiguration());
                        match.put(lecture.getSchedulingSubpartId(), m);
                    }
                    m.inc(lecture);
                }
            }
            if (match.isEmpty()) continue;
            double value = 0.0;
            for (Match m : match.values()) {
                value += m.value();
            }
            ret += value / (double)offeringIds.size();
            ++count;
        }
        return 100.0 * ret / (double)count;
    }

    public static double gp(TimetableModel model) {
        if (model.getStudentGroups().isEmpty()) {
            return 0.0;
        }
        return 100.0 * StudentSwapSectioning.group(model) / (double)model.getStudentGroups().size();
    }

    public static double gp(Solution<Lecture, Placement> solution) {
        return StudentSwapSectioning.gp((TimetableModel)solution.getModel());
    }

    protected double value(Solution<Lecture, Placement> solution) {
        return this.objective(solution) + this.iGroupWeight * ((double)this.iModel.getStudentGroups().size() - StudentSwapSectioning.group(this.iModel));
    }

    @Override
    public void switchStudents(Solution<Lecture, Placement> solution, TerminationCondition<Lecture, Placement> termination) {
        long it = 0L;
        long lastImp = 0L;
        double t0 = JProf.currentTimeMillis();
        DataProperties cfg = ((TimetableModel)solution.getModel()).getProperties();
        long maxIdle = cfg.getPropertyInt("StudentSwaps.MaxIdle", 100000);
        this.getProgress().setStatus("Student Sectioning...");
        this.getProgress().info("Student Conflicts: " + sDF2.format(this.objective(solution)) + " (group: " + sDF2.format(StudentSwapSectioning.gp(solution)) + "%)");
        this.getProgress().setPhase("Swapping students [HC]...", 1000L);
        StudentSwapGenerator g = new StudentSwapGenerator();
        while (it - lastImp < maxIdle && (termination == null || termination.canContinue(solution))) {
            Neighbour<Lecture, Placement> n;
            if (++it % 1000L == 0L) {
                long prg = Math.round(1000.0 * (double)(it - lastImp) / (double)maxIdle);
                if (this.getProgress().getProgress() < prg) {
                    this.getProgress().setProgress(prg);
                }
                if (it % 10000L == 0L) {
                    this.getProgress().info("Iter=" + it / 1000L + "k, Idle=" + sDF2.format((double)(it - lastImp) / 1000.0) + "k, Speed=" + sDF2.format(1000.0 * (double)it / ((double)JProf.currentTimeMillis() - t0)) + " it/s, Value=" + sDF2.format(this.value(solution)) + ", Objective=" + sDF2.format(this.objective(solution)) + ", Group=" + sDF2.format(StudentSwapSectioning.gp(solution)) + "%");
                }
            }
            if ((n = g.selectNeighbour(solution)) == null) continue;
            double v = this.value(n, (Assignment<Lecture, Placement>)solution.getAssignment());
            if (v < -sEps) {
                lastImp = it;
            }
            if (!(v <= 0.0)) continue;
            n.assign(solution.getAssignment(), it);
        }
        this.getProgress().info("Student Conflicts: " + sDF2.format(this.objective(solution)) + " (group: " + sDF2.format(StudentSwapSectioning.gp(solution)) + "%)");
        double f = cfg.getPropertyDouble("StudentSwaps.Deluge.Factor", 0.9999999);
        double ub = cfg.getPropertyDouble("StudentSwaps.Deluge.UpperBound", 1.1);
        double lb = cfg.getPropertyDouble("StudentSwaps.Deluge.LowerBound", 0.9);
        double total = this.value(solution);
        double bound = ub * total;
        double best = total;
        it = 0L;
        lastImp = 0L;
        t0 = JProf.currentTimeMillis();
        this.getProgress().setPhase("Swapping students [GD]...", 1000L);
        while (bound > lb * total && total > 0.0 && (termination == null || termination.canContinue(solution))) {
            Neighbour<Lecture, Placement> n = g.selectNeighbour(solution);
            if (n != null) {
                double value = this.value(n, (Assignment<Lecture, Placement>)solution.getAssignment());
                if (value < 0.0) {
                    lastImp = it;
                }
                if (value <= 0.0 || total + value < bound) {
                    n.assign(solution.getAssignment(), it);
                    if (total + value < best) {
                        best = total + value;
                    }
                    total += value;
                }
            }
            bound *= f;
            if (++it % 1000L != 0L) continue;
            long prg = 1000L - Math.round(1000.0 * (bound - lb * best) / (ub * best - lb * best));
            if (this.getProgress().getProgress() < prg) {
                this.getProgress().setProgress(prg);
            }
            if (it % 10000L != 0L) continue;
            this.getProgress().info("Iter=" + it / 1000L + "k, Idle=" + sDF2.format((double)(it - lastImp) / 1000.0) + "k, Speed=" + sDF2.format(1000.0 * (double)it / ((double)JProf.currentTimeMillis() - t0)) + " it/s, Value=" + sDF2.format(this.value(solution)) + ", Objective=" + sDF2.format(this.objective(solution)) + ", Group=" + sDF2.format(StudentSwapSectioning.gp(solution)) + "%");
            this.getProgress().info("Bound is " + sDF2.format(bound) + ", best value is " + sDF2.format(best) + " (" + sDF2.format(100.0 * bound / best) + "%), current value is " + sDF2.format(total) + " (" + sDF2.format(100.0 * bound / total) + "%)");
        }
        this.getProgress().info("Student Conflicts: " + sDF2.format(this.objective(solution)) + " (group: " + sDF2.format(StudentSwapSectioning.gp(solution)) + "%)");
    }

    @Override
    public void resection(Assignment<Lecture, Placement> assignment, Lecture lecture, boolean recursive, boolean configAsWell) {
        if (lecture.students().isEmpty()) {
            return;
        }
        StudentSwapGenerator g = new StudentSwapGenerator();
        long nrIdle = 0L;
        long it = 0L;
        while (nrIdle < (long)this.iMaxIdleResection) {
            ++nrIdle;
            ++it;
            Neighbour<Lecture, Placement> n = g.selectNeighbour(assignment, lecture);
            if (n == null) continue;
            double v = this.value(n, assignment);
            if (v < -sEps) {
                nrIdle = 0L;
            }
            if (!(v <= 0.0)) continue;
            n.assign(assignment, it);
        }
    }

    protected boolean hasStudentGroups(Collection<Student> students) {
        for (Student student : students) {
            if (student.getGroups().isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected InitialSectioning.Group[] studentsToConfigurations(Long offeringId, Collection<Student> students, Collection<Configuration> configurations) {
        if (this.hasStudentGroups(students)) {
            SctSectioning.GroupBasedInitialSectioning sect = new SctSectioning.GroupBasedInitialSectioning(this.getProgress(), offeringId, configurations, students);
            return sect.getGroups();
        }
        return super.studentsToConfigurations(offeringId, students, configurations);
    }

    @Override
    protected InitialSectioning.Group[] studentsToLectures(Long offeringId, Collection<Student> students, Collection<Lecture> lectures) {
        if (this.hasStudentGroups(students)) {
            TreeSet<Lecture> sortedLectures = new TreeSet<Lecture>(new Comparator<Lecture>(){

                @Override
                public int compare(Lecture l1, Lecture l2) {
                    return l1.getClassId().compareTo(l2.getClassId());
                }
            });
            sortedLectures.addAll(lectures);
            SctSectioning.GroupBasedInitialSectioning sect = new SctSectioning.GroupBasedInitialSectioning(this.getProgress(), offeringId, sortedLectures, students);
            return sect.getGroups();
        }
        return super.studentsToLectures(offeringId, students, lectures);
    }

    private static class Match {
        private int iTotal = 0;
        private double iFraction = 1.0;
        private Map<Long, Integer> iMatch = new HashMap<Long, Integer>();

        Match(StudentGroup group, Configuration config) {
            this.iTotal = group.countStudents(config.getOfferingId());
            this.iFraction = 1.0 / (double)config.countSubparts();
        }

        void inc(Lecture lecture) {
            Integer val = this.iMatch.get(lecture.getClassId());
            this.iMatch.put(lecture.getClassId(), 1 + (val == null ? 0 : val));
        }

        double value() {
            if (this.iTotal <= 1) {
                return this.iFraction;
            }
            double value = 0.0;
            for (Integer m : this.iMatch.values()) {
                if (m <= 1) continue;
                value += (double)m.intValue() * ((double)m.intValue() - 1.0) / ((double)this.iTotal * ((double)this.iTotal - 1.0));
            }
            return this.iFraction * value;
        }

        public String toString() {
            return this.iTotal + "/" + this.iMatch;
        }
    }
}

