/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.criteria.additional;

import java.util.Collection;
import java.util.Map;
import org.cpsolver.coursett.constraint.JenrlConstraint;
import org.cpsolver.coursett.criteria.StudentConflict;
import org.cpsolver.coursett.criteria.additional.ImportantStudentHardConflict;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.Student;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.criteria.Criterion;
import org.cpsolver.ifs.util.DataProperties;

public class ImportantStudentConflict
extends StudentConflict {
    @Override
    protected double jointEnrollment(JenrlConstraint jenrl) {
        return jenrl.priority();
    }

    @Override
    public boolean isApplicable(Lecture l1, Lecture l2) {
        return l1 != null && l2 != null && !ImportantStudentConflict.ignore(l1, l2) && ImportantStudentConflict.applicable(l1, l2) && this.important(l1, l2);
    }

    @Override
    public boolean isApplicable(Student student, Lecture l1, Lecture l2) {
        return l1 != null && l2 != null && !ImportantStudentConflict.ignore(l1, l2) && ImportantStudentConflict.applicable(l1, l2) && student.getConflictingPriorty(l1, l2) != null;
    }

    public boolean important(Lecture l1, Lecture l2) {
        JenrlConstraint jenrl = l1 == null || l2 == null ? null : l1.jenrlConstraint(l2);
        return jenrl != null && jenrl.priority() > 0.0;
    }

    @Override
    public void incJenrl(Assignment<Lecture, Placement> assignment, JenrlConstraint jenrl, double studentWeight, Double conflictPriority, Student student) {
        if (this.isApplicable(student, (Lecture)jenrl.first(), (Lecture)jenrl.second()) && this.inConflict((Placement)assignment.getValue(jenrl.first()), (Placement)assignment.getValue(jenrl.second())) && conflictPriority != null) {
            this.inc(assignment, studentWeight * conflictPriority);
        }
    }

    public double getWeightDefault(DataProperties config) {
        return config.getPropertyDouble("Comparator.ImportantStudentConflictWeight", 3.0 * config.getPropertyDouble("Comparator.StudentConflictWeight", 1.0));
    }

    @Override
    public String getPlacementSelectionWeightName() {
        return "Placement.NrImportantStudConfsWeight";
    }

    public void getInfo(Assignment<Lecture, Placement> assignment, Map<String, String> info) {
        super.getInfo(assignment, info);
        double conf = this.getValue(assignment);
        if (conf > 0.0) {
            Criterion c = this.getModel().getCriterion(ImportantStudentHardConflict.class);
            double hard = c == null ? 0.0 : c.getValue(assignment);
            info.put("Important student conflicts", sDoubleFormat.format(conf) + (hard > 0.0 ? " [hard: " + sDoubleFormat.format(hard) + "]" : ""));
        }
    }

    public void getInfo(Assignment<Lecture, Placement> assignment, Map<String, String> info, Collection<Lecture> variables) {
        super.getInfo(assignment, info, variables);
        double conf = this.getValue(assignment, variables);
        if (conf > 0.0) {
            Criterion c = this.getModel().getCriterion(ImportantStudentHardConflict.class);
            double hard = c == null ? 0.0 : c.getValue(assignment, variables);
            info.put("Important student conflicts", sDoubleFormat.format(conf) + (hard > 0.0 ? " [hard: " + sDoubleFormat.format(hard) + "]" : ""));
        }
    }
}

