/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.constraint;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.constraint.FlexibleConstraint;
import org.cpsolver.coursett.criteria.FlexibleConstraintCriterion;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.criteria.Criterion;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.ToolBox;

public class MaxHalfDaysFlexibleConstraint
extends FlexibleConstraint {
    private int iMaxHalfDays;
    private int iNoonSlot = 144;

    public MaxHalfDaysFlexibleConstraint(Long id, String owner, String preference, String reference) {
        super(id, owner, preference, reference);
        Matcher matcher = Pattern.compile(FlexibleConstraint.FlexibleConstraintType.MAX_HALF_DAYS.getPattern()).matcher(reference);
        if (matcher.find()) {
            this.iMaxHalfDays = Integer.parseInt(matcher.group(2));
            this.iConstraintType = FlexibleConstraint.FlexibleConstraintType.MAX_HALF_DAYS;
        }
    }

    public void setModel(Model<Lecture, Placement> model) {
        super.setModel(model);
        this.iNoonSlot = ((TimetableModel)model).getProperties().getPropertyInt("General.HalfDaySlot", this.iNoonSlot);
    }

    protected int getNrHalfDays() {
        return 2;
    }

    protected int getHalfDay(TimeLocation time) {
        return time.getStartSlot() < this.iNoonSlot ? 0 : 1;
    }

    @Override
    public double getNrViolations(Assignment<Lecture, Placement> assignment, Set<Placement> conflicts, HashMap<Lecture, Placement> assignments) {
        return ((MaxHalfDaysFlexibleConstraintContext)this.getContext(assignment)).nrViolations(assignments, conflicts);
    }

    public void computeConflicts(Assignment<Lecture, Placement> assignment, Placement value, Set<Placement> conflicts) {
        if (!this.isHard()) {
            return;
        }
        MaxHalfDaysFlexibleConstraintContext context = (MaxHalfDaysFlexibleConstraintContext)this.getContext(assignment);
        while (context.nrHalfDays(value, conflicts) > this.iMaxHalfDays) {
            Set<Lecture> candidates = context.candidates(value, conflicts);
            if (candidates == null) {
                return;
            }
            for (Lecture candidate : candidates) {
                Placement conflict = (Placement)assignment.getValue((Variable)candidate);
                if (conflict == null) continue;
                conflicts.add(conflict);
            }
        }
    }

    public boolean inConflict(Assignment<Lecture, Placement> assignment, Placement value) {
        if (!this.isHard()) {
            return false;
        }
        return ((MaxHalfDaysFlexibleConstraintContext)this.getContext(assignment)).nrHalfDays(value, null) > this.iMaxHalfDays;
    }

    @Override
    public FlexibleConstraint.FlexibleConstraintContext createAssignmentContext(Assignment<Lecture, Placement> assignment) {
        return new MaxHalfDaysFlexibleConstraintContext(assignment);
    }

    public class MaxHalfDaysFlexibleConstraintContext
    extends FlexibleConstraint.FlexibleConstraintContext {
        private Set<Lecture>[] iHalfDayAssignments = null;

        public MaxHalfDaysFlexibleConstraintContext(Assignment<Lecture, Placement> assignment) {
            Criterion criterion;
            this.iHalfDayAssignments = new Set[MaxHalfDaysFlexibleConstraint.this.getNrHalfDays() * Constants.NR_DAYS];
            for (int i = 0; i < this.iHalfDayAssignments.length; ++i) {
                this.iHalfDayAssignments[i] = new HashSet<Lecture>();
            }
            for (Lecture variable : MaxHalfDaysFlexibleConstraint.this.variables()) {
                Placement value = (Placement)assignment.getValue((Variable)variable);
                if (value == null) continue;
                for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
                    if ((value.getTimeLocation().getDayCode() & Constants.DAY_CODES[i]) == 0) continue;
                    this.iHalfDayAssignments[i * MaxHalfDaysFlexibleConstraint.this.getNrHalfDays() + MaxHalfDaysFlexibleConstraint.this.getHalfDay(value.getTimeLocation())].add((Lecture)value.variable());
                }
            }
            if (!MaxHalfDaysFlexibleConstraint.this.isHard() && (criterion = MaxHalfDaysFlexibleConstraint.this.getModel().getCriterion(FlexibleConstraintCriterion.class)) != null) {
                double pref = this.nrViolations(null, null);
                this.iLastPreference = pref == 0.0 ? (double)(-Math.abs(MaxHalfDaysFlexibleConstraint.this.iPreference)) : (double)Math.abs(MaxHalfDaysFlexibleConstraint.this.iPreference) * pref;
                criterion.inc(assignment, this.iLastPreference);
            }
        }

        @Override
        public void assigned(Assignment<Lecture, Placement> assignment, Placement value) {
            for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
                if ((value.getTimeLocation().getDayCode() & Constants.DAY_CODES[i]) == 0) continue;
                this.iHalfDayAssignments[i * MaxHalfDaysFlexibleConstraint.this.getNrHalfDays() + MaxHalfDaysFlexibleConstraint.this.getHalfDay(value.getTimeLocation())].add((Lecture)value.variable());
            }
            this.updateCriterion(assignment);
        }

        @Override
        public void unassigned(Assignment<Lecture, Placement> assignment, Placement value) {
            for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
                if ((value.getTimeLocation().getDayCode() & Constants.DAY_CODES[i]) == 0) continue;
                this.iHalfDayAssignments[i * MaxHalfDaysFlexibleConstraint.this.getNrHalfDays() + MaxHalfDaysFlexibleConstraint.this.getHalfDay(value.getTimeLocation())].remove(value.variable());
            }
            this.updateCriterion(assignment);
        }

        public int nrHalfDays(Placement value, Set<Placement> conflicts) {
            int ret = 0;
            for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
                for (int j = 0; j < MaxHalfDaysFlexibleConstraint.this.getNrHalfDays(); ++j) {
                    int idx = i * MaxHalfDaysFlexibleConstraint.this.getNrHalfDays() + j;
                    int cnt = this.iHalfDayAssignments[idx].size();
                    if (value != null) {
                        if ((value.getTimeLocation().getDayCode() & Constants.DAY_CODES[i]) != 0 && j == MaxHalfDaysFlexibleConstraint.this.getHalfDay(value.getTimeLocation())) {
                            ++cnt;
                        }
                        if (this.iHalfDayAssignments[idx].contains(value.variable())) {
                            --cnt;
                        }
                    }
                    if (conflicts != null) {
                        for (Placement conflict : conflicts) {
                            if (value != null && ((Lecture)conflict.variable()).equals(value.variable()) || !this.iHalfDayAssignments[idx].contains(conflict.variable())) continue;
                            --cnt;
                        }
                    }
                    if (cnt <= 0) continue;
                    ++ret;
                }
            }
            return ret;
        }

        public Set<Lecture> candidates(Placement value, Set<Placement> conflicts) {
            int bestCnt = 0;
            ArrayList<Integer> bestHalfDays = new ArrayList<Integer>();
            for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
                for (int j = 0; j < MaxHalfDaysFlexibleConstraint.this.getNrHalfDays(); ++j) {
                    int idx = i * MaxHalfDaysFlexibleConstraint.this.getNrHalfDays() + j;
                    if ((value.getTimeLocation().getDayCode() & Constants.DAY_CODES[i]) != 0 && j == MaxHalfDaysFlexibleConstraint.this.getHalfDay(value.getTimeLocation())) continue;
                    int cnt = this.iHalfDayAssignments[idx].size();
                    if (this.iHalfDayAssignments[idx].contains(value.variable())) {
                        --cnt;
                    }
                    for (Placement conflict : conflicts) {
                        if (((Lecture)conflict.variable()).equals(value.variable()) || !this.iHalfDayAssignments[idx].contains(conflict.variable())) continue;
                        --cnt;
                    }
                    if (cnt <= 0) continue;
                    if (bestHalfDays.isEmpty() || bestCnt > cnt) {
                        bestHalfDays.clear();
                        bestHalfDays.add(idx);
                        bestCnt = cnt;
                        continue;
                    }
                    if (bestCnt != cnt) continue;
                    bestHalfDays.add(idx);
                }
            }
            return bestHalfDays.isEmpty() ? null : this.iHalfDayAssignments[(Integer)ToolBox.random(bestHalfDays)];
        }

        public int nrViolations(HashMap<Lecture, Placement> assignments, Set<Placement> conflicts) {
            int halfDays = 0;
            for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
                for (int j = 0; j < MaxHalfDaysFlexibleConstraint.this.getNrHalfDays(); ++j) {
                    int idx = i * MaxHalfDaysFlexibleConstraint.this.getNrHalfDays() + j;
                    int cnt = this.iHalfDayAssignments[idx].size();
                    if (assignments != null) {
                        for (Map.Entry entry : assignments.entrySet()) {
                            Placement assignment = (Placement)((Object)entry.getValue());
                            if (assignment == null || (assignment.getTimeLocation().getDayCode() & Constants.DAY_CODES[i]) == 0 || j != MaxHalfDaysFlexibleConstraint.this.getHalfDay(assignment.getTimeLocation())) continue;
                            ++cnt;
                        }
                    }
                    if (conflicts != null) {
                        for (Placement placement : conflicts) {
                            if (assignments != null && assignments.containsKey(placement.variable()) || !this.iHalfDayAssignments[idx].contains(placement.variable())) continue;
                            --cnt;
                        }
                    }
                    if (cnt <= 0) continue;
                    ++halfDays;
                }
            }
            return halfDays <= MaxHalfDaysFlexibleConstraint.this.iMaxHalfDays ? 0 : halfDays - MaxHalfDaysFlexibleConstraint.this.iMaxHalfDays;
        }
    }
}

