/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.neighbours;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamModel;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.model.ExamRoomPlacement;
import org.cpsolver.exam.model.ExamRoomSharing;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;

public class ExamRoomSwapNeighbour
implements Neighbour<Exam, ExamPlacement> {
    private double iValue = 0.0;
    private ExamPlacement iX1;
    private ExamPlacement iX2 = null;
    private ExamRoomPlacement iR1;
    private ExamRoomPlacement iR2 = null;

    public ExamRoomSwapNeighbour(Assignment<Exam, ExamPlacement> assignment, ExamPlacement placement, ExamRoomPlacement current, ExamRoomPlacement swap) {
        Object x;
        if (placement.getRoomPlacements().contains(swap)) {
            return;
        }
        Exam exam = (Exam)placement.variable();
        if (!swap.isAvailable(placement.getPeriod())) {
            return;
        }
        if (!exam.checkDistributionConstraints(assignment, swap)) {
            return;
        }
        int size = 0;
        for (ExamRoomPlacement r : placement.getRoomPlacements()) {
            size += r.getSize(exam.hasAltSeating());
        }
        size -= current.getSize(exam.hasAltSeating());
        if ((size += swap.getSize(exam.hasAltSeating())) < exam.getSize()) {
            return;
        }
        ExamPlacement conflict = null;
        ExamRoomSharing rs = ((ExamModel)exam.getModel()).getRoomSharing();
        if (rs != null && placement.getRoomPlacements().size() == 1) {
            x = new HashSet<ExamPlacement>();
            rs.computeConflicts(exam, (Collection<ExamPlacement>)swap.getRoom().getPlacements(assignment, placement.getPeriod()), swap.getRoom(), (Set<ExamPlacement>)x);
            if (x.size() > 1) {
                return;
            }
            if (x.size() == 1) {
                conflict = (ExamPlacement)((Object)x.iterator().next());
            }
        } else {
            List<ExamPlacement> conf = swap.getRoom().getPlacements(assignment, placement.getPeriod());
            if (conf.size() > 1) {
                return;
            }
            if (conf.size() == 1) {
                conflict = conf.get(0);
            }
        }
        if (conflict == null) {
            HashSet<ExamRoomPlacement> newRooms = new HashSet<ExamRoomPlacement>(placement.getRoomPlacements());
            newRooms.remove(current);
            newRooms.add(swap);
            Iterator i = newRooms.iterator();
            while (i.hasNext()) {
                ExamRoomPlacement r = (ExamRoomPlacement)i.next();
                if (r.equals(swap) || size - r.getSize(exam.hasAltSeating()) < exam.getSize()) continue;
                i.remove();
                size -= r.getSize(exam.hasAltSeating());
            }
            this.iX1 = new ExamPlacement(exam, placement.getPeriodPlacement(), newRooms);
            ExamPlacement p = (ExamPlacement)assignment.getValue((Variable)exam);
            this.iValue = this.iX1.toDouble(assignment) - (p == null ? 0.0 : p.toDouble(assignment));
        } else {
            x = (Exam)conflict.variable();
            ExamRoomPlacement xNew = ((Exam)((Object)x)).getRoomPlacement(current.getRoom());
            if (xNew == null) {
                return;
            }
            if (!((Exam)((Object)x)).checkDistributionConstraints(assignment, xNew)) {
                return;
            }
            int xSize = 0;
            for (ExamRoomPlacement r : conflict.getRoomPlacements()) {
                xSize += r.getSize(((Exam)((Object)x)).hasAltSeating());
            }
            xSize -= swap.getSize(((Exam)((Object)x)).hasAltSeating());
            if ((xSize += current.getSize(((Exam)((Object)x)).hasAltSeating())) < ((Exam)((Object)x)).getSize()) {
                return;
            }
            if (rs != null) {
                ArrayList<ExamPlacement> other = new ArrayList<ExamPlacement>(current.getRoom().getPlacements(assignment, conflict.getPeriod()));
                other.remove((Object)placement);
                if (!other.isEmpty() && conflict.getRoomPlacements().size() > 1) {
                    return;
                }
                if (rs.inConflict((Exam)((Object)x), other, current.getRoom())) {
                    return;
                }
            }
            HashSet<ExamRoomPlacement> newRooms = new HashSet<ExamRoomPlacement>(placement.getRoomPlacements());
            newRooms.remove(current);
            newRooms.add(swap);
            Iterator i = newRooms.iterator();
            while (i.hasNext()) {
                ExamRoomPlacement r = (ExamRoomPlacement)i.next();
                if (r.equals(swap) || size - r.getSize(exam.hasAltSeating()) < exam.getSize()) continue;
                i.remove();
                size -= r.getSize(exam.hasAltSeating());
            }
            this.iX1 = new ExamPlacement(exam, placement.getPeriodPlacement(), newRooms);
            HashSet<ExamRoomPlacement> xRooms = new HashSet<ExamRoomPlacement>(conflict.getRoomPlacements());
            xRooms.remove(((Exam)((Object)x)).getRoomPlacement(swap.getRoom()));
            xRooms.add(xNew);
            Iterator i2 = xRooms.iterator();
            while (i2.hasNext()) {
                ExamRoomPlacement r = (ExamRoomPlacement)i2.next();
                if (r.equals(swap) || xSize - r.getSize(((Exam)((Object)x)).hasAltSeating()) < ((Exam)((Object)x)).getSize()) continue;
                i2.remove();
                xSize -= r.getSize(((Exam)((Object)x)).hasAltSeating());
            }
            this.iX2 = new ExamPlacement((Exam)((Object)x), conflict.getPeriodPlacement(), xRooms);
            ExamPlacement p = (ExamPlacement)assignment.getValue((Variable)exam);
            this.iValue = this.iX1.toDouble(assignment) - (p == null ? 0.0 : p.toDouble(assignment)) + this.iX2.toDouble(assignment) - conflict.toDouble(assignment);
        }
        this.iR1 = current;
        this.iR2 = swap;
    }

    public boolean canDo() {
        return this.iX1 != null;
    }

    public void assign(Assignment<Exam, ExamPlacement> assignment, long iteration) {
        if (this.iX2 == null) {
            assignment.assign(iteration, (Value)this.iX1);
        } else {
            assignment.unassign(iteration, this.iX1.variable());
            assignment.unassign(iteration, this.iX2.variable());
            assignment.assign(iteration, (Value)this.iX1);
            assignment.assign(iteration, (Value)this.iX2);
        }
    }

    public String toString() {
        if (this.iX2 == null) {
            return this.iX1.variable() + " := " + this.iX1.toString() + " /  (value:" + this.value(null) + ")";
        }
        return ((Exam)this.iX1.variable()).getName() + ": " + (Object)((Object)this.iR1.getRoom()) + " <-> " + (Object)((Object)this.iR2.getRoom()) + " (w " + ((Exam)this.iX2.variable()).getName() + ", value:" + this.value(null) + ")";
    }

    protected static String toString(double[] x, double[] y) {
        DecimalFormat df = new DecimalFormat("0.00");
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < x.length; ++i) {
            if (i > 0) {
                s.append(",");
            }
            s.append(df.format(x[i] - y[i]));
        }
        return "[" + s.toString() + "]";
    }

    public double value(Assignment<Exam, ExamPlacement> assignment) {
        return this.iValue;
    }

    public Map<Exam, ExamPlacement> assignments() {
        HashMap<Exam, ExamPlacement> ret = new HashMap<Exam, ExamPlacement>();
        ret.put((Exam)this.iX1.variable(), this.iX1);
        if (this.iX2 != null) {
            ret.put((Exam)this.iX2.variable(), this.iX2);
        }
        return ret;
    }
}

