/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.algorithms;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.cpsolver.ifs.algorithms.ParallelConstruction;
import org.cpsolver.ifs.algorithms.SimpleSearch;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AssignmentContext;
import org.cpsolver.ifs.assignment.context.NeighbourSelectionWithContext;
import org.cpsolver.ifs.heuristics.NeighbourSelection;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.Progress;

public class MetaHeuristicSearch<V extends Variable<V, T>, T extends Value<V, T>>
extends NeighbourSelectionWithContext<V, T, MetaHeuristicSearchContext> {
    private Logger iLog = Logger.getLogger(SimpleSearch.class);
    private List<NeighbourSelection<V, T>> iConstructionPhase = new ArrayList<NeighbourSelection<V, T>>();
    private List<NeighbourSelection<V, T>> iIncompletePhase = new ArrayList<NeighbourSelection<V, T>>();
    private List<NeighbourSelection<V, T>> iHillClimberPhase = new ArrayList<NeighbourSelection<V, T>>();
    private List<NeighbourSelection<V, T>> iImprovementPhase = new ArrayList<NeighbourSelection<V, T>>();
    private Progress iProgress = null;

    public MetaHeuristicSearch(DataProperties properties) {
        String improvements;
        String hillClimbers;
        String incompletes;
        String constructions = properties.getProperty("MetaHeuristic.ConstructionClass");
        if (constructions != null) {
            for (String construction : constructions.split(",")) {
                try {
                    boolean pc = false;
                    if (construction.endsWith("@PC")) {
                        pc = true;
                        construction = construction.substring(0, construction.length() - 3);
                    }
                    if (construction.isEmpty() || "null".equalsIgnoreCase(construction)) {
                        this.iConstructionPhase.add(null);
                        continue;
                    }
                    Class<?> constructionClass = Class.forName(construction);
                    ParallelConstruction constructionSelection = (ParallelConstruction)constructionClass.getConstructor(DataProperties.class).newInstance(properties);
                    if (pc) {
                        constructionSelection = new ParallelConstruction(properties, constructionSelection);
                    }
                    this.iConstructionPhase.add(constructionSelection);
                }
                catch (Exception e) {
                    this.iLog.error((Object)("Unable to use " + construction + ": " + e.getMessage()));
                }
            }
        }
        if ((incompletes = properties.getProperty("MetaHeuristic.IncompleteClass")) != null) {
            for (String incomplete : incompletes.split(",")) {
                try {
                    boolean pc = false;
                    if (incomplete.endsWith("@PC")) {
                        pc = true;
                        incomplete = incomplete.substring(0, incomplete.length() - 3);
                    }
                    if (incomplete.isEmpty() || "null".equalsIgnoreCase(incomplete)) {
                        this.iIncompletePhase.add(null);
                        continue;
                    }
                    Class<?> incompleteClass = Class.forName(incomplete);
                    ParallelConstruction incompleteSelection = (ParallelConstruction)incompleteClass.getConstructor(DataProperties.class).newInstance(properties);
                    if (pc) {
                        incompleteSelection = new ParallelConstruction(properties, incompleteSelection);
                    }
                    this.iIncompletePhase.add(incompleteSelection);
                }
                catch (Exception e) {
                    this.iLog.error((Object)("Unable to use " + incomplete + ": " + e.getMessage()));
                }
            }
        }
        if ((hillClimbers = properties.getProperty("MetaHeuristic.HillClimberClass")) != null) {
            for (String hillClimber : hillClimbers.split(",")) {
                try {
                    if (hillClimber.isEmpty() || "null".equalsIgnoreCase(hillClimber)) {
                        this.iHillClimberPhase.add(null);
                        continue;
                    }
                    Class<?> hillClimberClass = Class.forName(hillClimber);
                    NeighbourSelection hillClimberSelection = (NeighbourSelection)hillClimberClass.getConstructor(DataProperties.class).newInstance(properties);
                    this.iHillClimberPhase.add(hillClimberSelection);
                }
                catch (Exception e) {
                    this.iLog.error((Object)("Unable to use " + hillClimber + ": " + e.getMessage()));
                }
            }
        }
        if ((improvements = properties.getProperty("MetaHeuristic.ImprovementClass")) != null) {
            for (String improvement : improvements.split(",")) {
                try {
                    if (improvement.isEmpty() || "null".equalsIgnoreCase(improvement)) {
                        this.iImprovementPhase.add(null);
                        continue;
                    }
                    Class<?> improvementClass = Class.forName(improvement);
                    NeighbourSelection improvementSelection = (NeighbourSelection)improvementClass.getConstructor(DataProperties.class).newInstance(properties);
                    this.iImprovementPhase.add(improvementSelection);
                }
                catch (Exception e) {
                    this.iLog.error((Object)("Unable to use " + improvement + ": " + e.getMessage()));
                }
            }
        }
    }

    private String getName(NeighbourSelection<V, T> selection) {
        return selection.getClass().getSimpleName().replaceAll("(?<=[^A-Z])([A-Z])", " $1");
    }

    @Override
    public void init(Solver<V, T> solver) {
        super.init(solver);
        for (NeighbourSelection<V, T> ns : this.iConstructionPhase) {
            if (ns == null) continue;
            ns.init(solver);
        }
        for (NeighbourSelection<V, T> ns : this.iIncompletePhase) {
            if (ns == null) continue;
            ns.init(solver);
        }
        for (NeighbourSelection<V, T> ns : this.iHillClimberPhase) {
            if (ns == null) continue;
            ns.init(solver);
        }
        for (NeighbourSelection<V, T> ns : this.iImprovementPhase) {
            if (ns == null) continue;
            ns.init(solver);
        }
        this.iProgress = Progress.getInstance(solver.currentSolution().getModel());
    }

    @Override
    public Neighbour<V, T> selectNeighbour(Solution<V, T> solution) {
        MetaHeuristicSearchContext context = (MetaHeuristicSearchContext)this.getContext(solution.getAssignment());
        Neighbour n = null;
        switch (context.getPhase()) {
            case -1: {
                context.setPhase(0);
                this.iProgress.info("[" + Thread.currentThread().getName() + "] " + this.getName(context.getConstructionSelection()) + "...");
            }
            case 0: {
                if (solution.getModel().nrUnassignedVariables(solution.getAssignment()) > 0 && (n = context.getConstructionSelection().selectNeighbour(solution)) != null) {
                    return n;
                }
                context.setPhase(1);
                if (solution.getModel().nrUnassignedVariables(solution.getAssignment()) > 0) {
                    this.iProgress.info("[" + Thread.currentThread().getName() + "] " + this.getName(context.getIncompleteSelection()) + "...");
                }
            }
            case 1: {
                if (solution.getModel().nrUnassignedVariables(solution.getAssignment()) > 0) {
                    return context.getIncompleteSelection().selectNeighbour(solution);
                }
                context.setPhase(2);
                if (context.hasHillClimberSelection()) {
                    this.iProgress.info("[" + Thread.currentThread().getName() + "] " + this.getName(context.getHillClimberSelection()) + "...");
                }
            }
            case 2: {
                if (solution.getModel().nrUnassignedVariables(solution.getAssignment()) > 0) {
                    return context.getIncompleteSelection().selectNeighbour(solution);
                }
                if (context.hasHillClimberSelection() && (n = context.getHillClimberSelection().selectNeighbour(solution)) != null) {
                    return n;
                }
                context.setPhase(3);
                this.iProgress.info("[" + Thread.currentThread().getName() + "] " + this.getName(context.getImprovementSelection()) + "...");
            }
            case 3: {
                if (solution.getModel().nrUnassignedVariables(solution.getAssignment()) > 0) {
                    return context.getIncompleteSelection().selectNeighbour(solution);
                }
                return context.getImprovementSelection().selectNeighbour(solution);
            }
        }
        return null;
    }

    @Override
    public MetaHeuristicSearchContext createAssignmentContext(Assignment<V, T> assignment) {
        return new MetaHeuristicSearchContext(assignment.getIndex() - 1);
    }

    public class MetaHeuristicSearchContext
    implements AssignmentContext {
        private int iPhase = -1;
        private NeighbourSelection<V, T> iConstructionSelection = null;
        private NeighbourSelection<V, T> iIncompleteSelection = null;
        private NeighbourSelection<V, T> iHillClimberSelection = null;
        private NeighbourSelection<V, T> iImprovementSelection = null;

        public MetaHeuristicSearchContext(int index) {
            if (!MetaHeuristicSearch.this.iConstructionPhase.isEmpty()) {
                if (index < 0) {
                    this.iConstructionSelection = (NeighbourSelection)MetaHeuristicSearch.this.iConstructionPhase.get(0);
                }
                NeighbourSelection neighbourSelection = this.iConstructionSelection = index < 0 ? (NeighbourSelection)MetaHeuristicSearch.this.iConstructionPhase.get(0) : (NeighbourSelection)MetaHeuristicSearch.this.iConstructionPhase.get(index % MetaHeuristicSearch.this.iConstructionPhase.size());
            }
            if (!MetaHeuristicSearch.this.iIncompletePhase.isEmpty()) {
                if (index < 0) {
                    this.iIncompleteSelection = (NeighbourSelection)MetaHeuristicSearch.this.iIncompletePhase.get(0);
                }
                NeighbourSelection neighbourSelection = this.iIncompleteSelection = index < 0 ? (NeighbourSelection)MetaHeuristicSearch.this.iIncompletePhase.get(0) : (NeighbourSelection)MetaHeuristicSearch.this.iIncompletePhase.get(index % MetaHeuristicSearch.this.iIncompletePhase.size());
            }
            if (!MetaHeuristicSearch.this.iImprovementPhase.isEmpty()) {
                if (index < 0) {
                    this.iImprovementSelection = (NeighbourSelection)MetaHeuristicSearch.this.iImprovementPhase.get(0);
                }
                NeighbourSelection neighbourSelection = this.iImprovementSelection = index < 0 ? (NeighbourSelection)MetaHeuristicSearch.this.iImprovementPhase.get(0) : (NeighbourSelection)MetaHeuristicSearch.this.iImprovementPhase.get(index % MetaHeuristicSearch.this.iImprovementPhase.size());
            }
            if (!MetaHeuristicSearch.this.iHillClimberPhase.isEmpty()) {
                if (index < 0) {
                    this.iHillClimberSelection = (NeighbourSelection)MetaHeuristicSearch.this.iHillClimberPhase.get(0);
                }
                NeighbourSelection neighbourSelection = this.iHillClimberSelection = index < 0 ? (NeighbourSelection)MetaHeuristicSearch.this.iHillClimberPhase.get(0) : (NeighbourSelection)MetaHeuristicSearch.this.iHillClimberPhase.get(index % MetaHeuristicSearch.this.iHillClimberPhase.size());
            }
            if (this.iConstructionSelection == null) {
                this.iConstructionSelection = this.iIncompleteSelection;
            }
            if (this.iIncompleteSelection == null) {
                this.iIncompleteSelection = this.iConstructionSelection;
            }
            if (this.iImprovementSelection == null) {
                this.iImprovementSelection = this.iIncompleteSelection;
            }
            MetaHeuristicSearch.this.iLog.info((Object)("Using " + this.iConstructionSelection.getClass().getSimpleName() + " > " + this.iIncompleteSelection.getClass().getSimpleName() + (this.iHillClimberSelection == null ? "" : " > " + this.iHillClimberSelection.getClass().getSimpleName()) + " > " + this.iImprovementSelection.getClass().getSimpleName()));
        }

        public NeighbourSelection<V, T> getConstructionSelection() {
            return this.iConstructionSelection;
        }

        public NeighbourSelection<V, T> getIncompleteSelection() {
            return this.iIncompleteSelection;
        }

        public NeighbourSelection<V, T> getHillClimberSelection() {
            return this.iHillClimberSelection;
        }

        public boolean hasHillClimberSelection() {
            return this.iHillClimberSelection != null;
        }

        public NeighbourSelection<V, T> getImprovementSelection() {
            return this.iImprovementSelection;
        }

        public int getPhase() {
            return this.iPhase;
        }

        public void setPhase(int phase) {
            this.iPhase = phase;
        }
    }
}

