/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.heuristics;

import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.cpsolver.ifs.extension.ConflictStatistics;
import org.cpsolver.ifs.extension.Extension;
import org.cpsolver.ifs.heuristics.NeighbourSelection;
import org.cpsolver.ifs.heuristics.ValueSelection;
import org.cpsolver.ifs.heuristics.VariableSelection;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.model.SimpleNeighbour;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.model.WeakeningConstraint;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.solver.SolverListener;
import org.cpsolver.ifs.util.DataProperties;

public class StandardNeighbourSelection<V extends Variable<V, T>, T extends Value<V, T>>
implements NeighbourSelection<V, T> {
    protected static Logger sLogger = Logger.getLogger(StandardNeighbourSelection.class);
    private ValueSelection<V, T> iValueSelection = null;
    private VariableSelection<V, T> iVariableSelection = null;
    private Solver<V, T> iSolver = null;
    private ConflictStatistics<V, T> iStat = null;

    public void setValueSelection(ValueSelection<V, T> valueSelection) {
        this.iValueSelection = valueSelection;
    }

    public void setVariableSelection(VariableSelection<V, T> variableSelection) {
        this.iVariableSelection = variableSelection;
    }

    public ValueSelection<V, T> getValueSelection() {
        return this.iValueSelection;
    }

    public VariableSelection<V, T> getVariableSelection() {
        return this.iVariableSelection;
    }

    public StandardNeighbourSelection(DataProperties properties) throws Exception {
        String valueSelectionClassName = properties.getProperty("Value.Class", "org.cpsolver.ifs.heuristics.GeneralValueSelection");
        sLogger.info((Object)("Using " + valueSelectionClassName));
        Class<?> valueSelectionClass = Class.forName(valueSelectionClassName);
        Constructor<?> valueSelectionConstructor = valueSelectionClass.getConstructor(DataProperties.class);
        this.setValueSelection((ValueSelection)valueSelectionConstructor.newInstance(properties));
        String variableSelectionClassName = properties.getProperty("Variable.Class", "org.cpsolver.ifs.heuristics.GeneralVariableSelection");
        sLogger.info((Object)("Using " + variableSelectionClassName));
        Class<?> variableSelectionClass = Class.forName(variableSelectionClassName);
        Constructor<?> variableSelectionConstructor = variableSelectionClass.getConstructor(DataProperties.class);
        this.setVariableSelection((VariableSelection)variableSelectionConstructor.newInstance(properties));
    }

    @Override
    public void init(Solver<V, T> solver) {
        this.getValueSelection().init(solver);
        this.getVariableSelection().init(solver);
        this.iSolver = solver;
        for (Extension<V, T> ext : solver.getExtensions()) {
            if (!(ext instanceof ConflictStatistics)) continue;
            this.iStat = (ConflictStatistics)ext;
        }
    }

    public V selectVariable(Solution<V, T> solution) {
        V variable = this.getVariableSelection().selectVariable(solution);
        for (SolverListener<V, T> listener : this.iSolver.getSolverListeners()) {
            if (listener.variableSelected(solution.getAssignment(), solution.getIteration(), variable)) continue;
            return null;
        }
        if (variable == null) {
            sLogger.debug((Object)"No variable selected.");
        }
        if (variable != null && ((Variable)variable).values(solution.getAssignment()).isEmpty()) {
            sLogger.debug((Object)("Variable " + ((Variable)variable).getName() + " has no values."));
            return null;
        }
        return variable;
    }

    public T selectValue(Solution<V, T> solution, V variable) {
        T value = this.getValueSelection().selectValue(solution, variable);
        for (SolverListener<V, T> solverListener : this.iSolver.getSolverListeners()) {
            if (solverListener.valueSelected(solution.getAssignment(), solution.getIteration(), variable, value)) continue;
            return null;
        }
        if (value == null) {
            sLogger.debug((Object)("No value selected for variable " + variable + "."));
            for (Constraint constraint : ((Variable)variable).hardConstraints()) {
                if (!constraint.isHard() || !(constraint instanceof WeakeningConstraint)) continue;
                ((WeakeningConstraint)((Object)constraint)).weaken(solution.getAssignment());
            }
            for (Constraint constraint : solution.getModel().globalConstraints()) {
                if (!constraint.isHard() || !(constraint instanceof WeakeningConstraint)) continue;
                ((WeakeningConstraint)((Object)constraint)).weaken(solution.getAssignment());
            }
            return null;
        }
        for (Constraint constraint : ((Variable)variable).hardConstraints()) {
            if (!(constraint instanceof WeakeningConstraint) || !constraint.inConflict(solution.getAssignment(), value)) continue;
            ((WeakeningConstraint)((Object)constraint)).weaken(solution.getAssignment());
        }
        for (Constraint constraint : solution.getModel().globalConstraints()) {
            if (!(constraint instanceof WeakeningConstraint) || !constraint.inConflict(solution.getAssignment(), value)) continue;
            ((WeakeningConstraint)((Object)constraint)).weaken(solution.getAssignment());
        }
        return value;
    }

    @Override
    public Neighbour<V, T> selectNeighbour(Solution<V, T> solution) {
        V variable = this.selectVariable(solution);
        if (variable == null) {
            return null;
        }
        T value = this.selectValue(solution, variable);
        if (value == null) {
            return null;
        }
        if (this.iSolver.hasSingleSolution()) {
            Set<T> conflicts = solution.getModel().conflictValues(solution.getAssignment(), value);
            if (this.iStat != null) {
                for (Map.Entry<Constraint<V, T>, Set<T>> entry : solution.getModel().conflictConstraints(solution.getAssignment(), value).entrySet()) {
                    this.iStat.constraintAfterAssigned(solution.getAssignment(), solution.getIteration(), entry.getKey(), value, entry.getValue());
                }
            }
            return new SimpleNeighbour<V, T>(variable, value, conflicts);
        }
        return new SimpleNeighbour<V, T>(variable, value);
    }
}

