/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.online;

import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.reservation.Reservation;

public class OnlineReservation
extends Reservation {
    private int iType;
    private int iLimit;
    private boolean iApply;
    private boolean iOverride;

    public OnlineReservation(int type, long id, Offering offering, int priority, boolean over, int limit, boolean apply, boolean mustUse, boolean allowOverlap, boolean expired, boolean override) {
        super(id, offering, priority, mustUse, over, allowOverlap);
        this.iType = type;
        this.iLimit = limit;
        this.iApply = apply;
        this.iOverride = override;
        this.setExpired(expired);
    }

    public OnlineReservation(int type, long id, Offering offering, int priority, boolean over, int limit, boolean apply, boolean mustUse, boolean allowOverlap, boolean expired) {
        this(type, id, offering, priority, over, limit, apply, mustUse, allowOverlap, expired, false);
    }

    public int getType() {
        return this.iType;
    }

    @Override
    public double getReservationLimit() {
        return this.iLimit;
    }

    @Override
    public boolean isApplicable(Student student) {
        return this.iApply;
    }

    public boolean isOverride() {
        return this.iOverride;
    }

    @Override
    public boolean mustBeUsed() {
        if (this.iOverride) {
            return this.mustBeUsedIgnoreExpiration();
        }
        return super.mustBeUsed();
    }

    @Override
    public double getLimitCap() {
        return this.getReservationLimit();
    }
}

