/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.model;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.model.TimeLocation;

public class RoomSharingModel {
    protected int iStep = 1;
    protected Long[][] iPreference = null;
    protected Long[] iDepartmentIds = null;
    protected HashMap<Long, Integer> iDepartmentIdx = null;
    public static Long sFreeForAllPref = new Long(-1L);
    public static Long sNotAvailablePref = new Long(-2L);
    public static char sFreeForAllPrefChar = (char)42;
    public static char sNotAvailablePrefChar = (char)35;
    public static Long sDefaultPref = sFreeForAllPref;
    public static char sDefaultPrefChar = sFreeForAllPrefChar;
    public char iFreeForAllPrefChar = sFreeForAllPrefChar;
    public char iNotAvailablePrefChar = sNotAvailablePrefChar;
    private Map<Character, Long> iPatternMapping = null;

    protected RoomSharingModel(int step) {
        this.iStep = step;
    }

    protected RoomSharingModel() {
        this(6);
    }

    public RoomSharingModel(int step, Map<Character, Long> managerIds, String pattern, Character freeForAllPrefChar, Character notAvailablePrefChar) {
        this.iStep = step;
        this.iPreference = new Long[this.getNrDays()][this.getNrTimes()];
        this.iDepartmentIds = new Long[managerIds == null ? 0 : managerIds.size()];
        this.iDepartmentIdx = new HashMap();
        if (managerIds != null) {
            this.iPatternMapping = new HashMap<Character, Long>(managerIds);
            int i = 0;
            for (Character ch : new TreeSet<Character>(managerIds.keySet())) {
                Long id;
                this.iDepartmentIds[i] = id = managerIds.get(ch);
                this.iDepartmentIdx.put(id, i);
                ++i;
            }
        }
        if (freeForAllPrefChar != null) {
            this.iFreeForAllPrefChar = freeForAllPrefChar.charValue();
        }
        if (notAvailablePrefChar != null) {
            this.iNotAvailablePrefChar = notAvailablePrefChar.charValue();
        }
        this.setPreferences(pattern);
    }

    public RoomSharingModel(int step, Long[] managerIds, String pattern, Character freeForAllPrefChar, Character notAvailablePrefChar) {
        this.iStep = step;
        this.iPreference = new Long[this.getNrDays()][this.getNrTimes()];
        this.iDepartmentIds = new Long[managerIds.length];
        this.iDepartmentIdx = new HashMap();
        for (int i = 0; i < managerIds.length; ++i) {
            this.iDepartmentIds[i] = managerIds[i];
            this.iDepartmentIdx.put(managerIds[i], i);
        }
        if (freeForAllPrefChar != null) {
            this.iFreeForAllPrefChar = freeForAllPrefChar.charValue();
        }
        if (notAvailablePrefChar != null) {
            this.iNotAvailablePrefChar = notAvailablePrefChar.charValue();
        }
        this.setPreferences(pattern);
    }

    public char getFreeForAllPrefChar() {
        return this.iFreeForAllPrefChar;
    }

    public void setFreeForAllPrefChar(char c) {
        this.iFreeForAllPrefChar = c;
    }

    public char getNotAvailablePrefChar() {
        return this.iNotAvailablePrefChar;
    }

    public void setNotAvailablePrefChar(char c) {
        this.iNotAvailablePrefChar = c;
    }

    public boolean isFreeForAll(int day, int time) {
        return sFreeForAllPref.equals(this.iPreference[day][time]);
    }

    public boolean isFreeForAll(int slot) {
        int day = slot / 288;
        int time = slot % 288 / this.getStep();
        return sFreeForAllPref.equals(this.iPreference[day][time]);
    }

    public boolean isNotAvailable(int day, int time) {
        return sNotAvailablePref.equals(this.iPreference[day][time]);
    }

    public boolean isNotAvailable(int slot) {
        int day = slot / 288;
        int time = slot % 288 / this.getStep();
        return sNotAvailablePref.equals(this.iPreference[day][time]);
    }

    public boolean isAvailable(TimeLocation timeLocation, Long departmentId) {
        for (int d = 0; d < Constants.NR_DAYS; ++d) {
            if ((Constants.DAY_CODES[d] & timeLocation.getDayCode()) == 0) continue;
            int startTime = timeLocation.getStartSlot() / this.getStep();
            int endTime = (timeLocation.getStartSlot() + timeLocation.getLength() - 1) / this.getStep();
            for (int t = startTime; t <= endTime; ++t) {
                Long pref = this.iPreference[d][t];
                if (pref.equals(sNotAvailablePref)) {
                    return false;
                }
                if (pref.equals(sFreeForAllPref) || departmentId == null || departmentId.equals(pref)) continue;
                return false;
            }
        }
        return true;
    }

    public Long getDepartmentId(int day, int time) {
        Long pref = this.iPreference[day][time];
        if (pref.equals(sFreeForAllPref) || pref.equals(sNotAvailablePref)) {
            return null;
        }
        return pref;
    }

    public Long getDepartmentId(int slot) {
        int day = slot / 288;
        int time = slot % 288 / this.getStep();
        return this.getDepartmentId(day, time);
    }

    public Long[] getDepartmentIds() {
        return this.iDepartmentIds;
    }

    public int getNrDepartments() {
        return this.iDepartmentIds == null ? 0 : this.iDepartmentIds.length;
    }

    public int getIndex(Long departmentId) {
        Integer idx = this.iDepartmentIdx.get(departmentId);
        if (idx == null) {
            return -1;
        }
        return idx;
    }

    public char getCharacter(Long departmentId) {
        if (this.iPatternMapping != null) {
            for (Map.Entry<Character, Long> e : this.iPatternMapping.entrySet()) {
                if (!e.getValue().equals(departmentId)) continue;
                return e.getKey().charValue();
            }
        }
        return (char)(48 + this.getIndex(departmentId));
    }

    public Long getDepartmentId(char ch) {
        if (this.iPatternMapping != null) {
            return this.iPatternMapping.get(Character.valueOf(ch));
        }
        return this.iDepartmentIds[ch - 48];
    }

    public String getPreferences() {
        StringBuffer sb = new StringBuffer();
        for (int d = 0; d < this.getNrDays(); ++d) {
            for (int t = 0; t < this.getNrTimes(); ++t) {
                if (this.iPreference[d][t].equals(sFreeForAllPref)) {
                    sb.append(this.getFreeForAllPrefChar());
                    continue;
                }
                if (this.iPreference[d][t].equals(sNotAvailablePref)) {
                    sb.append(this.getNotAvailablePrefChar());
                    continue;
                }
                sb.append(this.getCharacter(this.iPreference[d][t]));
            }
        }
        return sb.toString();
    }

    public void setPreferences(String pattern) {
        try {
            int idx = 0;
            for (int d = 0; d < this.getNrDays(); ++d) {
                for (int t = 0; t < this.getNrTimes(); ++t) {
                    char pref = pattern != null && idx < pattern.length() ? pattern.charAt(idx) : this.getFreeForAllPrefChar();
                    ++idx;
                    this.iPreference[d][t] = pref == this.getNotAvailablePrefChar() ? sNotAvailablePref : (pref == this.getFreeForAllPrefChar() ? sFreeForAllPref : this.getDepartmentId(pref));
                }
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public int getNrDays() {
        return Constants.NR_DAYS;
    }

    public int getNrTimes() {
        return 288 / this.getStep();
    }

    public int getStep() {
        return this.iStep;
    }
}

