/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.constraint;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.constraint.JenrlConstraint;
import org.cpsolver.coursett.criteria.DistributionPreferences;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AssignmentConstraintContext;
import org.cpsolver.ifs.assignment.context.ConstraintWithContext;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.GlobalConstraint;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.WeakeningConstraint;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.DistanceMetric;
import org.cpsolver.ifs.util.ToolBox;

public class GroupConstraint
extends ConstraintWithContext<Lecture, Placement, GroupConstraintContext> {
    private Long iConstraintId;
    private int iPreference;
    private ConstraintTypeInterface iType;
    private boolean iIsRequired;
    private boolean iIsProhibited;
    private int iDayOfWeekOffset = 0;
    private boolean iPrecedenceConsiderDatePatterns = true;
    private boolean iMaxNHoursADayConsiderDatePatterns = true;
    private int iForwardCheckMaxDepth = 2;
    private int iForwardCheckMaxDomainSize = 1000;
    private int iNrWorkDays = 5;
    private int iFirstWorkDay = 0;

    public static ConstraintTypeInterface getConstraintType(String reference) {
        for (ConstraintType t : ConstraintType.values()) {
            if (t.reference().equals(reference)) {
                return t;
            }
            if (t.iAssignmentPairCheck == null || !reference.matches(t.reference())) continue;
            return t.iAssignmentPairCheck.create(reference, t.reference());
        }
        return null;
    }

    public GroupConstraint() {
    }

    @Override
    public void setModel(Model<Lecture, Placement> model) {
        super.setModel(model);
        if (model != null) {
            DataProperties config = ((TimetableModel)model).getProperties();
            this.iDayOfWeekOffset = config.getPropertyInt("DatePattern.DayOfWeekOffset", 0);
            this.iPrecedenceConsiderDatePatterns = config.getPropertyBoolean("Precedence.ConsiderDatePatterns", true);
            this.iForwardCheckMaxDepth = config.getPropertyInt("ForwardCheck.MaxDepth", this.iForwardCheckMaxDepth);
            this.iForwardCheckMaxDomainSize = config.getPropertyInt("ForwardCheck.MaxDomainSize", this.iForwardCheckMaxDomainSize);
            this.iMaxNHoursADayConsiderDatePatterns = config.getPropertyBoolean("MaxNHoursADay.ConsiderDatePatterns", this.iMaxNHoursADayConsiderDatePatterns);
            this.iNrWorkDays = config.getPropertyInt("General.LastWorkDay", 4) - config.getPropertyInt("General.FirstWorkDay", 0) + 1;
            if (this.iNrWorkDays <= 0) {
                this.iNrWorkDays += 7;
            }
            if (this.iNrWorkDays > 7) {
                this.iNrWorkDays -= 7;
            }
            this.iFirstWorkDay = config.getPropertyInt("General.FirstWorkDay", 0);
        }
    }

    @Override
    public void addVariable(Lecture lecture) {
        if (!this.variables().contains(lecture)) {
            super.addVariable(lecture);
        }
        if (this.getType().is(Flag.CH_NOTOVERLAP) && lecture.getChildrenSubpartIds() != null) {
            for (Long subpartId : lecture.getChildrenSubpartIds()) {
                for (Lecture ch : lecture.getChildren(subpartId)) {
                    if (this.variables().contains(ch)) continue;
                    super.addVariable(ch);
                }
            }
        }
    }

    @Override
    public void removeVariable(Lecture lecture) {
        if (this.variables().contains(lecture)) {
            super.removeVariable(lecture);
        }
        if (this.getType().is(Flag.CH_NOTOVERLAP) && lecture.getChildrenSubpartIds() != null) {
            for (Long subpartId : lecture.getChildrenSubpartIds()) {
                for (Lecture ch : lecture.getChildren(subpartId)) {
                    if (!this.variables().contains(ch)) continue;
                    super.removeVariable(ch);
                }
            }
        }
    }

    public GroupConstraint(Long id, ConstraintTypeInterface type, String preference) {
        this.iConstraintId = id;
        this.iType = type;
        this.iIsRequired = preference.equals("R");
        this.iIsProhibited = preference.equals("P");
        this.iPreference = Constants.preference2preferenceLevel(preference);
    }

    public Long getConstraintId() {
        return this.iConstraintId;
    }

    @Override
    public long getId() {
        return this.iConstraintId == null ? -1L : this.iConstraintId;
    }

    protected long getGeneratedId() {
        return this.iId;
    }

    public ConstraintTypeInterface getType() {
        return this.iType;
    }

    public void setType(ConstraintType type) {
        this.iType = type;
    }

    public boolean isRequired() {
        return this.iIsRequired;
    }

    public boolean isProhibited() {
        return this.iIsProhibited;
    }

    public String getPrologPreference() {
        return Constants.preferenceLevel2preference(this.iPreference);
    }

    @Override
    public boolean isConsistent(Placement value1, Placement value2) {
        HashMap<Lecture, Placement> assignments;
        if (!this.isHard()) {
            return true;
        }
        if (!this.isSatisfiedPair(null, value1, value2)) {
            return false;
        }
        if (this.getType().is(Flag.BACK_TO_BACK)) {
            assignments = new HashMap<Lecture, Placement>();
            assignments.put((Lecture)value1.variable(), value1);
            assignments.put((Lecture)value2.variable(), value2);
            if (!this.isSatisfiedSeq(null, assignments, null)) {
                return false;
            }
        }
        if (this.getType().is(Flag.MAX_HRS_DAY)) {
            assignments = new HashMap();
            assignments.put((Lecture)value1.variable(), value1);
            assignments.put((Lecture)value2.variable(), value2);
            for (int dayCode : Constants.DAY_CODES) {
                if (this.iMaxNHoursADayConsiderDatePatterns) {
                    for (BitSet week : ((TimetableModel)this.getModel()).getWeeks()) {
                        if (!value1.getTimeLocation().shareWeeks(week) && !value2.getTimeLocation().shareWeeks(week) || this.nrSlotsADay(null, dayCode, week, assignments, null) <= this.getType().getMax()) continue;
                        return false;
                    }
                    continue;
                }
                if (this.nrSlotsADay(null, dayCode, null, assignments, null) <= this.getType().getMax()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void computeConflicts(Assignment<Lecture, Placement> assignment, Placement value, Set<Placement> conflicts) {
        this.computeConflicts(assignment, value, conflicts, true);
    }

    @Override
    public void computeConflictsNoForwardCheck(Assignment<Lecture, Placement> assignment, Placement value, Set<Placement> conflicts) {
        this.computeConflicts(assignment, value, conflicts, false);
    }

    public void computeConflicts(Assignment<Lecture, Placement> assignment, Placement value, Set<Placement> conflicts, boolean fwdCheck) {
        HashMap<Lecture, Placement> assignments;
        if (!this.isHard()) {
            return;
        }
        for (Lecture v : this.variables()) {
            Placement p;
            if (v.equals(value.variable()) || (p = assignment.getValue(v)) == null || this.isSatisfiedPair(assignment, p, value)) continue;
            conflicts.add(p);
        }
        if (this.getType().is(Flag.BACK_TO_BACK)) {
            assignments = new HashMap<Lecture, Placement>();
            assignments.put((Lecture)value.variable(), value);
            if (!this.isSatisfiedSeq(assignment, assignments, conflicts)) {
                conflicts.add(value);
            }
        }
        if (this.getType().is(Flag.MAX_HRS_DAY)) {
            assignments = new HashMap();
            assignments.put((Lecture)value.variable(), value);
            block1: for (int dayCode : Constants.DAY_CODES) {
                if (this.iMaxNHoursADayConsiderDatePatterns) {
                    block2: for (BitSet bitSet : ((TimetableModel)this.getModel()).getWeeks()) {
                        if (!value.getTimeLocation().shareWeeks(bitSet) || this.nrSlotsADay(assignment, dayCode, bitSet, assignments, conflicts) <= this.getType().getMax()) continue;
                        ArrayList<Placement> adepts = new ArrayList<Placement>();
                        for (Lecture l : this.variables()) {
                            Placement p;
                            if (l.equals(value.variable()) || l.isConstant() || (p = assignment.getValue(l)) == null || conflicts.contains(p) || p.getTimeLocation() == null || (p.getTimeLocation().getDayCode() & dayCode) == 0 || !p.getTimeLocation().shareWeeks(bitSet)) continue;
                            adepts.add(p);
                        }
                        do {
                            if (adepts.isEmpty()) {
                                conflicts.add(value);
                                continue block2;
                            }
                            Placement conflict = (Placement)ToolBox.random(adepts);
                            adepts.remove(conflict);
                            conflicts.add(conflict);
                        } while (this.nrSlotsADay(assignment, dayCode, bitSet, assignments, conflicts) > this.getType().getMax());
                    }
                    continue;
                }
                if (this.nrSlotsADay(assignment, dayCode, null, assignments, conflicts) <= this.getType().getMax()) continue;
                ArrayList<Placement> adepts = new ArrayList<Placement>();
                for (Lecture l : this.variables()) {
                    Placement p;
                    if (l.equals(value.variable()) || l.isConstant() || (p = assignment.getValue(l)) == null || conflicts.contains(p) || p.getTimeLocation() == null || (p.getTimeLocation().getDayCode() & dayCode) == 0) continue;
                    adepts.add(p);
                }
                do {
                    if (adepts.isEmpty()) {
                        conflicts.add(value);
                        continue block1;
                    }
                    Placement placement = (Placement)ToolBox.random(adepts);
                    adepts.remove(placement);
                    conflicts.add(placement);
                } while (this.nrSlotsADay(assignment, dayCode, null, assignments, conflicts) > this.getType().getMax());
            }
        }
        if (fwdCheck) {
            this.forwardCheck(assignment, value, conflicts, new HashSet<GroupConstraint>(), this.iForwardCheckMaxDepth - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forwardCheck(Assignment<Lecture, Placement> assignment, Placement value, Set<Placement> conflicts, Set<GroupConstraint> ignore, int depth) {
        try {
            if (depth < 0) {
                return;
            }
            ignore.add(this);
            ArrayList<Placement> neededSize = null;
            for (Lecture lecture : this.variables()) {
                if (conflicts.contains(value)) break;
                if (lecture.equals(value.variable())) continue;
                Placement current = assignment.getValue(lecture);
                if (current != null) {
                    if (this.isSatisfiedPair(assignment, value, current)) {
                        if (!this.canShareRoom() || !GroupConstraint.sameRoomAndOverlaps(value, current)) continue;
                        if (neededSize == null) {
                            neededSize = new ArrayList<Placement>();
                        }
                        neededSize.add(current);
                        continue;
                    }
                    conflicts.add(current);
                }
                boolean shareRoomAndOverlaps = this.canShareRoom();
                Placement support = null;
                int nrSupports = 0;
                if (lecture.nrValues() >= (long)this.iForwardCheckMaxDomainSize) {
                    return;
                }
                List<Placement> values = lecture.values(assignment);
                if (values.isEmpty()) {
                    return;
                }
                for (Placement placement : values) {
                    if (nrSupports < 2) {
                        if (this.isSatisfiedPair(assignment, value, placement)) {
                            if (support == null) {
                                support = placement;
                            }
                            ++nrSupports;
                            if (shareRoomAndOverlaps && !GroupConstraint.sameRoomAndOverlaps(value, placement)) {
                                shareRoomAndOverlaps = false;
                            }
                        }
                    } else if (shareRoomAndOverlaps && !GroupConstraint.sameRoomAndOverlaps(value, placement) && this.isSatisfiedPair(assignment, value, placement)) {
                        shareRoomAndOverlaps = false;
                    }
                    if (nrSupports <= 1 || shareRoomAndOverlaps) continue;
                    break;
                }
                if (nrSupports == 0) {
                    conflicts.add(value);
                    return;
                }
                if (shareRoomAndOverlaps && support != null) {
                    if (neededSize == null) {
                        neededSize = new ArrayList();
                    }
                    neededSize.add(support);
                }
                if (nrSupports != 1) continue;
                for (Constraint constraint : lecture.hardConstraints()) {
                    if (constraint instanceof WeakeningConstraint) continue;
                    if (constraint instanceof GroupConstraint) {
                        GroupConstraint gc = (GroupConstraint)constraint;
                        if (depth <= 0 || ignore.contains(gc)) continue;
                        gc.forwardCheck(assignment, support, conflicts, ignore, depth - 1);
                        continue;
                    }
                    constraint.computeConflicts(assignment, support, conflicts);
                }
                for (GlobalConstraint globalConstraint : this.getModel().globalConstraints()) {
                    if (globalConstraint instanceof WeakeningConstraint) continue;
                    globalConstraint.computeConflicts(assignment, support, conflicts);
                }
                if (!conflicts.contains(support)) continue;
                conflicts.add(value);
            }
            if (this.canShareRoom() && neededSize != null) {
                RoomLocation room;
                if (value.getRoomLocations() != null) {
                    for (RoomLocation room2 : value.getRoomLocations()) {
                        if (room2.getRoomConstraint() == null || room2.getRoomConstraint().checkRoomSize(value, neededSize)) continue;
                        conflicts.add(value);
                    }
                } else if (value.getRoomLocation() != null && (room = value.getRoomLocation()).getRoomConstraint() != null && !room.getRoomConstraint().checkRoomSize(value, neededSize)) {
                    conflicts.add(value);
                }
            }
        }
        finally {
            ignore.remove(this);
        }
    }

    @Override
    public boolean inConflict(Assignment<Lecture, Placement> assignment, Placement value) {
        HashMap<Lecture, Placement> assignments;
        if (!this.isHard()) {
            return false;
        }
        for (Lecture v : this.variables()) {
            Placement p;
            if (v.equals(value.variable()) || (p = assignment.getValue(v)) == null || this.isSatisfiedPair(assignment, p, value)) continue;
            return true;
        }
        if (this.getType().is(Flag.BACK_TO_BACK)) {
            assignments = new HashMap<Lecture, Placement>();
            assignments.put((Lecture)value.variable(), value);
            if (!this.isSatisfiedSeq(assignment, assignments, null)) {
                return true;
            }
        }
        if (this.getType().is(Flag.MAX_HRS_DAY)) {
            assignments = new HashMap();
            assignments.put((Lecture)value.variable(), value);
            for (int dayCode : Constants.DAY_CODES) {
                if (this.iMaxNHoursADayConsiderDatePatterns) {
                    for (BitSet week : ((TimetableModel)this.getModel()).getWeeks()) {
                        if (!value.getTimeLocation().shareWeeks(week) || this.nrSlotsADay(assignment, dayCode, week, assignments, null) <= this.getType().getMax()) continue;
                        return true;
                    }
                    continue;
                }
                if (this.nrSlotsADay(assignment, dayCode, null, assignments, null) <= this.getType().getMax()) continue;
                return true;
            }
        }
        return !this.forwardCheck(assignment, value, new HashSet<GroupConstraint>(), this.iForwardCheckMaxDepth - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean forwardCheck(Assignment<Lecture, Placement> assignment, Placement value, Set<GroupConstraint> ignore, int depth) {
        try {
            if (depth < 0) {
                boolean bl = true;
                return bl;
            }
            ignore.add(this);
            int neededSize = ((Lecture)value.variable()).maxRoomUse();
            for (Lecture lecture : this.variables()) {
                if (lecture.equals(value.variable())) continue;
                Placement current = assignment.getValue(lecture);
                if (current != null) {
                    if (this.isSatisfiedPair(assignment, value, current)) {
                        if (!this.canShareRoom() || !GroupConstraint.sameRoomAndOverlaps(value, current)) continue;
                        neededSize += lecture.maxRoomUse();
                        continue;
                    }
                    boolean bl = false;
                    return bl;
                }
                boolean shareRoomAndOverlaps = this.canShareRoom();
                Placement support = null;
                int nrSupports = 0;
                if (lecture.nrValues() >= (long)this.iForwardCheckMaxDomainSize) {
                    boolean bl = true;
                    return bl;
                }
                List<Placement> values = lecture.values(assignment);
                if (values.isEmpty()) {
                    boolean bl = true;
                    return bl;
                }
                for (Placement placement : lecture.values(assignment)) {
                    if (nrSupports < 2) {
                        if (this.isSatisfiedPair(assignment, value, placement)) {
                            if (support == null) {
                                support = placement;
                            }
                            ++nrSupports;
                            if (shareRoomAndOverlaps && !GroupConstraint.sameRoomAndOverlaps(value, placement)) {
                                shareRoomAndOverlaps = false;
                            }
                        }
                    } else if (shareRoomAndOverlaps && !GroupConstraint.sameRoomAndOverlaps(value, placement) && this.isSatisfiedPair(assignment, value, placement)) {
                        shareRoomAndOverlaps = false;
                    }
                    if (nrSupports <= 1 || shareRoomAndOverlaps) continue;
                    break;
                }
                if (nrSupports == 0) {
                    boolean bl = false;
                    return bl;
                }
                if (shareRoomAndOverlaps) {
                    neededSize += lecture.maxRoomUse();
                }
                if (nrSupports != 1) continue;
                for (Constraint constraint : lecture.hardConstraints()) {
                    if (constraint instanceof WeakeningConstraint) continue;
                    if (constraint instanceof GroupConstraint) {
                        GroupConstraint gc = (GroupConstraint)constraint;
                        if (depth <= 0 || ignore.contains(gc) || gc.forwardCheck(assignment, support, ignore, depth - 1)) continue;
                        boolean bl = false;
                        return bl;
                    }
                    if (!constraint.inConflict(assignment, support)) continue;
                    boolean bl = false;
                    return bl;
                }
                for (GlobalConstraint globalConstraint : this.getModel().globalConstraints()) {
                    if (globalConstraint instanceof WeakeningConstraint) continue;
                    if (!globalConstraint.inConflict(assignment, support)) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            if (this.canShareRoom() && neededSize > value.getRoomSize()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            ignore.remove(this);
        }
    }

    public int getPreference() {
        return this.iPreference;
    }

    public int getCurrentPreference(Assignment<Lecture, Placement> assignment) {
        if (this.isHard()) {
            return 0;
        }
        if (this.countAssignedVariables(assignment) < 2) {
            return -Math.abs(this.iPreference);
        }
        if (this.getType().is(Flag.MAX_HRS_DAY)) {
            int over = 0;
            for (int dayCode : Constants.DAY_CODES) {
                if (this.iMaxNHoursADayConsiderDatePatterns) {
                    for (BitSet week : ((TimetableModel)this.getModel()).getWeeks()) {
                        over += Math.max(0, this.nrSlotsADay(assignment, dayCode, week, null, null) - this.getType().getMax());
                    }
                    continue;
                }
                over += Math.max(0, this.nrSlotsADay(assignment, dayCode, null, null, null) - this.getType().getMax());
            }
            return over > 0 ? Math.abs(this.iPreference) * over / 12 : -Math.abs(this.iPreference);
        }
        int nrViolatedPairs = 0;
        for (Lecture v1 : this.variables()) {
            Placement p1 = assignment.getValue(v1);
            if (p1 == null) continue;
            for (Lecture v2 : this.variables()) {
                Placement p2 = assignment.getValue(v2);
                if (p2 == null || v1.getId() >= v2.getId() || this.isSatisfiedPair(assignment, p1, p2)) continue;
                ++nrViolatedPairs;
            }
        }
        if (this.getType().is(Flag.BACK_TO_BACK)) {
            HashSet<Placement> conflicts = new HashSet<Placement>();
            nrViolatedPairs = this.isSatisfiedSeq(assignment, new HashMap<Lecture, Placement>(), conflicts) ? (nrViolatedPairs += conflicts.size()) : this.variables().size();
        }
        return nrViolatedPairs > 0 ? Math.abs(this.iPreference) * nrViolatedPairs : -Math.abs(this.iPreference);
    }

    public int getCurrentPreference(Assignment<Lecture, Placement> assignment, Placement placement) {
        if (this.isHard()) {
            return 0;
        }
        if (this.countAssignedVariables(assignment) + (assignment.getValue((Lecture)placement.variable()) == null ? 1 : 0) < 2) {
            return 0;
        }
        if (this.getType().is(Flag.MAX_HRS_DAY)) {
            HashMap<Lecture, Placement> assignments = new HashMap<Lecture, Placement>();
            assignments.put((Lecture)placement.variable(), placement);
            HashMap<Lecture, Placement> unassignments = new HashMap<Lecture, Placement>();
            unassignments.put((Lecture)placement.variable(), (Placement)null);
            int after = 0;
            int before = 0;
            for (int dayCode : Constants.DAY_CODES) {
                if (this.iMaxNHoursADayConsiderDatePatterns) {
                    for (BitSet week : ((TimetableModel)this.getModel()).getWeeks()) {
                        after += Math.max(0, this.nrSlotsADay(assignment, dayCode, week, assignments, null) - this.getType().getMax());
                        before += Math.max(0, this.nrSlotsADay(assignment, dayCode, week, unassignments, null) - this.getType().getMax());
                    }
                    continue;
                }
                after += Math.max(0, this.nrSlotsADay(assignment, dayCode, null, assignments, null) - this.getType().getMax());
                before += Math.max(0, this.nrSlotsADay(assignment, dayCode, null, unassignments, null) - this.getType().getMax());
            }
            return (after > 0 ? Math.abs(this.iPreference) * after / 12 : -Math.abs(this.iPreference)) - (before > 0 ? Math.abs(this.iPreference) * before / 12 : -Math.abs(this.iPreference));
        }
        int nrViolatedPairsAfter = 0;
        int nrViolatedPairsBefore = 0;
        for (Lecture v1 : this.variables()) {
            for (Lecture v2 : this.variables()) {
                Placement p2;
                if (v1.getId() >= v2.getId()) continue;
                Placement p1 = v1.equals(placement.variable()) ? null : assignment.getValue(v1);
                Placement placement2 = p2 = v2.equals(placement.variable()) ? null : assignment.getValue(v2);
                if (p1 != null && p2 != null && !this.isSatisfiedPair(assignment, p1, p2)) {
                    ++nrViolatedPairsBefore;
                }
                if (v1.equals(placement.variable())) {
                    p1 = placement;
                }
                if (v2.equals(placement.variable())) {
                    p2 = placement;
                }
                if (p1 == null || p2 == null || this.isSatisfiedPair(assignment, p1, p2)) continue;
                ++nrViolatedPairsAfter;
            }
        }
        if (this.getType().is(Flag.BACK_TO_BACK)) {
            HashMap<Lecture, Placement> assignments = new HashMap<Lecture, Placement>();
            assignments.put((Lecture)placement.variable(), placement);
            HashSet<Placement> conflicts = new HashSet<Placement>();
            nrViolatedPairsAfter = this.isSatisfiedSeq(assignment, assignments, conflicts) ? (nrViolatedPairsAfter += conflicts.size()) : this.variables().size();
            HashMap<Lecture, Placement> unassignments = new HashMap<Lecture, Placement>();
            unassignments.put((Lecture)placement.variable(), (Placement)null);
            HashSet<Placement> previous = new HashSet<Placement>();
            nrViolatedPairsBefore = this.isSatisfiedSeq(assignment, unassignments, previous) ? (nrViolatedPairsBefore += previous.size()) : this.variables().size();
        }
        return (nrViolatedPairsAfter > 0 ? Math.abs(this.iPreference) * nrViolatedPairsAfter : -Math.abs(this.iPreference)) - (nrViolatedPairsBefore > 0 ? Math.abs(this.iPreference) * nrViolatedPairsBefore : -Math.abs(this.iPreference));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        sb.append(" between ");
        Iterator e = this.variables().iterator();
        while (e.hasNext()) {
            Lecture v = (Lecture)e.next();
            sb.append(v.getName());
            if (!e.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    @Override
    public boolean isHard() {
        return this.iIsRequired || this.iIsProhibited;
    }

    @Override
    public String getName() {
        return this.getType().getName();
    }

    private boolean isPrecedence(Placement p1, Placement p2, boolean firstGoesFirst, boolean considerDatePatterns) {
        int ord1 = this.variables().indexOf(p1.variable());
        int ord2 = this.variables().indexOf(p2.variable());
        TimeLocation t1 = null;
        TimeLocation t2 = null;
        if (ord1 < ord2) {
            if (firstGoesFirst) {
                t1 = p1.getTimeLocation();
                t2 = p2.getTimeLocation();
            } else {
                t2 = p1.getTimeLocation();
                t1 = p2.getTimeLocation();
            }
        } else if (!firstGoesFirst) {
            t1 = p1.getTimeLocation();
            t2 = p2.getTimeLocation();
        } else {
            t2 = p1.getTimeLocation();
            t1 = p2.getTimeLocation();
        }
        if (considerDatePatterns && this.iPrecedenceConsiderDatePatterns) {
            int m2;
            int m1;
            boolean sameDatePattern;
            boolean bl = sameDatePattern = t1.getDatePatternId() != null ? t1.getDatePatternId().equals(t2.getDatePatternId()) : t1.getWeekCode().equals(t2.getWeekCode());
            if (!sameDatePattern && (m1 = t1.getFirstMeeting(this.iDayOfWeekOffset)) != (m2 = t2.getFirstMeeting(this.iDayOfWeekOffset))) {
                return m1 < m2;
            }
        }
        if (this.iFirstWorkDay != 0) {
            for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
                boolean b;
                int idx = (i + this.iFirstWorkDay) % 7;
                boolean a = (t1.getDayCode() & Constants.DAY_CODES[idx]) != 0;
                boolean bl = b = (t2.getDayCode() & Constants.DAY_CODES[idx]) != 0;
                if (b && !a) {
                    return false;
                }
                if (a && !b) {
                    return true;
                }
                if (!a || !b) continue;
                return t1.getStartSlot() + t1.getLength() <= t2.getStartSlot();
            }
        }
        return (Integer)t1.getStartSlots().nextElement() + t1.getLength() <= (Integer)t2.getStartSlots().nextElement();
    }

    private boolean isBackToBackDays(TimeLocation t1, TimeLocation t2) {
        int f1 = -1;
        int f2 = -1;
        int e1 = -1;
        int e2 = -1;
        for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
            int idx = (i + this.iFirstWorkDay) % 7;
            if ((t1.getDayCode() & Constants.DAY_CODES[idx]) != 0) {
                if (f1 < 0) {
                    f1 = i;
                }
                e1 = i;
            }
            if ((t2.getDayCode() & Constants.DAY_CODES[idx]) == 0) continue;
            if (f2 < 0) {
                f2 = i;
            }
            e2 = i;
        }
        return e1 + 1 == f2 || e2 + 1 == f1;
    }

    private boolean isNrDaysBetweenGreaterThanOne(TimeLocation t1, TimeLocation t2) {
        int f1 = -1;
        int f2 = -1;
        int e1 = -1;
        int e2 = -1;
        for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
            int idx = (i + this.iFirstWorkDay) % 7;
            if ((t1.getDayCode() & Constants.DAY_CODES[idx]) != 0) {
                if (f1 < 0) {
                    f1 = i;
                }
                e1 = i;
            }
            if ((t2.getDayCode() & Constants.DAY_CODES[idx]) == 0) continue;
            if (f2 < 0) {
                f2 = i;
            }
            e2 = i;
        }
        return e1 - f2 > 2 || e2 - f1 > 2;
    }

    private boolean isFollowingDay(Placement p1, Placement p2, boolean firstGoesFirst) {
        int ord1 = this.variables().indexOf(p1.variable());
        int ord2 = this.variables().indexOf(p2.variable());
        TimeLocation t1 = null;
        TimeLocation t2 = null;
        if (ord1 < ord2) {
            if (firstGoesFirst) {
                t1 = p1.getTimeLocation();
                t2 = p2.getTimeLocation();
            } else {
                t2 = p1.getTimeLocation();
                t1 = p2.getTimeLocation();
            }
        } else if (!firstGoesFirst) {
            t1 = p1.getTimeLocation();
            t2 = p2.getTimeLocation();
        } else {
            t2 = p1.getTimeLocation();
            t1 = p2.getTimeLocation();
        }
        int f1 = -1;
        int f2 = -1;
        int e1 = -1;
        for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
            int idx = (i + this.iFirstWorkDay) % 7;
            if ((t1.getDayCode() & Constants.DAY_CODES[idx]) != 0) {
                if (f1 < 0) {
                    f1 = i;
                }
                e1 = i;
            }
            if ((t2.getDayCode() & Constants.DAY_CODES[idx]) == 0 || f2 >= 0) continue;
            f2 = i;
        }
        return (e1 + 1) % this.iNrWorkDays == f2;
    }

    private boolean isEveryOtherDay(Placement p1, Placement p2, boolean firstGoesFirst) {
        int ord1 = this.variables().indexOf(p1.variable());
        int ord2 = this.variables().indexOf(p2.variable());
        TimeLocation t1 = null;
        TimeLocation t2 = null;
        if (ord1 < ord2) {
            if (firstGoesFirst) {
                t1 = p1.getTimeLocation();
                t2 = p2.getTimeLocation();
            } else {
                t2 = p1.getTimeLocation();
                t1 = p2.getTimeLocation();
            }
        } else if (!firstGoesFirst) {
            t1 = p1.getTimeLocation();
            t2 = p2.getTimeLocation();
        } else {
            t2 = p1.getTimeLocation();
            t1 = p2.getTimeLocation();
        }
        int f1 = -1;
        int f2 = -1;
        int e1 = -1;
        for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
            int idx = (i + this.iFirstWorkDay) % 7;
            if ((t1.getDayCode() & Constants.DAY_CODES[idx]) != 0) {
                if (f1 < 0) {
                    f1 = i;
                }
                e1 = i;
            }
            if ((t2.getDayCode() & Constants.DAY_CODES[idx]) == 0 || f2 >= 0) continue;
            f2 = i;
        }
        return (e1 + 2) % this.iNrWorkDays == f2;
    }

    private static boolean sameDays(int[] days1, int[] days2) {
        if (days2.length < days1.length) {
            return GroupConstraint.sameDays(days2, days1);
        }
        int i2 = 0;
        for (int i1 = 0; i1 < days1.length; ++i1) {
            block4: {
                int d1 = days1[i1];
                do {
                    if (i2 == days2.length) {
                        return false;
                    }
                    int d2 = days2[i2];
                    if (d1 == d2) break block4;
                } while (++i2 != days2.length);
                return false;
            }
            ++i2;
        }
        return true;
    }

    private static boolean sameRoomAndOverlaps(Placement p1, Placement p2) {
        return p1.shareRooms(p2) && p1.getTimeLocation() != null && p2.getTimeLocation() != null && p1.getTimeLocation().hasIntersection(p2.getTimeLocation());
    }

    private static boolean sameHours(int start1, int len1, int start2, int len2) {
        if (len1 > len2) {
            return GroupConstraint.sameHours(start2, len2, start1, len1);
        }
        return (start1 %= 288) >= (start2 %= 288) && start1 + len1 <= start2 + len2;
    }

    private static boolean canFill(int totalGap, int gapMin, int gapMax, List<Integer> lengths) {
        if (gapMin <= totalGap && totalGap <= gapMax) {
            return true;
        }
        if (totalGap < 2 * gapMin) {
            return false;
        }
        for (int i = 0; i < lengths.size(); ++i) {
            int length = lengths.get(i);
            lengths.remove(i);
            for (int gap = gapMin; gap <= gapMax; ++gap) {
                if (!GroupConstraint.canFill(totalGap - gap - length, gapMin, gapMax, lengths)) continue;
                return true;
            }
            lengths.add(i, length);
        }
        return false;
    }

    private boolean isSatisfiedSeq(Assignment<Lecture, Placement> assignment, HashMap<Lecture, Placement> assignments, Set<Placement> conflicts) {
        if (conflicts == null) {
            return this.isSatisfiedSeqCheck(assignment, assignments, conflicts);
        }
        Set<Placement> bestConflicts = this.isSatisfiedRecursive(assignment, 0, assignments, conflicts, new HashSet<Placement>(), null);
        if (bestConflicts == null) {
            return false;
        }
        conflicts.addAll(bestConflicts);
        return true;
    }

    private Set<Placement> isSatisfiedRecursive(Assignment<Lecture, Placement> assignment, int idx, HashMap<Lecture, Placement> assignments, Set<Placement> conflicts, Set<Placement> newConflicts, Set<Placement> bestConflicts) {
        if (idx == this.variables().size() && newConflicts.isEmpty()) {
            return bestConflicts;
        }
        if (this.isSatisfiedSeqCheck(assignment, assignments, conflicts)) {
            if (bestConflicts == null) {
                return new HashSet<Placement>(newConflicts);
            }
            int b = 0;
            int n = 0;
            for (Placement value : assignments.values()) {
                if (value != null && bestConflicts.contains(value)) {
                    ++b;
                }
                if (value == null || !newConflicts.contains(value)) continue;
                ++n;
            }
            if (n < b || n == b && newConflicts.size() < bestConflicts.size()) {
                return new HashSet<Placement>(newConflicts);
            }
            return bestConflicts;
        }
        if (idx == this.variables().size()) {
            return bestConflicts;
        }
        bestConflicts = this.isSatisfiedRecursive(assignment, idx + 1, assignments, conflicts, newConflicts, bestConflicts);
        Lecture lecture = (Lecture)this.variables().get(idx);
        Placement placement = null;
        if (assignments != null && assignments.containsKey(lecture)) {
            placement = assignments.get(lecture);
        } else if (assignment != null) {
            placement = assignment.getValue(lecture);
        }
        if (placement == null) {
            return bestConflicts;
        }
        if (conflicts != null && conflicts.contains(placement)) {
            return bestConflicts;
        }
        conflicts.add(placement);
        newConflicts.add(placement);
        bestConflicts = this.isSatisfiedRecursive(assignment, idx + 1, assignments, conflicts, newConflicts, bestConflicts);
        newConflicts.remove(placement);
        conflicts.remove(placement);
        return bestConflicts;
    }

    private boolean isSatisfiedSeqCheck(Assignment<Lecture, Placement> assignment, HashMap<Lecture, Placement> assignments, Set<Placement> conflicts) {
        block23: {
            Placement p;
            int nrLectures;
            Placement[] res;
            ArrayList<Integer> lengths;
            int gapMax;
            int gapMin;
            block24: {
                if (!this.getType().is(Flag.BACK_TO_BACK)) {
                    return true;
                }
                gapMin = this.getType().getMin();
                gapMax = this.getType().getMax();
                lengths = new ArrayList<Integer>();
                res = new Placement[288];
                for (int i = 0; i < 288; ++i) {
                    res[i] = null;
                }
                nrLectures = 0;
                for (Lecture lecture : this.variables()) {
                    int j;
                    Placement placement = null;
                    if (assignments != null && assignments.containsKey(lecture)) {
                        placement = assignments.get(lecture);
                    } else if (assignment != null) {
                        placement = assignment.getValue(lecture);
                    }
                    if (placement == null) {
                        if (lecture.timeLocations().isEmpty()) continue;
                        lengths.add(lecture.timeLocations().get(0).getLength());
                        continue;
                    }
                    if (conflicts != null && conflicts.contains(placement)) {
                        if (lecture.timeLocations().isEmpty()) continue;
                        lengths.add(lecture.timeLocations().get(0).getLength());
                        continue;
                    }
                    int pos = placement.getTimeLocation().getStartSlot();
                    int length = placement.getTimeLocation().getLength();
                    for (j = pos; j < pos + length; ++j) {
                        if (res[j] == null) continue;
                        if (conflicts == null) {
                            return false;
                        }
                        if (!assignments.containsKey(lecture)) {
                            conflicts.add(placement);
                            continue;
                        }
                        if (assignments.containsKey(res[j].variable())) continue;
                        conflicts.add(res[j]);
                    }
                    for (j = pos; j < pos + length; ++j) {
                        res[j] = placement;
                    }
                    ++nrLectures;
                }
                if (nrLectures <= 1) {
                    return true;
                }
                if (!this.iIsRequired && (this.iIsProhibited || this.iPreference >= 0)) break block24;
                int i = 0;
                p = res[i];
                while (p == null) {
                    p = res[++i];
                }
                i = res[i].getTimeLocation().getStartSlot() + res[i].getTimeLocation().getLength();
                --nrLectures;
                while (nrLectures > 0) {
                    int gap = 0;
                    while (i < 288 && res[i] == null) {
                        ++gap;
                        ++i;
                    }
                    if (i != 288) {
                        if (!GroupConstraint.canFill(gap, gapMin, gapMax, lengths)) {
                            return false;
                        }
                        p = res[i];
                        i = res[i].getTimeLocation().getStartSlot() + res[i].getTimeLocation().getLength();
                        --nrLectures;
                        continue;
                    }
                    break block23;
                }
                break block23;
            }
            if (!this.iIsProhibited && (this.iIsRequired || this.iPreference <= 0)) break block23;
            int i = 0;
            p = res[i];
            while (p == null) {
                p = res[++i];
            }
            i = res[i].getTimeLocation().getStartSlot() + res[i].getTimeLocation().getLength();
            --nrLectures;
            while (nrLectures > 0) {
                int gap = 0;
                while (i < 288 && res[i] == null) {
                    ++gap;
                    ++i;
                }
                if (i != 288) {
                    if (!(gapMin != 0 && GroupConstraint.canFill(gap, 0, gapMin - 1, lengths) || gapMax < 288 && GroupConstraint.canFill(gap, gapMax + 1, 288, lengths))) {
                        return false;
                    }
                    p = res[i];
                    i = res[i].getTimeLocation().getStartSlot() + res[i].getTimeLocation().getLength();
                    --nrLectures;
                    continue;
                }
                break;
            }
        }
        return true;
    }

    public boolean isSatisfied(Assignment<Lecture, Placement> assignment) {
        if (this.isHard()) {
            return true;
        }
        if (this.countAssignedVariables(assignment) < 2) {
            return true;
        }
        if (this.getPreference() == 0) {
            return true;
        }
        return this.isHard() || this.countAssignedVariables(assignment) < 2 || this.getPreference() == 0 || this.getCurrentPreference(assignment) < 0;
    }

    public boolean isChildrenNotOverlap(Assignment<Lecture, Placement> assignment, Lecture lec1, Placement plc1, Lecture lec2, Placement plc2) {
        if (lec1.getSchedulingSubpartId().equals(lec2.getSchedulingSubpartId())) {
            boolean overlap = plc1.getTimeLocation().hasIntersection(plc2.getTimeLocation());
            if (overlap && lec1.getParent() != null && this.variables().contains(lec1.getParent()) && lec2.getParent() != null && this.variables().contains(lec2.getParent())) {
                Placement p1 = assignment.getValue(lec1.getParent());
                Placement p2 = assignment.getValue(lec2.getParent());
                if (p1 != null && p2 != null && !p1.getTimeLocation().hasIntersection(p2.getTimeLocation())) {
                    return false;
                }
            }
            if (!overlap && lec1.getChildrenSubpartIds() != null && lec2.getChildrenSubpartIds() != null) {
                for (Long subpartId : lec1.getChildrenSubpartIds()) {
                    for (Lecture c1 : lec1.getChildren(subpartId)) {
                        Placement p1 = assignment.getValue(c1);
                        if (p1 == null) continue;
                        for (Lecture c2 : lec2.getChildren(subpartId)) {
                            Placement p2 = assignment.getValue(c2);
                            if (p2 == null || !c1.getSchedulingSubpartId().equals(c2.getSchedulingSubpartId()) || !p1.getTimeLocation().hasIntersection(p2.getTimeLocation())) continue;
                            return false;
                        }
                    }
                }
            }
        }
        return true;
    }

    public boolean isSatisfiedPair(Assignment<Lecture, Placement> assignment, Placement plc1, Placement plc2) {
        if (this.iIsRequired || !this.iIsProhibited && this.iPreference <= 0) {
            return this.getType().isSatisfied(assignment, this, plc1, plc2);
        }
        if (this.iIsProhibited || !this.iIsRequired && this.iPreference > 0) {
            return this.getType().isViolated(assignment, this, plc1, plc2);
        }
        return true;
    }

    public boolean canShareRoom() {
        return this.getType().is(Flag.CAN_SHARE_ROOM);
    }

    protected int nrSlotsADay(Assignment<Lecture, Placement> assignment, int dayCode, BitSet week, HashMap<Lecture, Placement> assignments, Set<Placement> conflicts) {
        HashSet<Integer> slots = new HashSet<Integer>();
        for (Lecture lecture : this.variables()) {
            TimeLocation t;
            Placement placement = null;
            if (assignments != null && assignments.containsKey(lecture)) {
                placement = assignments.get(lecture);
            } else if (assignment != null) {
                placement = assignment.getValue(lecture);
            }
            if (placement == null || placement.getTimeLocation() == null || conflicts != null && conflicts.contains(placement) || (t = placement.getTimeLocation()) == null || (t.getDayCode() & dayCode) == 0 || week != null && !t.shareWeeks(week)) continue;
            for (int i = 0; i < t.getLength(); ++i) {
                slots.add(i + t.getStartSlot());
            }
        }
        return slots.size();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof GroupConstraint)) {
            return false;
        }
        return this.getGeneratedId() == ((GroupConstraint)o).getGeneratedId();
    }

    @Override
    public GroupConstraintContext createAssignmentContext(Assignment<Lecture, Placement> assignment) {
        return new GroupConstraintContext(assignment);
    }

    private boolean isBackToBackWeeks(TimeLocation t1, TimeLocation t2) {
        if (t1.shareWeeks(t2)) {
            return false;
        }
        int f1 = t1.getWeekCode().nextSetBit(0);
        int e1 = t1.getWeekCode().previousSetBit(t1.getWeekCode().size());
        int f2 = t2.getWeekCode().nextSetBit(0);
        int e2 = t2.getWeekCode().previousSetBit(t2.getWeekCode().size());
        if (e1 < f2) {
            return f2 - e1 < 7;
        }
        if (e2 < f1) {
            return f1 - e2 < 7;
        }
        return false;
    }

    private boolean isMaxWeekSpan(TimeLocation t1, TimeLocation t2, int nrWeeks) {
        if (t1.shareWeeks(t2)) {
            return false;
        }
        if (this.isBackToBackWeeks(t1, t2)) {
            return true;
        }
        int f1 = t1.getWeekCode().nextSetBit(0);
        int e1 = t1.getWeekCode().previousSetBit(t1.getWeekCode().size());
        int f2 = t2.getWeekCode().nextSetBit(0);
        int e2 = t2.getWeekCode().previousSetBit(t2.getWeekCode().size());
        if (e1 < f2) {
            return (3 + e2 - f1) / 7 <= nrWeeks;
        }
        if (e2 < f1) {
            return (3 + e1 - f2) / 7 <= nrWeeks;
        }
        return false;
    }

    private boolean isNotBackToBackWeeks(TimeLocation t1, TimeLocation t2) {
        if (t1.shareWeeks(t2)) {
            return false;
        }
        int f1 = t1.getWeekCode().nextSetBit(0);
        int e1 = t1.getWeekCode().previousSetBit(t1.getWeekCode().size());
        int f2 = t2.getWeekCode().nextSetBit(0);
        int e2 = t2.getWeekCode().previousSetBit(t2.getWeekCode().size());
        if (e1 < f2) {
            return f2 - e1 >= 7;
        }
        if (e2 < f1) {
            return f1 - e2 >= 7;
        }
        return false;
    }

    private boolean isFollowingWeeksBTB(Placement p1, Placement p2, boolean btb) {
        int s2;
        TimeLocation t2;
        TimeLocation t1;
        int ord1 = this.variables().indexOf(p1.variable());
        int ord2 = this.variables().indexOf(p2.variable());
        boolean following = false;
        if (ord1 < ord2) {
            t1 = p1.getTimeLocation();
            t2 = p2.getTimeLocation();
            if (ord1 + 1 == ord2) {
                following = true;
            }
        } else {
            t2 = p1.getTimeLocation();
            t1 = p2.getTimeLocation();
            if (ord2 + 1 == ord1) {
                following = true;
            }
        }
        if (t1.shareWeeks(t2)) {
            return false;
        }
        int e1 = t1.getWeekCode().previousSetBit(t1.getWeekCode().size());
        if (e1 >= (s2 = t2.getWeekCode().nextSetBit(0))) {
            return false;
        }
        if (!btb) {
            return s2 - e1 >= 7;
        }
        if (following) {
            return s2 - e1 < 7;
        }
        return true;
    }

    private boolean isDifferentDates(TimeLocation t1, TimeLocation t2) {
        if (!t1.shareDays(t2) || !t1.shareWeeks(t2)) {
            return true;
        }
        TimeLocation.IntEnumeration e = t1.getDates(this.iDayOfWeekOffset);
        while (e.hasMoreElements()) {
            Integer date = (Integer)e.nextElement();
            if (!t2.hasDate(date, this.iDayOfWeekOffset)) continue;
            return false;
        }
        return true;
    }

    private boolean isSameDates(TimeLocation t1, TimeLocation t2) {
        if (!t1.shareDays(t2) || !t1.shareWeeks(t2)) {
            return false;
        }
        if (t1.countDates(this.iDayOfWeekOffset) > t2.countDates(this.iDayOfWeekOffset)) {
            TimeLocation t = t1;
            t1 = t2;
            t2 = t;
        }
        TimeLocation.IntEnumeration e = t1.getDates(this.iDayOfWeekOffset);
        while (e.hasMoreElements()) {
            Integer date = (Integer)e.nextElement();
            if (t2.hasDate(date, this.iDayOfWeekOffset)) continue;
            return false;
        }
        return true;
    }

    public class GroupConstraintContext
    implements AssignmentConstraintContext<Lecture, Placement> {
        protected int iLastPreference = 0;

        public GroupConstraintContext(Assignment<Lecture, Placement> assignment) {
            this.updateCriterion(assignment);
        }

        @Override
        public void assigned(Assignment<Lecture, Placement> assignment, Placement value) {
            this.updateCriterion(assignment);
        }

        @Override
        public void unassigned(Assignment<Lecture, Placement> assignment, Placement value) {
            this.updateCriterion(assignment);
        }

        protected void updateCriterion(Assignment<Lecture, Placement> assignment) {
            if (!GroupConstraint.this.isHard()) {
                GroupConstraint.this.getModel().getCriterion(DistributionPreferences.class).inc(assignment, -this.iLastPreference);
                this.iLastPreference = GroupConstraint.this.getCurrentPreference(assignment) + Math.abs(GroupConstraint.this.iPreference);
                GroupConstraint.this.getModel().getCriterion(DistributionPreferences.class).inc(assignment, this.iLastPreference);
            }
        }

        public int getPreference() {
            return this.iLastPreference;
        }
    }

    public static enum ConstraintType implements ConstraintTypeInterface
    {
        SAME_TIME("SAME_TIME", "Same Time", new PairCheck(){

            @Override
            public boolean isSatisfied(GroupConstraint gc, Placement plc1, Placement plc2) {
                return GroupConstraint.sameHours(plc1.getTimeLocation().getStartSlot(), plc1.getTimeLocation().getLength(), plc2.getTimeLocation().getStartSlot(), plc2.getTimeLocation().getLength());
            }

            @Override
            public boolean isViolated(GroupConstraint gc, Placement plc1, Placement plc2) {
                return !plc1.getTimeLocation().shareHours(plc2.getTimeLocation());
            }
        }, new Flag[0]),
        SAME_DAYS("SAME_DAYS", "Same Days", new PairCheck(){

            @Override
            public boolean isSatisfied(GroupConstraint gc, Placement plc1, Placement plc2) {
                return GroupConstraint.sameDays(plc1.getTimeLocation().getDaysArray(), plc2.getTimeLocation().getDaysArray());
            }

            @Override
            public boolean isViolated(GroupConstraint gc, Placement plc1, Placement plc2) {
                return !plc1.getTimeLocation().shareDays(plc2.getTimeLocation());
            }
        }, new Flag[0]),
        BTB("BTB", "Back-To-Back & Same Room", new PairCheck(){

            @Override
            public boolean isSatisfied(GroupConstraint gc, Placement plc1, Placement plc2) {
                return plc1.sameRooms(plc2) && GroupConstraint.sameDays(plc1.getTimeLocation().getDaysArray(), plc2.getTimeLocation().getDaysArray());
            }

            @Override
            public boolean isViolated(GroupConstraint gc, Placement plc1, Placement plc2) {
                return plc1.sameRooms(plc2) && GroupConstraint.sameDays(plc1.getTimeLocation().getDaysArray(), plc2.getTimeLocation().getDaysArray());
            }
        }, Flag.BACK_TO_BACK),
        BTB_TIME("BTB_TIME", "Back-To-Back", new PairCheck(){

            @Override
            public boolean isSatisfied(GroupConstraint gc, Placement plc1, Placement plc2) {
                return GroupConstraint.sameDays(plc1.getTimeLocation().getDaysArray(), plc2.getTimeLocation().getDaysArray());
            }

            @Override
            public boolean isViolated(GroupConstraint gc, Placement plc1, Placement plc2) {
                return GroupConstraint.sameDays(plc1.getTimeLocation().getDaysArray(), plc2.getTimeLocation().getDaysArray());
            }
        }, Flag.BACK_TO_BACK),
        DIFF_TIME("DIFF_TIME", "Different Time", new PairCheck(){

            @Override
            public boolean isSatisfied(GroupConstraint gc, Placement plc1, Placement plc2) {
                return !plc1.getTimeLocation().hasIntersection(plc2.getTimeLocation());
            }

            @Override
            public boolean isViolated(GroupConstraint gc, Placement plc1, Placement plc2) {
                return plc1.getTimeLocation().hasIntersection(plc2.getTimeLocation());
            }
        }, new Flag[0]),
        NHB_1("NHB(1)", "1 Hour Between", 10, 12, BTB_TIME.check(), Flag.BACK_TO_BACK),
        NHB_2("NHB(2)", "2 Hours Between", 20, 24, BTB_TIME.check(), Flag.BACK_TO_BACK),
        NHB_3("NHB(3)", "3 Hours Between", 30, 36, BTB_TIME.check(), Flag.BACK_TO_BACK),
        NHB_4("NHB(4)", "4 Hours Between", 40, 48, BTB_TIME.check(), Flag.BACK_TO_BACK),
        NHB_5("NHB(5)", "5 Hours Between", 50, 60, BTB_TIME.check(), Flag.BACK_TO_BACK),
        NHB_6("NHB(6)", "6 Hours Between", 60, 72, BTB_TIME.check(), Flag.BACK_TO_BACK),
        NHB_7("NHB(7)", "7 Hours Between", 70, 84, BTB_TIME.check(), Flag.BACK_TO_BACK),
        NHB_8("NHB(8)", "8 Hours Between", 80, 96, BTB_TIME.check(), Flag.BACK_TO_BACK),
        SAME_START("SAME_START", "Same Start Time", new PairCheck(){

            @Override
            public boolean isSatisfied(GroupConstraint gc, Placement plc1, Placement plc2) {
                return plc1.getTimeLocation().getStartSlot() % 288 == plc2.getTimeLocation().getStartSlot() % 288;
            }

            @Override
            public boolean isViolated(GroupConstraint gc, Placement plc1, Placement plc2) {
                return plc1.getTimeLocation().getStartSlot() % 288 != plc2.getTimeLocation().getStartSlot() % 288;
            }
        }, new Flag[0]),
        SAME_ROOM("SAME_ROOM", "Same Room", new PairCheck(){

            @Override
            public boolean isSatisfied(GroupConstraint gc, Placement plc1, Placement plc2) {
                return plc1.sameRooms(plc2);
            }

            @Override
            public boolean isViolated(GroupConstraint gc, Placement plc1, Placement plc2) {
                return !plc1.sameRooms(plc2);
            }
        }, new Flag[0]),
        NHB_GTE_1("NHB_GTE(1)", "At Least 1 Hour Between", 6, 288, BTB_TIME.check(), Flag.BACK_TO_BACK),
        NHB_LT_6("NHB_LT(6)", "Less Than 6 Hours Between", 0, 72, BTB_TIME.check(), Flag.BACK_TO_BACK),
        NHB_1_5("NHB(1.5)", "1.5 Hour Between", 15, 18, BTB_TIME.check(), Flag.BACK_TO_BACK),
        NHB_4_5("NHB(4.5)", "4.5 Hours Between", 45, 54, BTB_TIME.check(), Flag.BACK_TO_BACK),
        SAME_STUDENTS("SAME_STUDENTS", "Same Students", new PairCheck(){

            @Override
            public boolean isSatisfied(GroupConstraint gc, Placement plc1, Placement plc2) {
                return !JenrlConstraint.isInConflict(plc1, plc2, ((TimetableModel)gc.getModel()).getDistanceMetric(), ((TimetableModel)gc.getModel()).getStudentWorkDayLimit());
            }

            @Override
            public boolean isViolated(GroupConstraint gc, Placement plc1, Placement plc2) {
                return true;
            }
        }, new Flag[0]),
        SAME_INSTR("SAME_INSTR", "Same Instructor", new PairCheck(){

            @Override
            public boolean isSatisfied(GroupConstraint gc, Placement plc1, Placement plc2) {
                TimeLocation t2;
                TimeLocation t1 = plc1.getTimeLocation();
                if (t1.shareDays(t2 = plc2.getTimeLocation()) && t1.shareWeeks(t2)) {
                    if (t1.shareHours(t2)) {
                        return false;
                    }
                    DistanceMetric m = ((TimetableModel)gc.getModel()).getDistanceMetric();
                    if (t1.getStartSlot() + t1.getLength() == t2.getStartSlot() || t2.getStartSlot() + t2.getLength() == t1.getStartSlot()) {
                        if (Placement.getDistanceInMeters(m, plc1, plc2) > m.getInstructorProhibitedLimit()) {
                            return false;
                        }
                    } else if (m.doComputeDistanceConflictsBetweenNonBTBClasses()) {
                        if (t1.getStartSlot() + t1.getLength() < t2.getStartSlot() && Placement.getDistanceInMinutes(m, plc1, plc2) > t1.getBreakTime() + Constants.SLOT_LENGTH_MIN * (t2.getStartSlot() - t1.getStartSlot() - t1.getLength())) {
                            return false;
                        }
                        if (t2.getStartSlot() + t2.getLength() < t1.getStartSlot() && Placement.getDistanceInMinutes(m, plc1, plc2) > t2.getBreakTime() + Constants.SLOT_LENGTH_MIN * (t1.getStartSlot() - t2.getStartSlot() - t2.getLength())) {
                            return false;
                        }
                    }
                }
                return true;
            }

            @Override
            public boolean isViolated(GroupConstraint gc, Placement plc1, Placement plc2) {
                return true;
            }
        }, new Flag[0]),
        CAN_SHARE_ROOM("CAN_SHARE_ROOM", "Can Share Room", Flag.CAN_SHARE_ROOM),
        PRECEDENCE("PRECEDENCE", "Precedence", new PairCheck(){

            @Override
            public boolean isSatisfied(GroupConstraint gc, Placement plc1, Placement plc2) {
                return gc.isPrecedence(plc1, plc2, true, true);
            }

            @Override
            public boolean isViolated(GroupConstraint gc, Placement plc1, Placement plc2) {
                return gc.isPrecedence(plc1, plc2, false, true);
            }
        }, new Flag[0]),
        BTB_DAY("BTB_DAY", "Back-To-Back Day", new PairCheck(){

            @Override
            public boolean isSatisfied(GroupConstraint gc, Placement plc1, Placement plc2) {
                return !GroupConstraint.sameDays(plc1.getTimeLocation().getDaysArray(), plc2.getTimeLocation().getDaysArray()) && gc.isBackToBackDays(plc1.getTimeLocation(), plc2.getTimeLocation());
            }

            @Override
            public boolean isViolated(GroupConstraint gc, Placement plc1, Placement plc2) {
                return !GroupConstraint.sameDays(plc1.getTimeLocation().getDaysArray(), plc2.getTimeLocation().getDaysArray()) && !gc.isBackToBackDays(plc1.getTimeLocation(), plc2.getTimeLocation());
            }
        }, new Flag[0]),
        MEET_WITH("MEET_WITH", "Meet Together", new PairCheck(){

            @Override
            public boolean isSatisfied(GroupConstraint gc, Placement plc1, Placement plc2) {
                return plc1.sameRooms(plc2) && GroupConstraint.sameHours(plc1.getTimeLocation().getStartSlot(), plc1.getTimeLocation().getLength(), plc2.getTimeLocation().getStartSlot(), plc2.getTimeLocation().getLength()) && GroupConstraint.sameDays(plc1.getTimeLocation().getDaysArray(), plc2.getTimeLocation().getDaysArray());
            }

            @Override
            public boolean isViolated(GroupConstraint gc, Placement plc1, Placement plc2) {
                return true;
            }
        }, Flag.CAN_SHARE_ROOM),
        NDB_GT_1("NDB_GT_1", "More Than 1 Day Between", new PairCheck(){

            @Override
            public boolean isSatisfied(GroupConstraint gc, Placement plc1, Placement plc2) {
                return !GroupConstraint.sameDays(plc1.getTimeLocation().getDaysArray(), plc2.getTimeLocation().getDaysArray()) && gc.isNrDaysBetweenGreaterThanOne(plc1.getTimeLocation(), plc2.getTimeLocation());
            }

            @Override
            public boolean isViolated(GroupConstraint gc, Placement plc1, Placement plc2) {
                return !GroupConstraint.sameDays(plc1.getTimeLocation().getDaysArray(), plc2.getTimeLocation().getDaysArray()) && !gc.isNrDaysBetweenGreaterThanOne(plc1.getTimeLocation(), plc2.getTimeLocation());
            }
        }, new Flag[0]),
        CH_NOTOVERLAP("CH_NOTOVERLAP", "Children Cannot Overlap", new AssignmentPairCheck(){

            @Override
            public boolean isSatisfied(Assignment<Lecture, Placement> assignment, GroupConstraint gc, Placement plc1, Placement plc2) {
                return gc.isChildrenNotOverlap(assignment, (Lecture)plc1.variable(), plc1, (Lecture)plc2.variable(), plc2);
            }

            @Override
            public boolean isViolated(Assignment<Lecture, Placement> assignment, GroupConstraint gc, Placement plc1, Placement plc2) {
                return true;
            }
        }, new Flag[0]),
        FOLLOWING_DAY("FOLLOWING_DAY", "Next Day", new PairCheck(){

            @Override
            public boolean isSatisfied(GroupConstraint gc, Placement plc1, Placement plc2) {
                return gc.isFollowingDay(plc1, plc2, true);
            }

            @Override
            public boolean isViolated(GroupConstraint gc, Placement plc1, Placement plc2) {
                return gc.isFollowingDay(plc1, plc2, false);
            }
        }, new Flag[0]),
        EVERY_OTHER_DAY("EVERY_OTHER_DAY", "Two Days After", new PairCheck(){

            @Override
            public boolean isSatisfied(GroupConstraint gc, Placement plc1, Placement plc2) {
                return gc.isEveryOtherDay(plc1, plc2, true);
            }

            @Override
            public boolean isViolated(GroupConstraint gc, Placement plc1, Placement plc2) {
                return gc.isEveryOtherDay(plc1, plc2, false);
            }
        }, new Flag[0]),
        MAX_HRS_DAY_3("MAX_HRS_DAY(3)", "At Most 3 Hours A Day", 36, null, Flag.MAX_HRS_DAY),
        MAX_HRS_DAY_4("MAX_HRS_DAY(4)", "At Most 4 Hours A Day", 48, null, Flag.MAX_HRS_DAY),
        MAX_HRS_DAY_5("MAX_HRS_DAY(5)", "At Most 5 Hours A Day", 60, null, Flag.MAX_HRS_DAY),
        MAX_HRS_DAY_6("MAX_HRS_DAY(6)", "At Most 6 Hours A Day", 72, null, Flag.MAX_HRS_DAY),
        MAX_HRS_DAY_7("MAX_HRS_DAY(7)", "At Most 7 Hours A Day", 84, null, Flag.MAX_HRS_DAY),
        MAX_HRS_DAY_8("MAX_HRS_DAY(8)", "At Most 8 Hours A Day", 96, null, Flag.MAX_HRS_DAY),
        MAX_HRS_DAY_9("MAX_HRS_DAY(9)", "At Most 9 Hours A Day", 108, null, Flag.MAX_HRS_DAY),
        MAX_HRS_DAY_10("MAX_HRS_DAY(10)", "At Most 10 Hours A Day", 120, null, Flag.MAX_HRS_DAY),
        MAX_HRS_DAY("MAX_HRS_DAY\\(([0-9\\.]+)\\)", "At Most N Hours A Day", new AssignmentParameterPairCheck<Integer>(){

            @Override
            public boolean isSatisfied(Assignment<Lecture, Placement> assignment, Integer parameter, GroupConstraint gc, Placement plc1, Placement plc2) {
                return true;
            }

            @Override
            public boolean isViolated(Assignment<Lecture, Placement> assignment, Integer parameter, GroupConstraint gc, Placement plc1, Placement plc2) {
                return true;
            }

            @Override
            public ParametrizedConstraintType<Integer> create(String reference, String regexp) {
                Matcher matcher = Pattern.compile(regexp).matcher(reference);
                if (matcher.find()) {
                    double hours = Double.parseDouble(matcher.group(1));
                    int slots = (int)Math.round(12.0 * hours);
                    return new ParametrizedConstraintType<Integer>(MAX_HRS_DAY, slots, reference).setName("At Most " + matcher.group(1) + " Hours A Day").setMin(slots).setMax(slots);
                }
                return null;
            }
        }, Flag.MAX_HRS_DAY),
        SAME_WEEKS("SAME_WEEKS", "Same Weeks", new PairCheck(){

            @Override
            public boolean isSatisfied(GroupConstraint gc, Placement plc1, Placement plc2) {
                return plc1.getTimeLocation().getWeekCode().equals(plc2.getTimeLocation().getWeekCode());
            }

            @Override
            public boolean isViolated(GroupConstraint gc, Placement plc1, Placement plc2) {
                return !plc1.getTimeLocation().shareWeeks(plc2.getTimeLocation());
            }
        }, new Flag[0]),
        LINKED_SECTIONS("LINKED_SECTIONS", "Linked Classes", SAME_STUDENTS.check(), new Flag[0]),
        BTB_PRECEDENCE("BTB_PRECEDENCE", "Back-To-Back Precedence", new PairCheck(){

            @Override
            public boolean isSatisfied(GroupConstraint gc, Placement plc1, Placement plc2) {
                return gc.isPrecedence(plc1, plc2, true, false) && GroupConstraint.sameDays(plc1.getTimeLocation().getDaysArray(), plc2.getTimeLocation().getDaysArray());
            }

            @Override
            public boolean isViolated(GroupConstraint gc, Placement plc1, Placement plc2) {
                return gc.isPrecedence(plc1, plc2, true, false) && GroupConstraint.sameDays(plc1.getTimeLocation().getDaysArray(), plc2.getTimeLocation().getDaysArray());
            }
        }, Flag.BACK_TO_BACK),
        SAME_DAYS_TIME("SAME_D_T", "Same Days-Time", new PairCheck(){

            @Override
            public boolean isSatisfied(GroupConstraint gc, Placement plc1, Placement plc2) {
                return GroupConstraint.sameHours(plc1.getTimeLocation().getStartSlot(), plc1.getTimeLocation().getLength(), plc2.getTimeLocation().getStartSlot(), plc2.getTimeLocation().getLength()) && GroupConstraint.sameDays(plc1.getTimeLocation().getDaysArray(), plc2.getTimeLocation().getDaysArray());
            }

            @Override
            public boolean isViolated(GroupConstraint gc, Placement plc1, Placement plc2) {
                return !plc1.getTimeLocation().shareHours(plc2.getTimeLocation()) || !plc1.getTimeLocation().shareDays(plc2.getTimeLocation());
            }
        }, new Flag[0]),
        SAME_DAYS_ROOM_TIME("SAME_D_R_T", "Same Days-Room-Time", new PairCheck(){

            @Override
            public boolean isSatisfied(GroupConstraint gc, Placement plc1, Placement plc2) {
                return GroupConstraint.sameHours(plc1.getTimeLocation().getStartSlot(), plc1.getTimeLocation().getLength(), plc2.getTimeLocation().getStartSlot(), plc2.getTimeLocation().getLength()) && GroupConstraint.sameDays(plc1.getTimeLocation().getDaysArray(), plc2.getTimeLocation().getDaysArray()) && plc1.sameRooms(plc2);
            }

            @Override
            public boolean isViolated(GroupConstraint gc, Placement plc1, Placement plc2) {
                return !plc1.getTimeLocation().shareHours(plc2.getTimeLocation()) || !plc1.getTimeLocation().shareDays(plc2.getTimeLocation()) || !plc1.sameRooms(plc2);
            }
        }, new Flag[0]),
        WORKDAY_6("WORKDAY(6)", "6 Hour Work Day", 72, new PairCheck(){

            @Override
            public boolean isSatisfied(GroupConstraint gc, Placement plc1, Placement plc2) {
                TimeLocation t1 = plc1.getTimeLocation();
                TimeLocation t2 = plc2.getTimeLocation();
                if (t1 == null || t2 == null || !t1.shareDays(t2) || !t1.shareWeeks(t2)) {
                    return true;
                }
                return Math.max(t1.getStartSlot() + t1.getLength(), t2.getStartSlot() + t2.getLength()) - Math.min(t1.getStartSlot(), t2.getStartSlot()) <= gc.getType().getMax();
            }

            @Override
            public boolean isViolated(GroupConstraint gc, Placement plc1, Placement plc2) {
                return true;
            }
        }, new Flag[0]),
        WORKDAY_7("WORKDAY(7)", "7 Hour Work Day", 84, WORKDAY_6.check(), new Flag[0]),
        WORKDAY_8("WORKDAY(8)", "8 Hour Work Day", 96, WORKDAY_6.check(), new Flag[0]),
        WORKDAY_9("WORKDAY(9)", "9 Hour Work Day", 108, WORKDAY_6.check(), new Flag[0]),
        WORKDAY_10("WORKDAY(10)", "10 Hour Work Day", 120, WORKDAY_6.check(), new Flag[0]),
        WORKDAY_11("WORKDAY(11)", "11 Hour Work Day", 132, WORKDAY_6.check(), new Flag[0]),
        WORKDAY_12("WORKDAY(12)", "12 Hour Work Day", 144, WORKDAY_6.check(), new Flag[0]),
        WORKDAY_4("WORKDAY(4)", "4 Hour Work Day", 48, WORKDAY_6.check(), new Flag[0]),
        WORKDAY_5("WORKDAY(5)", "5 Hour Work Day", 60, WORKDAY_6.check(), new Flag[0]),
        WORKDAY("WORKDAY\\(([0-9\\.]+)\\)", "Work Day", new AssignmentParameterPairCheck<Integer>(){

            @Override
            public boolean isSatisfied(Assignment<Lecture, Placement> assignment, Integer parameter, GroupConstraint gc, Placement plc1, Placement plc2) {
                TimeLocation t1 = plc1.getTimeLocation();
                TimeLocation t2 = plc2.getTimeLocation();
                if (t1 == null || t2 == null || !t1.shareDays(t2) || !t1.shareWeeks(t2)) {
                    return true;
                }
                return Math.max(t1.getStartSlot() + t1.getLength(), t2.getStartSlot() + t2.getLength()) - Math.min(t1.getStartSlot(), t2.getStartSlot()) <= parameter;
            }

            @Override
            public boolean isViolated(Assignment<Lecture, Placement> assignment, Integer parameter, GroupConstraint gc, Placement plc1, Placement plc2) {
                return true;
            }

            @Override
            public ParametrizedConstraintType<Integer> create(String reference, String regexp) {
                Matcher matcher = Pattern.compile(regexp).matcher(reference);
                if (matcher.find()) {
                    double hours = Double.parseDouble(matcher.group(1));
                    int slots = (int)Math.round(12.0 * hours);
                    return new ParametrizedConstraintType<Integer>(WORKDAY, slots, reference).setName(matcher.group(1) + " Hour Work Day").setMin(slots).setMax(slots);
                }
                return null;
            }
        }, new Flag[0]),
        MEET_WITH_WEEKS("MEET_WITH_WEEKS", "Meet Together & Same Weeks", new PairCheck(){

            @Override
            public boolean isSatisfied(GroupConstraint gc, Placement plc1, Placement plc2) {
                return plc1.sameRooms(plc2) && GroupConstraint.sameHours(plc1.getTimeLocation().getStartSlot(), plc1.getTimeLocation().getLength(), plc2.getTimeLocation().getStartSlot(), plc2.getTimeLocation().getLength()) && GroupConstraint.sameDays(plc1.getTimeLocation().getDaysArray(), plc2.getTimeLocation().getDaysArray()) && plc1.getTimeLocation().getWeekCode().equals(plc2.getTimeLocation().getWeekCode());
            }

            @Override
            public boolean isViolated(GroupConstraint gc, Placement plc1, Placement plc2) {
                return true;
            }
        }, Flag.CAN_SHARE_ROOM),
        MIN_GAP("MIN_GAP\\(([0-9\\.]+)\\)", "Mininal Gap Between Classes", new AssignmentParameterPairCheck<Integer>(){

            @Override
            public boolean isSatisfied(Assignment<Lecture, Placement> assignment, Integer parameter, GroupConstraint gc, Placement plc1, Placement plc2) {
                TimeLocation t1 = plc1.getTimeLocation();
                TimeLocation t2 = plc2.getTimeLocation();
                if (t1 == null || t2 == null || !t1.shareDays(t2) || !t1.shareWeeks(t2)) {
                    return true;
                }
                return t1.getStartSlot() + t1.getLength() + parameter <= t2.getStartSlot() || t2.getStartSlot() + t2.getLength() + parameter <= t1.getStartSlot();
            }

            @Override
            public boolean isViolated(Assignment<Lecture, Placement> assignment, Integer parameter, GroupConstraint gc, Placement plc1, Placement plc2) {
                return true;
            }

            @Override
            public ParametrizedConstraintType<Integer> create(String reference, String regexp) {
                Matcher matcher = Pattern.compile(regexp).matcher(reference);
                if (matcher.find()) {
                    double hours = Double.parseDouble(matcher.group(1));
                    int slots = (int)Math.round(12.0 * hours);
                    return new ParametrizedConstraintType<Integer>(MIN_GAP, slots, reference).setName("At Least " + matcher.group(1) + " Hours Between Classes").setMin(slots).setMax(slots);
                }
                return null;
            }
        }, new Flag[0]),
        BTB_WEEKS("BTB_WEEKS", "Back-To-Back Weeks", new PairCheck(){

            @Override
            public boolean isSatisfied(GroupConstraint gc, Placement plc1, Placement plc2) {
                if (gc.variables().size() <= 2) {
                    return gc.isBackToBackWeeks(plc1.getTimeLocation(), plc2.getTimeLocation());
                }
                int totalWeeks = 0;
                for (Lecture l : gc.variables()) {
                    totalWeeks += l.getMinWeeks();
                }
                return gc.isMaxWeekSpan(plc1.getTimeLocation(), plc2.getTimeLocation(), totalWeeks);
            }

            @Override
            public boolean isViolated(GroupConstraint gc, Placement plc1, Placement plc2) {
                return gc.isNotBackToBackWeeks(plc1.getTimeLocation(), plc2.getTimeLocation());
            }
        }, new Flag[0]),
        FOLLOWING_WEEKS("FOLLOWING_WEEKS", "Following Weeks", new PairCheck(){

            @Override
            public boolean isSatisfied(GroupConstraint gc, Placement plc1, Placement plc2) {
                return gc.isFollowingWeeksBTB(plc1, plc2, true);
            }

            @Override
            public boolean isViolated(GroupConstraint gc, Placement plc1, Placement plc2) {
                return gc.isFollowingWeeksBTB(plc1, plc2, false);
            }
        }, new Flag[0]),
        SAME_DATES("SAME_DATES", "Same Dates", new PairCheck(){

            @Override
            public boolean isSatisfied(GroupConstraint gc, Placement plc1, Placement plc2) {
                return gc.isSameDates(plc1.getTimeLocation(), plc2.getTimeLocation());
            }

            @Override
            public boolean isViolated(GroupConstraint gc, Placement plc1, Placement plc2) {
                return gc.isDifferentDates(plc1.getTimeLocation(), plc2.getTimeLocation());
            }
        }, new Flag[0]);

        String iReference;
        String iName;
        int iFlag = 0;
        Flag[] iFlags = null;
        int iMin = 0;
        int iMax = 0;
        PairCheck iCheck = null;
        AssignmentPairCheck iAssignmentCheck = null;
        AssignmentParameterPairCheck<?> iAssignmentPairCheck = null;

        private ConstraintType(String reference, String name, Flag ... flags) {
            this.iReference = reference;
            this.iName = name;
            this.iFlags = flags;
            for (Flag f : flags) {
                this.iFlag |= f.flag();
            }
        }

        private ConstraintType(String reference, String name, PairCheck check, Flag ... flags) {
            this(reference, name, flags);
            this.iCheck = check;
        }

        private ConstraintType(String reference, String name, AssignmentPairCheck check, Flag ... flags) {
            this(reference, name, flags);
            this.iAssignmentCheck = check;
        }

        private ConstraintType(String reference, String name, int limit, PairCheck check, Flag ... flags) {
            this(reference, name, check, flags);
            this.iMin = this.iMax = limit;
        }

        private ConstraintType(String reference, String name, int min, int max, PairCheck check, Flag ... flags) {
            this(reference, name, check, flags);
            this.iMin = min;
            this.iMax = max;
        }

        private ConstraintType(String reference, String name, AssignmentParameterPairCheck<?> check, Flag ... flags) {
            this(reference, name, flags);
            this.iAssignmentPairCheck = check;
        }

        @Override
        public ConstraintType type() {
            return this;
        }

        @Override
        public String reference() {
            return this.iReference;
        }

        @Override
        public String getName() {
            return this.iName;
        }

        @Override
        public int getMin() {
            return this.iMin;
        }

        @Override
        public int getMax() {
            return this.iMax;
        }

        @Override
        public boolean is(Flag f) {
            return (this.iFlag & f.flag()) != 0;
        }

        @Deprecated
        public static ConstraintType get(String reference) {
            for (ConstraintType t : ConstraintType.values()) {
                if (!t.reference().equals(reference)) continue;
                return t;
            }
            return null;
        }

        @Override
        public boolean isSatisfied(Assignment<Lecture, Placement> assignment, GroupConstraint gc, Placement plc1, Placement plc2) {
            if (this.iCheck != null && !this.iCheck.isSatisfied(gc, plc1, plc2)) {
                return false;
            }
            return this.iAssignmentCheck == null || assignment == null || this.iAssignmentCheck.isSatisfied(assignment, gc, plc1, plc2);
        }

        @Override
        public boolean isViolated(Assignment<Lecture, Placement> assignment, GroupConstraint gc, Placement plc1, Placement plc2) {
            if (this.iCheck != null && !this.iCheck.isViolated(gc, plc1, plc2)) {
                return false;
            }
            return this.iAssignmentCheck == null || assignment == null || this.iAssignmentCheck.isViolated(assignment, gc, plc1, plc2);
        }

        private PairCheck check() {
            return this.iCheck;
        }
    }

    public static class ParametrizedConstraintType<P>
    implements ConstraintTypeInterface {
        private String iReference;
        private ConstraintType iType;
        private Integer iMin = null;
        private Integer iMax = null;
        private String iName = null;
        private P iParameter;

        public ParametrizedConstraintType(ConstraintType type, P parameter, String reference) {
            this.iType = type;
            this.iParameter = parameter;
            this.iReference = reference;
        }

        @Override
        public boolean isSatisfied(Assignment<Lecture, Placement> assignment, GroupConstraint gc, Placement plc1, Placement plc2) {
            return this.iType.iAssignmentPairCheck.isSatisfied(assignment, this.iParameter, gc, plc1, plc2);
        }

        @Override
        public boolean isViolated(Assignment<Lecture, Placement> assignment, GroupConstraint gc, Placement plc1, Placement plc2) {
            return this.iType.iAssignmentPairCheck.isViolated(assignment, this.iParameter, gc, plc1, plc2);
        }

        public P getParameter() {
            return this.iParameter;
        }

        @Override
        public ConstraintType type() {
            return this.iType;
        }

        @Override
        public String reference() {
            return this.iReference;
        }

        @Override
        public String getName() {
            return this.iName == null ? this.iType.getName() : this.iName;
        }

        @Override
        public int getMin() {
            return this.iMin == null ? this.iType.getMin() : this.iMin.intValue();
        }

        @Override
        public int getMax() {
            return this.iMax == null ? this.iType.getMax() : this.iMax.intValue();
        }

        @Override
        public boolean is(Flag f) {
            return this.iType.is(f);
        }

        public ParametrizedConstraintType<P> setMin(int min) {
            this.iMin = min;
            return this;
        }

        public ParametrizedConstraintType<P> setMax(int max) {
            this.iMax = max;
            return this;
        }

        public ParametrizedConstraintType<P> setName(String name) {
            this.iName = name;
            return this;
        }
    }

    public static interface ConstraintTypeInterface
    extends AssignmentPairCheck {
        public ConstraintType type();

        public String reference();

        public String getName();

        public int getMin();

        public int getMax();

        public boolean is(Flag var1);
    }

    public static enum Flag {
        BACK_TO_BACK,
        CAN_SHARE_ROOM,
        MAX_HRS_DAY,
        CH_NOTOVERLAP;


        int flag() {
            return 1 << this.ordinal();
        }
    }

    public static interface AssignmentParameterPairCheck<P> {
        public boolean isSatisfied(Assignment<Lecture, Placement> var1, P var2, GroupConstraint var3, Placement var4, Placement var5);

        public boolean isViolated(Assignment<Lecture, Placement> var1, P var2, GroupConstraint var3, Placement var4, Placement var5);

        public ParametrizedConstraintType<P> create(String var1, String var2);
    }

    public static interface AssignmentPairCheck {
        public boolean isSatisfied(Assignment<Lecture, Placement> var1, GroupConstraint var2, Placement var3, Placement var4);

        public boolean isViolated(Assignment<Lecture, Placement> var1, GroupConstraint var2, Placement var3, Placement var4);
    }

    public static interface PairCheck {
        public boolean isSatisfied(GroupConstraint var1, Placement var2, Placement var3);

        public boolean isViolated(GroupConstraint var1, Placement var2, Placement var3);
    }
}

