/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.constraint;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.constraint.BreakFlexibleConstraint;
import org.cpsolver.coursett.constraint.MaxBlockFlexibleConstraint;
import org.cpsolver.coursett.constraint.MaxBreaksFlexibleConstraint;
import org.cpsolver.coursett.constraint.MaxDaysFlexibleConstraint;
import org.cpsolver.coursett.constraint.MaxHalfDaysFlexibleConstraint;
import org.cpsolver.coursett.constraint.MaxHolesFlexibleConstraint;
import org.cpsolver.coursett.constraint.MaxWeeksFlexibleConstraint;
import org.cpsolver.coursett.criteria.FlexibleConstraintCriterion;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AssignmentConstraintContext;
import org.cpsolver.ifs.assignment.context.ConstraintWithContext;
import org.cpsolver.ifs.criteria.Criterion;

public abstract class FlexibleConstraint
extends ConstraintWithContext<Lecture, Placement, FlexibleConstraintContext> {
    protected int iPreference;
    private boolean iIsRequired;
    private String iOwner;
    protected FlexibleConstraintType iConstraintType = null;
    protected String iReference = "";
    protected List<BitSet> iWeeks = null;

    public FlexibleConstraint(Long id, String owner, String preference, String reference) {
        this.iId = id;
        this.iReference = reference;
        this.iPreference = Constants.preference2preferenceLevel(preference);
        this.iIsRequired = preference.equals("R");
        this.iOwner = owner;
    }

    public abstract double getNrViolations(Assignment<Lecture, Placement> var1, Set<Placement> var2, HashMap<Lecture, Placement> var3);

    public List<BitSet> getWeeks() {
        if (this.iWeeks == null) {
            TimetableModel model = (TimetableModel)this.getModel();
            this.iWeeks = new ArrayList<BitSet>();
            boolean checkWeeks = model.getProperties().getPropertyBoolean("FlexibleConstraint.CheckWeeks", false);
            if (checkWeeks) {
                this.iWeeks = model.getWeeks();
            } else {
                this.iWeeks.add(null);
            }
        }
        return this.iWeeks;
    }

    @Override
    public boolean isConsistent(Placement value1, Placement value2) {
        HashMap<Lecture, Placement> assignments = new HashMap<Lecture, Placement>();
        if (value1 != null) {
            assignments.put((Lecture)value1.variable(), value1);
        }
        if (value2 != null) {
            assignments.put((Lecture)value2.variable(), value2);
        }
        if (this.getNrViolations(null, null, assignments) != 0.0) {
            return false;
        }
        return super.isConsistent(value1, value2);
    }

    protected Set<Placement> getRelevantPlacements(Assignment<Lecture, Placement> assignment, int dayCode, Set<Placement> conflicts, Placement value, HashMap<Lecture, Placement> assignments, BitSet week) {
        HashSet<Placement> placements = new HashSet<Placement>();
        for (Lecture lecture : this.variables()) {
            Placement placement;
            if (value != null && lecture.equals(value.variable())) continue;
            if (assignments != null && assignments.containsKey(lecture)) {
                placement = assignments.get(lecture);
                if (placement == null || !this.shareWeeksAndDay(placement.getTimeLocation(), week, dayCode)) continue;
                placements.add(placement);
                continue;
            }
            if (assignment == null || (placement = assignment.getValue(lecture)) == null || conflicts != null && conflicts.contains(placement) || !this.shareWeeksAndDay(placement.getTimeLocation(), week, dayCode)) continue;
            placements.add(placement);
        }
        if (value == null || conflicts != null && conflicts.contains(value)) {
            return placements;
        }
        if (this.shareWeeksAndDay(value.getTimeLocation(), week, dayCode)) {
            placements.add(value);
        }
        return placements;
    }

    private boolean shareWeeksAndDay(TimeLocation t, BitSet week, int dayCode) {
        boolean matchDay = (t.getDayCode() & dayCode) != 0;
        boolean matchWeek = week == null || t.shareWeeks(week);
        return matchDay && matchWeek;
    }

    protected List<Block> mergeToBlocks(List<Placement> sorted, int maxBreakBetweenBTB) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (int i = 0; i < sorted.size(); ++i) {
            Placement placement = sorted.get(i);
            boolean added = false;
            for (int j = 0; j < blocks.size(); ++j) {
                if (!((Block)blocks.get(j)).addPlacement(placement)) continue;
                added = true;
            }
            if (added) continue;
            Block block = new Block(maxBreakBetweenBTB);
            block.addPlacement(placement);
            blocks.add(block);
        }
        return blocks;
    }

    @Override
    public boolean isHard() {
        return this.iIsRequired;
    }

    @Override
    public String getName() {
        return this.iOwner + ": " + this.iConstraintType.getName();
    }

    public FlexibleConstraintType getType() {
        return this.iConstraintType;
    }

    public String getReference() {
        return this.iReference;
    }

    public String getOwner() {
        return this.iOwner;
    }

    public String getPrologPreference() {
        return Constants.preferenceLevel2preference(this.iPreference);
    }

    public double getCurrentPreference(Assignment<Lecture, Placement> assignment, Set<Placement> conflicts, HashMap<Lecture, Placement> assignments) {
        if (this.isHard()) {
            return 0.0;
        }
        double pref = this.getNrViolations(assignment, conflicts, assignments);
        if (pref == 0.0) {
            return -Math.abs(this.iPreference);
        }
        return (double)Math.abs(this.iPreference) * pref;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public FlexibleConstraintContext createAssignmentContext(Assignment<Lecture, Placement> assignment) {
        return new FlexibleConstraintContext(assignment);
    }

    public class FlexibleConstraintContext
    implements AssignmentConstraintContext<Lecture, Placement> {
        protected double iLastPreference = 0.0;

        FlexibleConstraintContext() {
        }

        FlexibleConstraintContext(Assignment<Lecture, Placement> assignment) {
            this.updateCriterion(assignment);
        }

        @Override
        public void assigned(Assignment<Lecture, Placement> assignment, Placement value) {
            this.updateCriterion(assignment);
        }

        @Override
        public void unassigned(Assignment<Lecture, Placement> assignment, Placement value) {
            this.updateCriterion(assignment);
        }

        protected void updateCriterion(Assignment<Lecture, Placement> assignment) {
            Criterion<Lecture, Placement> criterion;
            if (!FlexibleConstraint.this.isHard() && (criterion = FlexibleConstraint.this.getModel().getCriterion(FlexibleConstraintCriterion.class)) != null) {
                criterion.inc(assignment, -this.iLastPreference);
                this.iLastPreference = FlexibleConstraint.this.getCurrentPreference(assignment, null, null);
                criterion.inc(assignment, this.iLastPreference);
            }
        }

        public double getPreference() {
            return this.iLastPreference;
        }
    }

    protected static class PlacementTimeComparator
    implements Comparator<Placement> {
        protected PlacementTimeComparator() {
        }

        @Override
        public int compare(Placement p1, Placement p2) {
            TimeLocation t1 = p1.getTimeLocation();
            TimeLocation t2 = p2.getTimeLocation();
            if (t1.getStartSlot() < t2.getStartSlot()) {
                return -1;
            }
            if (t1.getStartSlot() > t2.getStartSlot()) {
                return 1;
            }
            if (t1.getLength() < t2.getLength()) {
                return -1;
            }
            if (t1.getLength() > t2.getLength()) {
                return 1;
            }
            return 0;
        }
    }

    public class Block {
        private int startSlotCurrentBlock = -1;
        private int endSlotCurrentBlock = -1;
        private int maxSlotsBetweenBackToBack = 4;
        private List<Placement> placements = new ArrayList<Placement>();

        public Block(int maxSlotsBetweenBTB) {
            this.maxSlotsBetweenBackToBack = maxSlotsBetweenBTB;
        }

        public boolean addPlacement(Placement placement) {
            if (placement == null) {
                return false;
            }
            TimeLocation t = placement.getTimeLocation();
            if (t == null) {
                return false;
            }
            if (this.placements.isEmpty()) {
                this.placements.add(placement);
                this.startSlotCurrentBlock = t.getStartSlot();
                this.endSlotCurrentBlock = t.getStartSlot() + t.getLength();
                return true;
            }
            if (t.getStartSlot() == this.startSlotCurrentBlock) {
                this.placements.add(placement);
                int tEnd = t.getStartSlot() + t.getLength();
                if (tEnd > this.endSlotCurrentBlock) {
                    this.endSlotCurrentBlock = tEnd;
                }
                return true;
            }
            if (this.endSlotCurrentBlock + this.maxSlotsBetweenBackToBack >= t.getStartSlot() && t.getStartSlot() >= this.startSlotCurrentBlock) {
                this.placements.add(placement);
                int tEnd = t.getStartSlot() + t.getLength();
                if (tEnd > this.endSlotCurrentBlock) {
                    this.endSlotCurrentBlock = tEnd;
                }
                return true;
            }
            return false;
        }

        public boolean haveSameStartTime() {
            if (!this.placements.isEmpty()) {
                int startSlot = this.placements.get(0).getTimeLocation().getStartSlot();
                for (Placement p : this.getPlacements()) {
                    if (p.getTimeLocation().getStartSlot() == startSlot) continue;
                    return false;
                }
            }
            return true;
        }

        public int getStartSlotCurrentBlock() {
            return this.startSlotCurrentBlock;
        }

        public int getEndSlotCurrentBlock() {
            return this.endSlotCurrentBlock;
        }

        public int getNbrPlacements() {
            return this.placements.size();
        }

        public List<Placement> getPlacements() {
            return this.placements;
        }

        public int getLengthInSlots() {
            return this.endSlotCurrentBlock - this.startSlotCurrentBlock;
        }

        public String toString() {
            return "[" + this.startSlotCurrentBlock + ", " + this.endSlotCurrentBlock + "] PlacementsNbr: " + this.getNbrPlacements();
        }
    }

    public static enum FlexibleConstraintType {
        MAXBLOCK_BACKTOBACK("_(MaxBlock):([0-9]+):([0-9]+)_", MaxBlockFlexibleConstraint.class, "Block"),
        BREAK("_(Break):([0-9]+):([0-9]+):([0-9]+)_", BreakFlexibleConstraint.class, "Break"),
        MAX_BREAKS("_(MaxBreaks):([0-9]+):([0-9]+)_", MaxBreaksFlexibleConstraint.class, "MaxBreaks"),
        MAX_WEEKS("_(MaxWeeks):([0-9]+):([0-9]+)_", MaxWeeksFlexibleConstraint.class, "MaxWeeks"),
        MAX_DAYS("_(MaxDays):([0-9]+)_", MaxDaysFlexibleConstraint.class, "MaxDays"),
        MAX_HOLES("_(MaxHoles):([0-9]+)_", MaxHolesFlexibleConstraint.class, "MaxHoles"),
        MAX_HALF_DAYS("_(MaxHalfDays):([0-9]+)_", MaxHalfDaysFlexibleConstraint.class, "MaxHalfDays");

        private String iPattern;
        private Class<? extends FlexibleConstraint> iImplementation;
        private String iName;

        private FlexibleConstraintType(String pattern, Class<? extends FlexibleConstraint> implementation, String name) {
            this.iPattern = pattern;
            this.iImplementation = implementation;
            this.iName = name;
        }

        public String getPattern() {
            return this.iPattern;
        }

        public String getName() {
            return this.iName.replaceAll("(?<=[^A-Z])([A-Z])", " $1");
        }

        public FlexibleConstraint create(Long id, String owner, String preference, String reference) throws IllegalArgumentException {
            try {
                return this.iImplementation.getConstructor(Long.class, String.class, String.class, String.class).newInstance(id, owner, preference, reference);
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
    }
}

