/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.criteria.additional;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.cpsolver.coursett.constraint.InstructorConstraint;
import org.cpsolver.coursett.criteria.TimePreferences;
import org.cpsolver.coursett.criteria.TimetablingCriterion;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.criteria.AbstractCriterion;
import org.cpsolver.ifs.util.DataProperties;

public class InstructorFairness
extends TimetablingCriterion {
    public InstructorFairness() {
        this.setValueUpdateType(AbstractCriterion.ValueUpdateType.BeforeUnassignedAfterAssigned);
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return config.getPropertyDouble("Comparator.InstructorFairnessPreferenceWeight", 1.0);
    }

    @Override
    public String getPlacementSelectionWeightName() {
        return "Placement.InstructorFairnessPreferenceWeight";
    }

    @Override
    public void bestSaved(Assignment<Lecture, Placement> assignment) {
        this.iBest = this.getValue(assignment);
    }

    @Override
    public double getValue(Assignment<Lecture, Placement> assignment, Placement value, Set<Placement> conflicts) {
        double ret = 0.0;
        InstructorFairnessContext context = (InstructorFairnessContext)this.getContext((Assignment)assignment);
        if (context.allInstructorsAssigned(assignment) && !((Lecture)value.variable()).getInstructorConstraints().isEmpty()) {
            List<InstructorConstraint> insConstraints = ((Lecture)value.variable()).getInstructorConstraints();
            ret = context.getDiffInstrValue(insConstraints, context.fairnessDouble(assignment, value)) / (double)insConstraints.size();
            if (conflicts != null) {
                for (Placement conflict : conflicts) {
                    if (((Lecture)conflict.variable()).getInstructorConstraints().isEmpty()) continue;
                    List<InstructorConstraint> insConstraints2 = ((Lecture)conflict.variable()).getInstructorConstraints();
                    ret -= context.getDiffInstrValue(insConstraints2, context.fairnessDouble(assignment, conflict)) / (double)insConstraints2.size();
                }
            }
        }
        return ret;
    }

    @Override
    public double getValue(Assignment<Lecture, Placement> assignment) {
        InstructorFairnessContext context = (InstructorFairnessContext)this.getContext((Assignment)assignment);
        if (context.allInstructorsAssigned(assignment)) {
            return context.getObjectiveValue();
        }
        return 0.0;
    }

    @Override
    public double getValue(Assignment<Lecture, Placement> assignment, Collection<Lecture> variables) {
        InstructorFairnessContext context = (InstructorFairnessContext)this.getContext((Assignment)assignment);
        if (context.allInstructorsAssigned(assignment)) {
            HashSet<InstructorConstraint> constraints = new HashSet<InstructorConstraint>();
            for (Lecture lecture : variables) {
                constraints.addAll(lecture.getInstructorConstraints());
            }
            return context.getObjectiveValue(constraints);
        }
        return 0.0;
    }

    @Override
    public void getInfo(Assignment<Lecture, Placement> assignment, Map<String, String> info) {
        double value = this.getValue(assignment);
        if (value != 0.0) {
            info.put(this.getName(), sDoubleFormat.format(value));
        }
    }

    @Override
    public void getInfo(Assignment<Lecture, Placement> assignment, Map<String, String> info, Collection<Lecture> variables) {
        double value = this.getValue(assignment, variables);
        if (value != 0.0) {
            info.put(this.getName(), sDoubleFormat.format(value));
        }
    }

    @Override
    public void getExtendedInfo(Assignment<Lecture, Placement> assignment, Map<String, String> info) {
        if (this.iDebug) {
            InstructorFairnessContext context = (InstructorFairnessContext)this.getContext((Assignment)assignment);
            String[] fairnessInfo = context.testFairness(assignment);
            info.put(this.getName() + " Details", fairnessInfo[8] + " (avg: " + fairnessInfo[0] + ", rms: " + fairnessInfo[1] + ", Pmax: " + fairnessInfo[2] + ", Pdev: " + fairnessInfo[3] + ", Perror: " + fairnessInfo[4] + ", Pss: " + fairnessInfo[5] + ", Jain's index: " + fairnessInfo[6] + ", max: " + fairnessInfo[7] + ")");
        }
    }

    @Override
    public AbstractCriterion.ValueContext createAssignmentContext(Assignment<Lecture, Placement> assignment) {
        return new InstructorFairnessContext(assignment);
    }

    public class InstructorFairnessContext
    extends AbstractCriterion.ValueContext {
        private TreeMap<Long, Instructor> iId2Instructor;
        private double iInstrMeanFairValue;
        private boolean iFullTreeMap;
        private boolean iFirstIterDone;

        public InstructorFairnessContext(Assignment<Lecture, Placement> assignment) {
            super(InstructorFairness.this);
            this.iId2Instructor = new TreeMap();
            this.iInstrMeanFairValue = 0.0;
            this.iFullTreeMap = false;
            this.iFirstIterDone = false;
            this.countInstructorFair(assignment);
        }

        protected void assigned(Assignment<Lecture, Placement> assignment, Placement value) {
            if (this.isFirstIterDone()) {
                this.countInstructorAssignedFair(assignment, value);
            } else {
                this.countInstructorFair(assignment);
            }
        }

        protected void unassigned(Assignment<Lecture, Placement> assignment, Placement value) {
            if (this.isFirstIterDone()) {
                this.countInstructorUnassignedFair(assignment, value);
            } else if (this.countInstructorFair(assignment)) {
                this.countInstructorUnassignedFair(assignment, value);
            }
        }

        public boolean countInstructorFair(Assignment<Lecture, Placement> assignment) {
            if (this.allInstructorsAssigned(assignment)) {
                this.iId2Instructor.clear();
                for (Lecture lecture : InstructorFairness.this.getModel().variables()) {
                    Double bestPossibleValue = null;
                    for (Placement t : lecture.values(assignment)) {
                        double f = this.fairnessDouble(assignment, t);
                        if (bestPossibleValue != null && !(f < bestPossibleValue)) continue;
                        bestPossibleValue = f;
                    }
                    Placement placement = assignment.getValue(lecture);
                    for (InstructorConstraint ic : lecture.getInstructorConstraints()) {
                        Instructor s = this.iId2Instructor.get(ic.getResourceId());
                        if (s == null) {
                            s = new Instructor(ic.getResourceId());
                            this.iId2Instructor.put(ic.getResourceId(), s);
                        }
                        if (bestPossibleValue != null) {
                            s.addBestValue(bestPossibleValue);
                        }
                        if (placement == null) continue;
                        s.addValue(this.fairnessDouble(assignment, placement));
                        s.incNumOfClasses();
                    }
                }
                this.countInstrMeanFairValue();
                this.setFirstIterDone();
                return true;
            }
            return false;
        }

        public void countInstructorAssignedFair(Assignment<Lecture, Placement> assignment, Placement value) {
            Lecture lec = (Lecture)value.variable();
            if (lec.getInstructorConstraints() != null) {
                List<InstructorConstraint> insConstraints = lec.getInstructorConstraints();
                double critValue = this.fairnessDouble(assignment, lec.getAssignment(assignment));
                for (InstructorConstraint ic : insConstraints) {
                    if (this.addInstructorValue(ic.getResourceId(), critValue)) continue;
                    throw new IllegalArgumentException("Instructor " + ic.getResourceId() + " is not present in the context.");
                }
            }
            this.countInstrMeanFairValue();
        }

        public void countInstructorUnassignedFair(Assignment<Lecture, Placement> assignment, Placement value) {
            Lecture lec = (Lecture)value.variable();
            if (lec.getInstructorConstraints() != null) {
                List<InstructorConstraint> insConstraints = lec.getInstructorConstraints();
                double critValue = this.fairnessDouble(assignment, lec.getAssignment(assignment));
                for (InstructorConstraint ic : insConstraints) {
                    if (this.decreaseInstructorValue(ic.getResourceId(), critValue)) continue;
                    throw new IllegalArgumentException("Instructor " + ic.getResourceId() + " is not present in the context.");
                }
            }
            this.countInstrMeanFairValue();
        }

        public double getInstrMeanFairValue() {
            return this.iInstrMeanFairValue;
        }

        public boolean isFirstIterDone() {
            return this.iFirstIterDone;
        }

        public void setFirstIterDone() {
            this.iFirstIterDone = true;
        }

        public int getNumOfIstructors() {
            return this.iId2Instructor.size();
        }

        public Collection<Instructor> getInstructorsWithAssig() {
            return this.iId2Instructor.values();
        }

        public boolean allInstructorsAssigned(Assignment<Lecture, Placement> assignment) {
            if (!this.iFullTreeMap) {
                this.iFullTreeMap = assignment.nrAssignedVariables() > 0 && assignment.nrUnassignedVariables(InstructorFairness.this.getModel()) == 0 && InstructorFairness.this.getModel().getBestUnassignedVariables() == 0;
            }
            return this.iFullTreeMap;
        }

        public boolean addInstructorValue(Long insID, double value) {
            Instructor s = this.iId2Instructor.get(insID);
            if (s != null) {
                s.addValue(value);
                s.incNumOfClasses();
                return true;
            }
            return false;
        }

        public boolean decreaseInstructorValue(Long insID, double value) {
            Instructor s = this.iId2Instructor.get(insID);
            if (s != null) {
                s.removeValue(value);
                s.decNumOfClasses();
                return true;
            }
            return false;
        }

        public void countInstrMeanFairValue() {
            if (!this.iId2Instructor.isEmpty()) {
                double sum = 0.0;
                for (Instructor ins : this.iId2Instructor.values()) {
                    sum += ins.getFinalValue();
                }
                this.iInstrMeanFairValue = sum / (double)this.iId2Instructor.size();
            }
        }

        public double getDiffInstrValue(List<InstructorConstraint> instructorsList, double placementValue) {
            double ret = 0.0;
            for (InstructorConstraint ic : instructorsList) {
                Instructor i = this.iId2Instructor.get(ic.getResourceId());
                if (i == null) continue;
                if (i.getFinalValue() > this.iInstrMeanFairValue) {
                    ret += (i.getFinalValue() - this.iInstrMeanFairValue) / (double)i.getNumOfClasses() + (placementValue - this.iInstrMeanFairValue);
                    continue;
                }
                ret -= (this.iInstrMeanFairValue - i.getFinalValue()) / (double)i.getNumOfClasses() + (this.iInstrMeanFairValue - placementValue);
            }
            return ret;
        }

        public double getObjectiveValue() {
            double ret = 0.0;
            for (Map.Entry<Long, Instructor> entry : this.iId2Instructor.entrySet()) {
                Instructor ins = entry.getValue();
                ret += Math.abs(ins.getFinalValue() - this.iInstrMeanFairValue);
            }
            return ret;
        }

        public double getObjectiveValue(Collection<InstructorConstraint> instructors) {
            double ret = 0.0;
            for (InstructorConstraint ic : instructors) {
                Instructor ins = this.iId2Instructor.get(ic.getResourceId());
                if (ins == null) continue;
                ret += Math.abs(ins.getFinalValue() - this.iInstrMeanFairValue);
            }
            return ret;
        }

        public double getDiffAllInstrValueSquared() {
            double ret = 0.0;
            for (Map.Entry<Long, Instructor> entry : this.iId2Instructor.entrySet()) {
                Instructor ins = entry.getValue();
                ret += Math.sqrt(Math.abs(ins.getFinalValue() * ins.getFinalValue() - this.iInstrMeanFairValue * this.iInstrMeanFairValue));
            }
            return ret;
        }

        public void refreshInstructors() {
            for (Map.Entry<Long, Instructor> entry : this.iId2Instructor.entrySet()) {
                Instructor ins = entry.getValue();
                ins.refresh();
            }
        }

        public double fairnessDouble(Assignment<Lecture, Placement> assignment, Placement placement) {
            double critValue = 0.0;
            return critValue += InstructorFairness.this.getModel().getCriterion(TimePreferences.class).getWeightedValue(assignment, placement, null);
        }

        public String[] testFairness(Assignment<Lecture, Placement> assignment) {
            String[] dataForEval = new String[9];
            Collection<Lecture> assignedLectures = assignment.assignedVariables();
            this.refreshInstructors();
            for (Lecture lec : assignedLectures) {
                if (lec.getInstructorConstraints() == null) continue;
                List<InstructorConstraint> insConstraints = lec.getInstructorConstraints();
                double critValue = this.fairnessDouble(assignment, lec.getAssignment(assignment));
                for (InstructorConstraint ic : insConstraints) {
                    this.addInstructorValue(ic.getResourceId(), critValue);
                }
            }
            this.countInstrMeanFairValue();
            dataForEval[8] = sDoubleFormat.format(this.getObjectiveValue());
            double[] instructorsValue = new double[this.iId2Instructor.values().size()];
            int counter = 0;
            double sumOfSquaredPen = 0.0;
            double min = 100000.0;
            double max = -100000.0;
            double sum = 0.0;
            double pdevSecPart = 0.0;
            double pssSecPart = 0.0;
            for (Instructor s : this.iId2Instructor.values()) {
                instructorsValue[counter] = s.getFinalValue();
                sumOfSquaredPen += s.getFinalValue() * s.getFinalValue();
                if (min > s.getFinalValue()) {
                    min = s.getFinalValue();
                }
                if (max < s.getFinalValue()) {
                    max = s.getFinalValue();
                }
                sum += s.getFinalValue();
                ++counter;
            }
            Arrays.sort(instructorsValue);
            for (Object d : (Object)instructorsValue) {
                pdevSecPart += Math.abs((double)(d - sum / (double)instructorsValue.length));
                pssSecPart += d * d;
            }
            dataForEval[7] = sDoubleFormat.format(max);
            dataForEval[0] = sDoubleFormat.format(sum / (double)instructorsValue.length);
            dataForEval[1] = sDoubleFormat.format(Math.sqrt(sumOfSquaredPen));
            dataForEval[2] = sDoubleFormat.format(InstructorFairness.this.iBest - pdevSecPart * InstructorFairness.this.iWeight + (double)instructorsValue.length * max);
            dataForEval[3] = sDoubleFormat.format(InstructorFairness.this.iBest);
            dataForEval[4] = sDoubleFormat.format(InstructorFairness.this.iBest - pdevSecPart * InstructorFairness.this.iWeight + sum + (double)instructorsValue.length * (max - min));
            dataForEval[5] = sDoubleFormat.format(Math.sqrt((InstructorFairness.this.iBest - pdevSecPart * InstructorFairness.this.iWeight) * InstructorFairness.this.iBest - pdevSecPart * InstructorFairness.this.iWeight + pssSecPart));
            dataForEval[6] = sumOfSquaredPen != 0.0 ? sDoubleFormat.format(sum * sum / ((double)instructorsValue.length * sumOfSquaredPen)) : sDoubleFormat.format(1L);
            return dataForEval;
        }

        public class Instructor {
            private Long iId;
            private double iValue = 0.0;
            private double iBestValue = 0.0;
            private int iNumOfClasses = 0;
            private double coef = 1.0;

            public Instructor(Long instructorId) {
                this.iId = instructorId;
            }

            public double getFinalValue() {
                if (this.iNumOfClasses == 0) {
                    return 0.0;
                }
                return (this.iValue - this.iBestValue) / (double)this.iNumOfClasses * this.coef;
            }

            public Long getId() {
                return this.iId;
            }

            public double getValue() {
                return this.iValue;
            }

            public void addValue(double value) {
                this.iValue += value;
            }

            public void removeValue(double value) {
                this.iValue -= value;
            }

            public double getBestValue() {
                return this.iBestValue;
            }

            public void addBestValue(double bestValue) {
                this.iBestValue += bestValue;
            }

            public int getNumOfClasses() {
                return this.iNumOfClasses;
            }

            public void incNumOfClasses() {
                ++this.iNumOfClasses;
            }

            public void decNumOfClasses() {
                --this.iNumOfClasses;
            }

            public double getCoef() {
                return this.coef;
            }

            public void setCoef(double coef) {
                this.coef = coef;
            }

            public void refresh() {
                this.iValue = 0.0;
                this.iNumOfClasses = 0;
            }

            public int hashCode() {
                return this.iId.hashCode();
            }

            public boolean equals(Object obj) {
                if (obj == null || !(obj instanceof Instructor)) {
                    return false;
                }
                return this.iId.equals(((Instructor)obj).iId);
            }
        }
    }
}

