/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.heuristics;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.cpsolver.ifs.extension.Extension;
import org.cpsolver.ifs.extension.MacPropagation;
import org.cpsolver.ifs.heuristics.VariableSelection;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ToolBox;

public class GeneralVariableSelection<V extends Variable<V, T>, T extends Value<V, T>>
implements VariableSelection<V, T> {
    private boolean iUnassignWhenNotGood = false;
    private double iUnassignWhenNotGoodRandWalk = 0.02;
    private boolean iRandomSelection = true;
    private MacPropagation<V, T> iProp = null;

    public GeneralVariableSelection(DataProperties properties) {
        this.iUnassignWhenNotGood = properties.getPropertyBoolean("Variable.UnassignWhenNoGood", this.iUnassignWhenNotGood);
        this.iUnassignWhenNotGoodRandWalk = properties.getPropertyDouble("Variable.UnassignWhenNoGoodRandomWalk", this.iUnassignWhenNotGoodRandWalk);
        this.iRandomSelection = properties.getPropertyBoolean("Variable.RandomSelection", this.iRandomSelection);
    }

    public GeneralVariableSelection() {
    }

    @Override
    public void init(Solver<V, T> solver) {
        for (Extension<V, T> extension : solver.getExtensions()) {
            if (!MacPropagation.class.isInstance(extension)) continue;
            this.iProp = (MacPropagation)extension;
        }
    }

    @Override
    public V selectVariable(Solution<V, T> solution) {
        if (solution.getModel().variables().size() == solution.getAssignment().nrAssignedVariables()) {
            if (!solution.getModel().perturbVariables(solution.getAssignment()).isEmpty()) {
                return (V)((Variable)ToolBox.random(solution.getModel().perturbVariables(solution.getAssignment())));
            }
            return (V)((Variable)ToolBox.random(solution.getAssignment().assignedVariables()));
        }
        if (this.iProp != null && this.iUnassignWhenNotGood) {
            ArrayList<Variable> noGoodVariables = new ArrayList<Variable>();
            for (Variable variable : solution.getAssignment().unassignedVariables(solution.getModel())) {
                if (!this.iProp.goodValues(solution.getAssignment(), variable).isEmpty()) continue;
                noGoodVariables.add(variable);
            }
            if (!noGoodVariables.isEmpty()) {
                if (ToolBox.random() < this.iUnassignWhenNotGoodRandWalk) {
                    return (V)((Variable)ToolBox.random(solution.getAssignment().assignedVariables()));
                }
                for (int attempt = 0; attempt < 10; ++attempt) {
                    Variable noGoodVariable = (Variable)ToolBox.random(noGoodVariables);
                    Value noGoodValue = (Value)ToolBox.random(noGoodVariable.values(solution.getAssignment()));
                    Set<Value> noGood = this.iProp.noGood(solution.getAssignment(), noGoodValue);
                    if (noGood == null || noGood.isEmpty()) continue;
                    return ToolBox.random(noGood).variable();
                }
            }
        }
        if (this.iRandomSelection) {
            return (V)((Variable)ToolBox.random(solution.getAssignment().unassignedVariables(solution.getModel())));
        }
        ArrayList<Integer> points = new ArrayList<Integer>();
        int totalPoints = 0;
        for (Variable variable : solution.getAssignment().unassignedVariables(solution.getModel())) {
            int pointsThisVariable = variable.getInitialAssignment() != null ? 3 * (1 + solution.getModel().conflictValues(solution.getAssignment(), variable.getInitialAssignment()).size()) : 1;
            points.add(totalPoints += pointsThisVariable);
        }
        int rndPoints = ToolBox.random(totalPoints);
        Iterator<V> x = solution.getAssignment().unassignedVariables(solution.getModel()).iterator();
        for (int i = 0; x.hasNext() && i < points.size(); ++i) {
            Variable variable = (Variable)x.next();
            int tp = (Integer)points.get(i);
            if (tp <= rndPoints) continue;
            return (V)variable;
        }
        return (V)((Variable)ToolBox.random(solution.getAssignment().unassignedVariables(solution.getModel())));
    }
}

