/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.coursett.neighbourhoods;

import java.util.List;
import net.sf.cpsolver.coursett.model.Lecture;
import net.sf.cpsolver.coursett.model.Placement;
import net.sf.cpsolver.coursett.model.RoomLocation;
import net.sf.cpsolver.coursett.model.TimeLocation;
import net.sf.cpsolver.coursett.model.TimetableModel;
import net.sf.cpsolver.ifs.algorithms.neighbourhoods.RandomMove;
import net.sf.cpsolver.ifs.model.Neighbour;
import net.sf.cpsolver.ifs.model.SimpleNeighbour;
import net.sf.cpsolver.ifs.solution.Solution;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.ToolBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeChange
extends RandomMove<Lecture, Placement> {
    public TimeChange(DataProperties config) {
        super(config);
    }

    @Override
    public Neighbour<Lecture, Placement> selectNeighbour(Solution<Lecture, Placement> solution) {
        TimetableModel model = (TimetableModel)solution.getModel();
        int varIdx = ToolBox.random(model.variables().size());
        for (int i = 0; i < model.variables().size(); ++i) {
            List<TimeLocation> values;
            Lecture lecture = (Lecture)model.variables().get((i + varIdx) % model.variables().size());
            Placement old = (Placement)lecture.getAssignment();
            if (old == null || (values = lecture.timeLocations()).isEmpty()) continue;
            int valIdx = ToolBox.random(values.size());
            for (int j = 0; j < values.size(); ++j) {
                TimeLocation time = values.get((j + valIdx) % values.size());
                if (time.getPreference() > 50) continue;
                Placement placement = null;
                placement = lecture.getNrRooms() == 0 ? new Placement(lecture, time, (RoomLocation)null) : (lecture.getNrRooms() == 1 ? new Placement(lecture, time, old.getRoomLocation()) : new Placement(lecture, time, old.getRoomLocations()));
                if (!placement.isValid() || model.inConflict(placement)) continue;
                SimpleNeighbour<Lecture, Placement> n = new SimpleNeighbour<Lecture, Placement>(lecture, placement);
                if (this.iHC && !(n.value() <= 0.0)) continue;
                return n;
            }
        }
        return null;
    }
}

