/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.coursett.model;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.sf.cpsolver.coursett.constraint.ClassLimitConstraint;
import net.sf.cpsolver.coursett.constraint.DepartmentSpreadConstraint;
import net.sf.cpsolver.coursett.constraint.FlexibleConstraint;
import net.sf.cpsolver.coursett.constraint.GroupConstraint;
import net.sf.cpsolver.coursett.constraint.InstructorConstraint;
import net.sf.cpsolver.coursett.constraint.JenrlConstraint;
import net.sf.cpsolver.coursett.constraint.RoomConstraint;
import net.sf.cpsolver.coursett.constraint.SpreadConstraint;
import net.sf.cpsolver.coursett.criteria.BackToBackInstructorPreferences;
import net.sf.cpsolver.coursett.criteria.BrokenTimePatterns;
import net.sf.cpsolver.coursett.criteria.DepartmentBalancingPenalty;
import net.sf.cpsolver.coursett.criteria.DistributionPreferences;
import net.sf.cpsolver.coursett.criteria.FlexibleConstraintCriterion;
import net.sf.cpsolver.coursett.criteria.Perturbations;
import net.sf.cpsolver.coursett.criteria.RoomPreferences;
import net.sf.cpsolver.coursett.criteria.RoomViolations;
import net.sf.cpsolver.coursett.criteria.SameSubpartBalancingPenalty;
import net.sf.cpsolver.coursett.criteria.StudentCommittedConflict;
import net.sf.cpsolver.coursett.criteria.StudentConflict;
import net.sf.cpsolver.coursett.criteria.StudentDistanceConflict;
import net.sf.cpsolver.coursett.criteria.StudentHardConflict;
import net.sf.cpsolver.coursett.criteria.StudentOverlapConflict;
import net.sf.cpsolver.coursett.criteria.TimePreferences;
import net.sf.cpsolver.coursett.criteria.TimeViolations;
import net.sf.cpsolver.coursett.criteria.TooBigRooms;
import net.sf.cpsolver.coursett.criteria.UselessHalfHours;
import net.sf.cpsolver.coursett.criteria.placement.AssignmentCount;
import net.sf.cpsolver.coursett.criteria.placement.DeltaTimePreference;
import net.sf.cpsolver.coursett.criteria.placement.HardConflicts;
import net.sf.cpsolver.coursett.criteria.placement.PotentialHardConflicts;
import net.sf.cpsolver.coursett.criteria.placement.WeightedHardConflicts;
import net.sf.cpsolver.coursett.model.DefaultStudentSectioning;
import net.sf.cpsolver.coursett.model.Lecture;
import net.sf.cpsolver.coursett.model.OnFlySectioning;
import net.sf.cpsolver.coursett.model.Placement;
import net.sf.cpsolver.coursett.model.Student;
import net.sf.cpsolver.coursett.model.StudentSectioning;
import net.sf.cpsolver.ifs.constant.ConstantModel;
import net.sf.cpsolver.ifs.criteria.Criterion;
import net.sf.cpsolver.ifs.model.Constraint;
import net.sf.cpsolver.ifs.model.GlobalConstraint;
import net.sf.cpsolver.ifs.model.WeakeningConstraint;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.DistanceMetric;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimetableModel
extends ConstantModel<Lecture, Placement> {
    private static Logger sLogger = Logger.getLogger(TimetableModel.class);
    private static DecimalFormat sDoubleFormat = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));
    private List<InstructorConstraint> iInstructorConstraints = new ArrayList<InstructorConstraint>();
    private List<JenrlConstraint> iJenrlConstraints = new ArrayList<JenrlConstraint>();
    private List<RoomConstraint> iRoomConstraints = new ArrayList<RoomConstraint>();
    private List<DepartmentSpreadConstraint> iDepartmentSpreadConstraints = new ArrayList<DepartmentSpreadConstraint>();
    private List<SpreadConstraint> iSpreadConstraints = new ArrayList<SpreadConstraint>();
    private List<GroupConstraint> iGroupConstraints = new ArrayList<GroupConstraint>();
    private List<ClassLimitConstraint> iClassLimitConstraints = new ArrayList<ClassLimitConstraint>();
    private List<FlexibleConstraint> iFlexibleConstraints = new ArrayList<FlexibleConstraint>();
    private DataProperties iProperties = null;
    private int iYear = -1;
    private List<BitSet> iWeeks = null;
    private HashSet<Student> iAllStudents = new HashSet();
    private DistanceMetric iDistanceMetric = null;
    private StudentSectioning iStudentSectioning = null;

    public TimetableModel(DataProperties properties) {
        this.iProperties = properties;
        this.iDistanceMetric = new DistanceMetric(properties);
        if (properties.getPropertyBoolean("OnFlySectioning.Enabled", false)) {
            this.addModelListener(new OnFlySectioning(this));
        }
        String criteria = properties.getProperty("General.Criteria", StudentConflict.class.getName() + ";" + StudentDistanceConflict.class.getName() + ";" + StudentHardConflict.class.getName() + ";" + StudentCommittedConflict.class.getName() + ";" + StudentOverlapConflict.class.getName() + ";" + UselessHalfHours.class.getName() + ";" + BrokenTimePatterns.class.getName() + ";" + TooBigRooms.class.getName() + ";" + TimePreferences.class.getName() + ";" + RoomPreferences.class.getName() + ";" + DistributionPreferences.class.getName() + ";" + SameSubpartBalancingPenalty.class.getName() + ";" + DepartmentBalancingPenalty.class.getName() + ";" + BackToBackInstructorPreferences.class.getName() + ";" + Perturbations.class.getName() + ";" + AssignmentCount.class.getName() + ";" + DeltaTimePreference.class.getName() + ";" + HardConflicts.class.getName() + ";" + PotentialHardConflicts.class.getName() + ";" + FlexibleConstraintCriterion.class.getName() + ";" + WeightedHardConflicts.class.getName());
        if (properties.getPropertyBoolean("General.InteractiveMode", false)) {
            criteria = criteria + ";" + TimeViolations.class.getName() + ";" + RoomViolations.class.getName();
        }
        criteria = criteria + ";" + properties.getProperty("General.AdditionalCriteria", "");
        for (String criterion : criteria.split("\\;")) {
            if (criterion == null || criterion.isEmpty()) continue;
            try {
                Class<?> clazz = Class.forName(criterion);
                this.addCriterion((Criterion)clazz.newInstance());
            }
            catch (Exception e) {
                sLogger.error((Object)("Unable to use " + criterion + ": " + e.getMessage()));
            }
        }
        try {
            String studentSectioningClassName = properties.getProperty("StudentSectioning.Class", DefaultStudentSectioning.class.getName());
            Class<?> studentSectioningClass = Class.forName(studentSectioningClassName);
            this.iStudentSectioning = (StudentSectioning)studentSectioningClass.getConstructor(TimetableModel.class).newInstance(this);
        }
        catch (Exception e) {
            sLogger.error((Object)("Failed to load custom student sectioning class: " + e.getMessage()));
            this.iStudentSectioning = new DefaultStudentSectioning(this);
        }
    }

    public DistanceMetric getDistanceMetric() {
        return this.iDistanceMetric;
    }

    public StudentSectioning getStudentSectioning() {
        return this.iStudentSectioning;
    }

    public DataProperties getProperties() {
        return this.iProperties;
    }

    public void switchStudents() {
        this.getStudentSectioning().switchStudents(this);
    }

    @Override
    public String toString() {
        ArrayList criteria = new ArrayList(this.getCriteria());
        Collections.sort(criteria, new Comparator<Criterion<Lecture, Placement>>(){

            @Override
            public int compare(Criterion<Lecture, Placement> c1, Criterion<Lecture, Placement> c2) {
                int cmp = -Double.compare(c1.getWeight(), c2.getWeight());
                if (cmp != 0) {
                    return cmp;
                }
                return c1.getName().compareTo(c2.getName());
            }
        });
        String ret = "";
        for (Criterion criterion : criteria) {
            String val = criterion.toString();
            if (val.isEmpty()) continue;
            ret = ret + ", " + val;
        }
        return (this.nrUnassignedVariables() == 0 ? "" : "V:" + this.nrAssignedVariables() + "/" + this.variables().size() + ", ") + "T:" + sDoubleFormat.format(this.getTotalValue()) + ret;
    }

    public Map<String, String> getBounds() {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("Room preferences min", "" + this.getCriterion(RoomPreferences.class).getBounds()[0]);
        ret.put("Room preferences max", "" + this.getCriterion(RoomPreferences.class).getBounds()[1]);
        ret.put("Time preferences min", "" + this.getCriterion(TimePreferences.class).getBounds()[0]);
        ret.put("Time preferences max", "" + this.getCriterion(TimePreferences.class).getBounds()[1]);
        ret.put("Distribution preferences min", "" + this.getCriterion(DistributionPreferences.class).getBounds()[0]);
        ret.put("Distribution preferences max", "" + this.getCriterion(DistributionPreferences.class).getBounds()[1]);
        if (this.getProperties().getPropertyBoolean("General.UseDistanceConstraints", false)) {
            ret.put("Back-to-back instructor preferences max", "" + this.getCriterion(BackToBackInstructorPreferences.class).getBounds()[1]);
        }
        ret.put("Too big rooms max", "" + this.getCriterion(TooBigRooms.class).getBounds()[0]);
        ret.put("Useless half-hours", "" + this.getCriterion(UselessHalfHours.class).getBounds()[0]);
        return ret;
    }

    @Override
    public Map<String, String> getInfo() {
        Map<String, String> ret = super.getInfo();
        ret.put("Memory usage", TimetableModel.getMem());
        Criterion rp = this.getCriterion(RoomPreferences.class);
        Criterion rv = this.getCriterion(RoomViolations.class);
        ret.put("Room preferences", this.getPerc(rp.getValue(), rp.getBounds()[0], rp.getBounds()[1]) + "% (" + Math.round(rp.getValue()) + ")" + (rv != null && rv.getValue() >= 0.5 ? " [hard:" + Math.round(rv.getValue()) + "]" : ""));
        Criterion tp = this.getCriterion(TimePreferences.class);
        Criterion tv = this.getCriterion(TimeViolations.class);
        ret.put("Time preferences", this.getPerc(tp.getValue(), tp.getBounds()[0], tp.getBounds()[1]) + "% (" + sDoubleFormat.format(tp.getValue()) + ")" + (tv != null && tv.getValue() >= 0.5 ? " [hard:" + Math.round(tv.getValue()) + "]" : ""));
        Criterion dp = this.getCriterion(DistributionPreferences.class);
        ret.put("Distribution preferences", this.getPerc(dp.getValue(), dp.getBounds()[0], dp.getBounds()[1]) + "% (" + sDoubleFormat.format(dp.getValue()) + ")");
        Criterion sc = this.getCriterion(StudentConflict.class);
        Criterion shc = this.getCriterion(StudentHardConflict.class);
        Criterion sdc = this.getCriterion(StudentDistanceConflict.class);
        Criterion scc = this.getCriterion(StudentCommittedConflict.class);
        ret.put("Student conflicts", Math.round(scc.getValue() + sc.getValue()) + " [committed:" + Math.round(scc.getValue()) + ", distance:" + Math.round(sdc.getValue()) + ", hard:" + Math.round(shc.getValue()) + "]");
        if (!this.getSpreadConstraints().isEmpty()) {
            Criterion ip = this.getCriterion(BackToBackInstructorPreferences.class);
            ret.put("Back-to-back instructor preferences", this.getPerc(ip.getValue(), ip.getBounds()[0], ip.getBounds()[1]) + "% (" + Math.round(ip.getValue()) + ")");
        }
        if (!this.getDepartmentSpreadConstraints().isEmpty()) {
            Criterion dbp = this.getCriterion(DepartmentBalancingPenalty.class);
            ret.put("Department balancing penalty", sDoubleFormat.format(dbp.getValue()));
        }
        Criterion sbp = this.getCriterion(SameSubpartBalancingPenalty.class);
        ret.put("Same subpart balancing penalty", sDoubleFormat.format(sbp.getValue()));
        Criterion tbr = this.getCriterion(TooBigRooms.class);
        ret.put("Too big rooms", this.getPercRev(tbr.getValue(), tbr.getBounds()[1], tbr.getBounds()[0]) + "% (" + Math.round(tbr.getValue()) + ")");
        Criterion uh = this.getCriterion(UselessHalfHours.class);
        Criterion bt = this.getCriterion(BrokenTimePatterns.class);
        ret.put("Useless half-hours", this.getPercRev(uh.getValue() + bt.getValue(), 0.0, 4.0 * bt.getBounds()[0]) + "% (" + Math.round(uh.getValue()) + " + " + Math.round(bt.getValue()) + ")");
        return ret;
    }

    @Override
    public Map<String, String> getInfo(Collection<Lecture> variables) {
        Map<String, String> ret = super.getInfo(variables);
        ret.put("Memory usage", TimetableModel.getMem());
        Criterion rp = this.getCriterion(RoomPreferences.class);
        ret.put("Room preferences", this.getPerc(rp.getValue(variables), rp.getBounds(variables)[0], rp.getBounds(variables)[1]) + "% (" + Math.round(rp.getValue(variables)) + ")");
        Criterion tp = this.getCriterion(TimePreferences.class);
        ret.put("Time preferences", this.getPerc(tp.getValue(variables), tp.getBounds(variables)[0], tp.getBounds(variables)[1]) + "% (" + sDoubleFormat.format(tp.getValue(variables)) + ")");
        Criterion dp = this.getCriterion(DistributionPreferences.class);
        ret.put("Distribution preferences", this.getPerc(dp.getValue(variables), dp.getBounds(variables)[0], dp.getBounds(variables)[1]) + "% (" + sDoubleFormat.format(dp.getValue(variables)) + ")");
        Criterion sc = this.getCriterion(StudentConflict.class);
        Criterion shc = this.getCriterion(StudentHardConflict.class);
        Criterion sdc = this.getCriterion(StudentDistanceConflict.class);
        Criterion scc = this.getCriterion(StudentCommittedConflict.class);
        ret.put("Student conflicts", Math.round(scc.getValue(variables) + sc.getValue(variables)) + " [committed:" + Math.round(scc.getValue(variables)) + ", distance:" + Math.round(sdc.getValue(variables)) + ", hard:" + Math.round(shc.getValue(variables)) + "]");
        if (!this.getSpreadConstraints().isEmpty()) {
            Criterion ip = this.getCriterion(BackToBackInstructorPreferences.class);
            ret.put("Back-to-back instructor preferences", this.getPerc(ip.getValue(variables), ip.getBounds(variables)[0], ip.getBounds(variables)[1]) + "% (" + Math.round(ip.getValue(variables)) + ")");
        }
        if (!this.getDepartmentSpreadConstraints().isEmpty()) {
            Criterion dbp = this.getCriterion(DepartmentBalancingPenalty.class);
            ret.put("Department balancing penalty", sDoubleFormat.format(dbp.getValue(variables)));
        }
        Criterion sbp = this.getCriterion(SameSubpartBalancingPenalty.class);
        ret.put("Same subpart balancing penalty", sDoubleFormat.format(sbp.getValue(variables)));
        Criterion tbr = this.getCriterion(TooBigRooms.class);
        ret.put("Too big rooms", this.getPercRev(tbr.getValue(variables), tbr.getBounds(variables)[1], tbr.getBounds(variables)[0]) + "% (" + Math.round(tbr.getValue(variables)) + ")");
        Criterion uh = this.getCriterion(UselessHalfHours.class);
        Criterion bt = this.getCriterion(BrokenTimePatterns.class);
        ret.put("Useless half-hours", this.getPercRev(uh.getValue(variables) + bt.getValue(variables), 0.0, 4.0 * bt.getBounds(variables)[0]) + "% (" + Math.round(uh.getValue(variables)) + " + " + Math.round(bt.getValue(variables)) + ")");
        return ret;
    }

    @Override
    public void addConstraint(Constraint<Lecture, Placement> constraint) {
        super.addConstraint(constraint);
        if (constraint instanceof InstructorConstraint) {
            this.iInstructorConstraints.add((InstructorConstraint)constraint);
        } else if (constraint instanceof JenrlConstraint) {
            this.iJenrlConstraints.add((JenrlConstraint)constraint);
        } else if (constraint instanceof RoomConstraint) {
            this.iRoomConstraints.add((RoomConstraint)constraint);
        } else if (constraint instanceof DepartmentSpreadConstraint) {
            this.iDepartmentSpreadConstraints.add((DepartmentSpreadConstraint)constraint);
        } else if (constraint instanceof SpreadConstraint) {
            this.iSpreadConstraints.add((SpreadConstraint)constraint);
        } else if (constraint instanceof ClassLimitConstraint) {
            this.iClassLimitConstraints.add((ClassLimitConstraint)constraint);
        } else if (constraint instanceof GroupConstraint) {
            this.iGroupConstraints.add((GroupConstraint)constraint);
        } else if (constraint instanceof FlexibleConstraint) {
            this.iFlexibleConstraints.add((FlexibleConstraint)constraint);
        }
    }

    @Override
    public void removeConstraint(Constraint<Lecture, Placement> constraint) {
        super.removeConstraint(constraint);
        if (constraint instanceof InstructorConstraint) {
            this.iInstructorConstraints.remove(constraint);
        } else if (constraint instanceof JenrlConstraint) {
            this.iJenrlConstraints.remove(constraint);
        } else if (constraint instanceof RoomConstraint) {
            this.iRoomConstraints.remove(constraint);
        } else if (constraint instanceof DepartmentSpreadConstraint) {
            this.iDepartmentSpreadConstraints.remove(constraint);
        } else if (constraint instanceof SpreadConstraint) {
            this.iSpreadConstraints.remove(constraint);
        } else if (constraint instanceof ClassLimitConstraint) {
            this.iClassLimitConstraints.remove(constraint);
        } else if (constraint instanceof GroupConstraint) {
            this.iGroupConstraints.remove(constraint);
        } else if (constraint instanceof FlexibleConstraint) {
            this.iFlexibleConstraints.remove(constraint);
        }
    }

    public List<InstructorConstraint> getInstructorConstraints() {
        return this.iInstructorConstraints;
    }

    public List<GroupConstraint> getGroupConstraints() {
        return this.iGroupConstraints;
    }

    public List<JenrlConstraint> getJenrlConstraints() {
        return this.iJenrlConstraints;
    }

    public List<RoomConstraint> getRoomConstraints() {
        return this.iRoomConstraints;
    }

    public List<DepartmentSpreadConstraint> getDepartmentSpreadConstraints() {
        return this.iDepartmentSpreadConstraints;
    }

    public List<SpreadConstraint> getSpreadConstraints() {
        return this.iSpreadConstraints;
    }

    public List<ClassLimitConstraint> getClassLimitConstraints() {
        return this.iClassLimitConstraints;
    }

    public List<FlexibleConstraint> getFlexibleConstraints() {
        return this.iFlexibleConstraints;
    }

    @Override
    public double getTotalValue() {
        double ret = 0.0;
        for (Criterion criterion : this.getCriteria()) {
            ret += criterion.getWeightedValue();
        }
        return ret;
    }

    @Override
    public double getTotalValue(Collection<Lecture> variables) {
        double ret = 0.0;
        for (Criterion criterion : this.getCriteria()) {
            ret += criterion.getWeightedValue(variables);
        }
        return ret;
    }

    public int getYear() {
        return this.iYear;
    }

    public void setYear(int year) {
        this.iYear = year;
    }

    public Set<Student> getAllStudents() {
        return this.iAllStudents;
    }

    public void addStudent(Student student) {
        this.iAllStudents.add(student);
    }

    public void removeStudent(Student student) {
        this.iAllStudents.remove(student);
    }

    public static synchronized String getMem() {
        Runtime rt = Runtime.getRuntime();
        return sDoubleFormat.format((double)(rt.totalMemory() - rt.freeMemory()) / 1048576.0) + "M";
    }

    public Set<Placement> conflictValuesSkipWeakeningConstraints(Placement value) {
        HashSet<Placement> conflictValues = new HashSet<Placement>();
        for (Constraint constraint : ((Lecture)value.variable()).hardConstraints()) {
            if (constraint instanceof WeakeningConstraint) continue;
            constraint.computeConflicts(value, conflictValues);
        }
        for (GlobalConstraint globalConstraint : this.globalConstraints()) {
            if (globalConstraint instanceof WeakeningConstraint) continue;
            globalConstraint.computeConflicts(value, conflictValues);
        }
        return conflictValues;
    }

    public List<BitSet> getWeeks() {
        if (this.iWeeks == null) {
            String defaultDatePattern = this.getProperties().getProperty("DatePattern.CustomDatePattern", null);
            if (defaultDatePattern == null) {
                defaultDatePattern = this.getProperties().getProperty("DatePattern.Default");
            }
            if (defaultDatePattern == null) {
                return null;
            }
            BitSet fullTerm = new BitSet(defaultDatePattern.length());
            for (int i = 0; i < defaultDatePattern.length(); ++i) {
                if (defaultDatePattern.charAt(i) != '1') continue;
                fullTerm.set(i);
            }
            this.iWeeks = new ArrayList<BitSet>();
            int cnt = 0;
            for (int i = 0; i < fullTerm.length(); ++i) {
                if (!fullTerm.get(i)) continue;
                int w = cnt++ / 7;
                if (this.iWeeks.size() == w) {
                    this.iWeeks.add(new BitSet(fullTerm.length()));
                }
                this.iWeeks.get(w).set(i);
            }
        }
        return this.iWeeks;
    }
}

