/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.coursett.model;

import java.util.Collection;
import java.util.List;
import net.sf.cpsolver.coursett.model.Configuration;
import net.sf.cpsolver.coursett.model.FinalSectioning;
import net.sf.cpsolver.coursett.model.InitialSectioning;
import net.sf.cpsolver.coursett.model.Lecture;
import net.sf.cpsolver.coursett.model.Student;
import net.sf.cpsolver.coursett.model.StudentSectioning;
import net.sf.cpsolver.coursett.model.TimetableModel;
import net.sf.cpsolver.ifs.util.Progress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultStudentSectioning
implements StudentSectioning {
    protected TimetableModel iModel = null;
    private Progress iProgress = null;
    protected FinalSectioning iFinalSectioning = null;

    public DefaultStudentSectioning(TimetableModel model) {
        this.iModel = model;
        this.iFinalSectioning = new FinalSectioning(model);
    }

    public Progress getProgress() {
        if (this.iProgress == null) {
            this.iProgress = Progress.getInstance(this.iModel);
        }
        return this.iProgress;
    }

    @Override
    public void initialSectioning(Long offeringId, String courseName, Collection<Student> students, Collection<Configuration> configurations) {
        if (students == null || students.isEmpty()) {
            return;
        }
        if (configurations == null || configurations.isEmpty()) {
            return;
        }
        if (configurations.size() == 1) {
            Configuration cfg = configurations.iterator().next();
            for (Student st : students) {
                st.addConfiguration(cfg);
            }
            for (Long subpartId : cfg.getTopSubpartIds()) {
                this.initialSectioningLectures(offeringId, courseName, students, cfg.getTopLectures(subpartId));
            }
        } else {
            this.getProgress().trace("sectioning " + students.size() + " students of course " + courseName + " into " + configurations.size() + " configurations");
            InitialSectioning.Group[] studentsPerSection = this.studentsToConfigurations(offeringId, students, configurations);
            for (int i = 0; i < configurations.size(); ++i) {
                InitialSectioning.Group group = studentsPerSection[i];
                this.getProgress().trace(i + 1 + ". configuration got " + group.getStudents().size() + " students (weighted=" + group.size() + ", cfgLimit=" + group.getConfiguration().getLimit() + ")");
                for (Student st : group.getStudents()) {
                    st.addConfiguration(group.getConfiguration());
                }
                for (Long subpartId : group.getConfiguration().getTopSubpartIds()) {
                    this.initialSectioningLectures(offeringId, courseName, group.getStudents(), group.getConfiguration().getTopLectures(subpartId));
                }
            }
        }
    }

    protected String getClassLabel(Lecture lecture) {
        return "<A href='classDetail.do?cid=" + lecture.getClassId() + "'>" + lecture.getName() + "</A>";
    }

    /*
     * WARNING - void declaration
     */
    protected void initialSectioningLectures(Long offeringId, String courseName, Collection<Student> students, Collection<Lecture> lectures) {
        block14: {
            void var6_10;
            block13: {
                if (lectures == null || lectures.isEmpty()) {
                    return;
                }
                if (students == null || students.isEmpty()) {
                    return;
                }
                for (Lecture lecture : lectures) {
                    if (lecture.classLimit() != 0 || lecture.isCommitted()) continue;
                    this.getProgress().warn("Class " + this.getClassLabel(lecture) + " has zero class limit.");
                }
                this.getProgress().trace("sectioning " + students.size() + " students of course " + courseName + " into " + lectures.size() + " sections");
                if (lectures.size() != 1) break block13;
                Lecture lect = lectures.iterator().next();
                for (Student st : students) {
                    if (!st.canEnroll(lect)) {
                        this.getProgress().info("Unable to enroll student " + st.getId() + " in class " + this.getClassLabel(lect));
                    }
                    lect.addStudent(st);
                    st.addLecture(lect);
                }
                if (!lect.hasAnyChildren()) break block14;
                for (Long subpartId : lect.getChildrenSubpartIds()) {
                    List<Lecture> children = lect.getChildren(subpartId);
                    this.initialSectioningLectures(offeringId, lect.getName(), students, children);
                }
                break block14;
            }
            InitialSectioning.Group[] studentsPerSection = this.studentsToLectures(offeringId, students, lectures);
            boolean bl = false;
            while (var6_10 < studentsPerSection.length) {
                InitialSectioning.Group group = studentsPerSection[var6_10];
                Lecture lect = group.getLecture();
                if (group.getStudents().isEmpty()) {
                    this.getProgress().trace("Lecture " + this.getClassLabel(lect) + " got no students (cl=" + lect.classLimit() + ")");
                } else {
                    this.getProgress().trace("Lecture " + this.getClassLabel(lect) + " got " + group.getStudents().size() + " students (weighted=" + group.size() + ", classLimit=" + lect.classLimit() + ")");
                    List<Student> studentsThisSection = group.getStudents();
                    for (Student st : studentsThisSection) {
                        if (!st.canEnroll(lect)) {
                            this.getProgress().info("Unable to enroll student " + st.getId() + " in class " + this.getClassLabel(lect));
                        }
                        lect.addStudent(st);
                        st.addLecture(lect);
                    }
                    if (lect.hasAnyChildren()) {
                        for (Long subpartId : lect.getChildrenSubpartIds()) {
                            List<Lecture> children = lect.getChildren(subpartId);
                            this.initialSectioningLectures(offeringId, lect.getName(), studentsThisSection, children);
                        }
                    }
                }
                ++var6_10;
            }
        }
    }

    protected InitialSectioning.Group[] studentsToConfigurations(Long offeringId, Collection<Student> students, Collection<Configuration> configurations) {
        InitialSectioning sect = new InitialSectioning(this.getProgress(), offeringId, configurations, students);
        return sect.getGroups();
    }

    protected InitialSectioning.Group[] studentsToLectures(Long offeringId, Collection<Student> students, Collection<Lecture> lectures) {
        InitialSectioning sect = new InitialSectioning(this.getProgress(), offeringId, lectures, students);
        return sect.getGroups();
    }

    @Override
    public boolean hasFinalSectioning() {
        return true;
    }

    @Override
    public void switchStudents(TimetableModel model) {
        this.iFinalSectioning.run();
    }

    @Override
    public void resection(Lecture lecture, boolean recursive, boolean configAsWell) {
        this.iFinalSectioning.resection(lecture, recursive, configAsWell);
    }
}

