/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.coursett.heuristics;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.sf.cpsolver.coursett.criteria.TimetablingCriterion;
import net.sf.cpsolver.coursett.heuristics.HeuristicSelector;
import net.sf.cpsolver.coursett.model.Lecture;
import net.sf.cpsolver.coursett.model.Placement;
import net.sf.cpsolver.coursett.model.TimetableModel;
import net.sf.cpsolver.ifs.criteria.Criterion;
import net.sf.cpsolver.ifs.extension.Extension;
import net.sf.cpsolver.ifs.extension.MacPropagation;
import net.sf.cpsolver.ifs.heuristics.ValueSelection;
import net.sf.cpsolver.ifs.solution.Solution;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.ToolBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlacementSelection
implements ValueSelection<Lecture, Placement> {
    static final int NR_LEVELS = 3;
    private static final double PRECISION = 1.0;
    private static boolean USE_THRESHOLD = true;
    private boolean iUseThreshold = USE_THRESHOLD;
    private double iGoodSelectionProb;
    public static final String GOOD_SELECTION_PROB = "Placement.GoodSelectionProb";
    private double iRandomWalkProb;
    public static final String RW_SELECTION_PROB = "Placement.RandomWalkProb";
    private double iInitialSelectionProb;
    public static final String INITIAL_SELECTION_PROB = "Placement.MPP_InitialProb";
    private int iMPPLimit;
    public static final String NR_MPP_LIMIT = "Placement.MPP_Limit";
    private double iMPPPenaltyLimit;
    public static final String NR_MPP_PENALTY_LIMIT = "Placement.MPP_PenaltyLimit";
    private double[] iThresholdKoef = new double[3];
    public static final String NR_THRESHOLD_KOEF = "Placement.ThresholdKoef";
    private int iTabuSize = 0;
    private ArrayList<Placement> iTabu = null;
    private int iTabuPos = 0;
    public static final String TABU_LENGTH = "Placement.TabuLength";
    private MacPropagation<Lecture, Placement> iProp = null;
    private boolean iRW = false;
    private boolean iMPP = false;
    private boolean iCanUnassingSingleton = false;

    @Override
    public void init(Solver<Lecture, Placement> solver) {
        for (Extension<Lecture, Placement> extension : solver.getExtensions()) {
            if (!MacPropagation.class.isInstance(extension)) continue;
            this.iProp = (MacPropagation)extension;
        }
    }

    public PlacementSelection(DataProperties properties) {
        this.iMPP = properties.getPropertyBoolean("General.MPP", false);
        this.iRW = properties.getPropertyBoolean("General.RandomWalk", true);
        this.iCanUnassingSingleton = properties.getPropertyBoolean("Placement.CanUnassingSingleton", this.iCanUnassingSingleton);
        this.iRandomWalkProb = this.iRW ? properties.getPropertyDouble(RW_SELECTION_PROB, 0.0) : 0.0;
        this.iGoodSelectionProb = properties.getPropertyDouble(GOOD_SELECTION_PROB, 1.0);
        this.iInitialSelectionProb = this.iMPP ? properties.getPropertyDouble(INITIAL_SELECTION_PROB, 0.75) : 0.0;
        this.iMPPLimit = this.iMPP ? properties.getPropertyInt(NR_MPP_LIMIT, -1) : -1;
        this.iMPPPenaltyLimit = this.iMPP ? properties.getPropertyDouble(NR_MPP_PENALTY_LIMIT, -1.0) : -1.0;
        this.iTabuSize = properties.getPropertyInt(TABU_LENGTH, -1);
        if (this.iTabuSize > 0) {
            this.iTabu = new ArrayList(this.iTabuSize);
        }
        this.iUseThreshold = properties.getPropertyBoolean("Placement.UseThreshold", USE_THRESHOLD);
        for (int level = 0; level < 3; ++level) {
            this.iThresholdKoef[level] = USE_THRESHOLD ? properties.getPropertyDouble(NR_THRESHOLD_KOEF + (level + 1), level == 0 ? 0.1 : 0.0) : 0.0;
        }
    }

    @Override
    public Placement selectValue(Solution<Lecture, Placement> solution, Lecture var) {
        Placement ret;
        Set<Placement> goodValues;
        if (var == null) {
            return null;
        }
        Lecture selectedVariable = var;
        TimetableModel model = (TimetableModel)solution.getModel();
        if (selectedVariable.getInitialAssignment() != null && (this.iMPPLimit >= 0 && model.perturbVariables().size() >= this.iMPPLimit ? !this.containsItselfSingletonOrCommited(model, model.conflictValues(selectedVariable.getInitialAssignment()), (Placement)selectedVariable.getInitialAssignment()) : (this.iMPPPenaltyLimit >= 0.0 && solution.getPerturbationsCounter() != null && solution.getPerturbationsCounter().getPerturbationPenalty(model) > this.iMPPPenaltyLimit ? !this.containsItselfSingletonOrCommited(model, model.conflictValues(selectedVariable.getInitialAssignment()), (Placement)selectedVariable.getInitialAssignment()) : selectedVariable.getInitialAssignment() != null && ToolBox.random() <= this.iInitialSelectionProb && !this.containsItselfSingletonOrCommited(model, model.conflictValues(selectedVariable.getInitialAssignment()), (Placement)selectedVariable.getInitialAssignment())))) {
            return (Placement)selectedVariable.getInitialAssignment();
        }
        List<Placement> values = selectedVariable.values();
        if (this.iRW && ToolBox.random() <= this.iRandomWalkProb) {
            for (int i = 0; i < 5; ++i) {
                Placement ret2 = ToolBox.random(values);
                if (this.containsItselfSingletonOrCommited(model, model.conflictValues(ret2), ret2)) continue;
                return ret2;
            }
        }
        if (this.iProp != null && selectedVariable.getAssignment() == null && ToolBox.random() <= this.iGoodSelectionProb && !(goodValues = this.iProp.goodValues(selectedVariable)).isEmpty()) {
            values = new ArrayList<Placement>(goodValues);
        }
        if (values.size() == 1 && !this.containsItselfSingletonOrCommited(model, model.conflictValues(ret = values.get(0)), ret)) {
            return ret;
        }
        long[] bestCost = new long[3];
        ArrayList<Placement> selectionValues = null;
        HeuristicSelector<Placement> selector = this.iUseThreshold ? new HeuristicSelector<Placement>(this.iThresholdKoef) : null;
        for (Placement value : values) {
            int level;
            Object conflicts;
            if (this.iTabu != null && this.iTabu.contains(value) || selectedVariable.getAssignment() != null && ((Placement)selectedVariable.getAssignment()).equals(value) || this.containsItselfSingletonOrCommited(model, (Set<Placement>)(conflicts = ((Lecture)value.variable()).getModel().conflictValues(value)), value)) continue;
            if (this.iUseThreshold) {
                Double flt = selector.firstLevelThreshold();
                double[] costs = new double[3];
                for (level = 0; level < 3; ++level) {
                    costs[level] = this.getCost(level, value, (Set<Placement>)conflicts);
                    if (level == 0 && flt != null && costs[0] > flt) break;
                }
                if (flt != null && costs[0] > flt) continue;
                selector.add(costs, value);
                continue;
            }
            boolean fail = false;
            boolean best = false;
            for (level = 0; !fail && level < 1; ++level) {
                double val = this.getCost(level, value, (Set<Placement>)conflicts);
                long cost = Math.round(1.0 * val);
                if (selectionValues != null && !best) {
                    if (cost > bestCost[level]) {
                        fail = true;
                    }
                    if (cost >= bestCost[level]) continue;
                    bestCost[level] = cost;
                    selectionValues.clear();
                    best = true;
                    continue;
                }
                bestCost[level] = cost;
            }
            if (selectionValues == null) {
                selectionValues = new ArrayList<Placement>(values.size());
            }
            if (fail) continue;
            selectionValues.add(value);
        }
        Placement selectedValue = null;
        if (this.iUseThreshold) {
            List<HeuristicSelector.Element> selectionElements = selector.selection();
            if (selectedVariable.getInitialAssignment() != null) {
                for (HeuristicSelector.Element element : selectionElements) {
                    Placement value = (Placement)element.getObject();
                    if (!value.equals(selectedVariable.getInitialAssignment())) continue;
                    selectedValue = value;
                    break;
                }
            }
            if (selectedValue == null) {
                HeuristicSelector.Element selection = ToolBox.random(selectionElements);
                selectedValue = selection == null ? null : (Placement)selection.getObject();
            }
        } else {
            if (selectedVariable.getInitialAssignment() != null && selectionValues.contains(selectedVariable.getInitialAssignment())) {
                return (Placement)selectedVariable.getInitialAssignment();
            }
            selectedValue = (Placement)ToolBox.random(selectionValues);
        }
        if (selectedValue != null && this.iTabu != null) {
            if (this.iTabu.size() == this.iTabuPos) {
                this.iTabu.add(selectedValue);
            } else {
                this.iTabu.set(this.iTabuPos, selectedValue);
            }
            this.iTabuPos = (this.iTabuPos + 1) % this.iTabuSize;
        }
        return selectedValue;
    }

    public boolean containsItselfSingletonOrCommited(TimetableModel model, Set<Placement> values, Placement selectedValue) {
        if (values.contains(selectedValue)) {
            return true;
        }
        if (model.hasConstantVariables()) {
            for (Placement placement : values) {
                Lecture lecture = (Lecture)placement.variable();
                if (lecture.isCommitted()) {
                    return true;
                }
                if (this.iCanUnassingSingleton || !lecture.isSingleton()) continue;
                return true;
            }
            return false;
        }
        if (this.iCanUnassingSingleton) {
            return false;
        }
        for (Placement placement : values) {
            Lecture lecture = (Lecture)placement.variable();
            if (!lecture.isSingleton()) continue;
            return true;
        }
        return false;
    }

    private double getCost(int level, Placement value, Set<Placement> conflicts) {
        double ret = 0.0;
        for (Criterion criterion : ((Lecture)value.variable()).getModel().getCriteria()) {
            if (criterion instanceof TimetablingCriterion) {
                double w = ((TimetablingCriterion)criterion).getPlacementSelectionWeight(level);
                if (w == 0.0) continue;
                ret += w * criterion.getValue(value, conflicts);
                continue;
            }
            ret += criterion.getWeightedValue(value, conflicts);
        }
        return ret;
    }
}

